/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.ExecutableQuery;
import org.exoplatform.services.jcr.impl.core.query.PropertyTypeRegistry;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;

public abstract class AbstractQueryImpl
implements ExecutableQuery {
    protected final SessionImpl session;
    protected final SessionDataManager itemMgr;
    protected final SearchIndex index;
    protected final PropertyTypeRegistry propReg;
    private boolean documentOrder = true;
    private boolean caseInsensitiveOrder;
    private final Set variableNames = new HashSet();
    private final Map bindValues = new HashMap();

    public AbstractQueryImpl(SessionImpl session, SessionDataManager itemMgr, SearchIndex index, PropertyTypeRegistry propReg) {
        this.session = session;
        this.itemMgr = itemMgr;
        this.index = index;
        this.propReg = propReg;
    }

    public boolean getRespectDocumentOrder() {
        return this.documentOrder;
    }

    public void setRespectDocumentOrder(boolean documentOrder) {
        this.documentOrder = documentOrder;
    }

    public void setCaseInsensitiveOrder(boolean caseInsensitiveOrder) {
        this.caseInsensitiveOrder = caseInsensitiveOrder;
    }

    public boolean isCaseInsensitiveOrder() {
        return this.caseInsensitiveOrder;
    }

    public void bindValue(InternalQName varName, Value value) throws IllegalArgumentException, RepositoryException {
        if (!this.variableNames.contains((Object)varName)) {
            throw new IllegalArgumentException("not a valid variable in this query");
        }
        this.bindValues.put(varName, value);
    }

    protected void addVariableName(InternalQName varName) {
        this.variableNames.add(varName);
    }

    protected Map getBindVariableValues() {
        return Collections.unmodifiableMap(this.bindValues);
    }

    public abstract boolean needsSystemTree();
}

