/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.value;

import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;

public class PathValue
extends BaseValue {
    public static final int TYPE = 8;
    private final LocationFactory locationFactory;

    public PathValue(QPath path, LocationFactory locationFactory) throws IOException {
        super(8, new TransientValueData(path));
        this.locationFactory = locationFactory;
    }

    public PathValue(ValueData data, LocationFactory locationFactory) throws IOException, RepositoryException {
        super(8, data);
        this.locationFactory = locationFactory;
    }

    public String getString() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.locationFactory.createJCRPath(this.getQPath()).getAsString(false);
    }

    public QPath getQPath() throws RepositoryException {
        return ValueDataUtil.getPath(this.getInternalData());
    }
}

