/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.FastAddPlainChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PersistentDataManager;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListenerFilter;
import org.exoplatform.services.jcr.dataflow.persistent.MandatoryItemsPersistenceListener;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedItemData;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedNodeData;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableResourceManager;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableResourceManagerListener;
import org.exoplatform.services.jcr.impl.storage.SystemDataContainerHolder;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkspacePersistentDataManager
implements PersistentDataManager {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.WorkspacePersistentDataManager");
    protected final WorkspaceDataContainer dataContainer;
    protected final WorkspaceDataContainer systemDataContainer;
    protected final List<ItemsPersistenceListener> listeners;
    protected final List<MandatoryItemsPersistenceListener> mandatoryListeners;
    protected final List<ItemsPersistenceListenerFilter> listenerFilters;
    private final TransactionableResourceManager txResourceManager;
    protected final TransactionManager transactionManager;

    protected WorkspacePersistentDataManager(WorkspaceDataContainer dataContainer, SystemDataContainerHolder systemDataContainerHolder) {
        this(dataContainer, systemDataContainerHolder, null, null);
    }

    public WorkspacePersistentDataManager(WorkspaceDataContainer dataContainer, SystemDataContainerHolder systemDataContainerHolder, TransactionableResourceManager txResourceManager, TransactionManager transactionManager) {
        this.dataContainer = dataContainer;
        this.systemDataContainer = systemDataContainerHolder.getContainer();
        this.listeners = new ArrayList<ItemsPersistenceListener>();
        this.mandatoryListeners = new ArrayList<MandatoryItemsPersistenceListener>();
        this.listenerFilters = new ArrayList<ItemsPersistenceListenerFilter>();
        this.txResourceManager = txResourceManager;
        this.transactionManager = transactionManager;
    }

    public void save(ChangesLogWrapper logWrapper) throws RepositoryException {
        this.save(logWrapper, this.txResourceManager);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void save(ChangesLogWrapper logWrapper, TransactionableResourceManager txResourceManager) throws RepositoryException {
        ItemStateChangesLog changesLog = logWrapper.optimizeAndGetChangesLog();
        ChangesLogPersister persister = new ChangesLogPersister();
        boolean failed = true;
        ConnectionMode mode = this.getMode(txResourceManager);
        try {
            try {
                if (!(changesLog instanceof TransactionChangesLog)) throw new RepositoryException("Unsupported changes log class " + changesLog.getClass());
                TransactionChangesLog orig = (TransactionChangesLog)changesLog;
                TransactionChangesLog persisted = new TransactionChangesLog();
                persisted.setSystemId(orig.getSystemId());
                ChangesLogIterator iter = orig.getLogIterator();
                while (iter.hasNextLog()) {
                    persisted.addLog(persister.save(iter.nextLog()));
                }
                TransactionChangesLog persistedLog = persisted;
                logWrapper.setLog(persistedLog);
                persister.prepare();
                this.notifySaveItems(persistedLog, true);
                this.onCommit(persister, mode, txResourceManager);
                failed = false;
            }
            catch (IOException e) {
                throw new RepositoryException("Save error", (Throwable)e);
            }
            Object var12_12 = null;
            persister.clear();
            if (!failed) return;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            persister.clear();
            if (!failed) throw throwable;
            persister.rollback();
            throw throwable;
        }
        persister.rollback();
    }

    private ConnectionMode getMode(TransactionableResourceManager txResourceManager) {
        if (txResourceManager != null && txResourceManager.isGlobalTxActive()) {
            return ConnectionMode.GLOBAL_TX;
        }
        if (this.transactionManager != null) {
            return ConnectionMode.WITH_TRANSACTION_MANAGER;
        }
        return ConnectionMode.NORMAL;
    }

    private void onCommit(final ChangesLogPersister persister, ConnectionMode mode, TransactionableResourceManager txResourceManager) throws RepositoryException {
        if (mode == ConnectionMode.NORMAL) {
            persister.commit();
        } else if (mode == ConnectionMode.WITH_TRANSACTION_MANAGER) {
            try {
                this.transactionManager.getTransaction().registerSynchronization(new Synchronization(){

                    public void beforeCompletion() {
                    }

                    public void afterCompletion(int status) {
                        switch (status) {
                            case 3: {
                                try {
                                    persister.commit();
                                    break;
                                }
                                catch (Exception e) {
                                    throw new RuntimeException("Could not commit the transaction", e);
                                }
                            }
                            case 5: {
                                LOG.warn((Object)"Status UNKNOWN received in afterCompletion method, some data could have been corrupted !!");
                            }
                            case 1: 
                            case 4: {
                                try {
                                    persister.rollback();
                                }
                                catch (Exception e) {
                                    LOG.error((Object)"Could not roll back the transaction", (Throwable)e);
                                }
                                break;
                            }
                            default: {
                                throw new IllegalStateException("illegal status: " + status);
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                throw new RepositoryException("Cannot register the synchronization for a late commit", (Throwable)e);
            }
        } else if (mode == ConnectionMode.GLOBAL_TX) {
            txResourceManager.addListener(new TransactionableResourceManagerListener(){

                public void onCommit(boolean onePhase) throws Exception {
                    persister.commit();
                }

                public void onAfterCompletion(int status) throws Exception {
                }

                public void onAbort() throws Exception {
                    persister.rollback();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemData getItemData(String identifier) throws RepositoryException {
        ItemData itemData;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            itemData = con.getItemData(identifier);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return itemData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getReferencesData(String identifier, boolean skipVersionStorage) throws RepositoryException {
        ArrayList<PropertyData> arrayList;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            List<PropertyData> allRefs = con.getReferencesData(identifier);
            ArrayList<PropertyData> refProps = new ArrayList<PropertyData>();
            for (int i = 0; i < allRefs.size(); ++i) {
                PropertyData ref = allRefs.get(i);
                if (skipVersionStorage) {
                    if (ref.getQPath().isDescendantOf(Constants.JCR_VERSION_STORAGE_PATH)) continue;
                    refProps.add(ref);
                    continue;
                }
                refProps.add(ref);
            }
            arrayList = refProps;
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeData> getChildNodesData(NodeData nodeData) throws RepositoryException {
        List<NodeData> list;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            list = con.getChildNodesData(nodeData);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getChildNodesDataByPage(NodeData nodeData, int fromOrderNum, int toOrderNum, List<NodeData> childNodes) throws RepositoryException {
        boolean bl;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            bl = con.getChildNodesDataByPage(nodeData, fromOrderNum, toOrderNum, childNodes);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeData> getChildNodesData(NodeData nodeData, List<QPathEntryFilter> patternFilters) throws RepositoryException {
        List<NodeData> list;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            list = con.getChildNodesData(nodeData, patternFilters);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLastOrderNumber(NodeData nodeData) throws RepositoryException {
        int n;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            n = con.getLastOrderNumber(nodeData);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChildNodesCount(NodeData parent) throws RepositoryException {
        int n;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            n = con.getChildNodesCount(parent);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getChildPropertiesData(NodeData nodeData) throws RepositoryException {
        List<PropertyData> list;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            list = con.getChildPropertiesData(nodeData);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getChildPropertiesData(NodeData nodeData, List<QPathEntryFilter> itemDataFilters) throws RepositoryException {
        List<PropertyData> list;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            list = con.getChildPropertiesData(nodeData, itemDataFilters);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> listChildPropertiesData(NodeData nodeData) throws RepositoryException {
        List<PropertyData> list;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            list = con.listChildPropertiesData(nodeData);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSameNameSibling(NodeData node, WorkspaceStorageConnection con, Set<QPath> addedNodes) throws RepositoryException {
        block5: {
            if (node.getQPath().getIndex() > 1) {
                QPathEntry[] path = node.getQPath().getEntries();
                QPathEntry[] siblingPath = new QPathEntry[path.length];
                int li = path.length - 1;
                System.arraycopy(path, 0, siblingPath, 0, li);
                siblingPath[li] = new QPathEntry(path[li], path[li].getIndex() - 1);
                if (addedNodes.contains(new QPath(siblingPath))) {
                    return;
                }
                if (this.dataContainer.isCheckSNSNewConnection()) {
                    WorkspaceStorageConnection acon = this.dataContainer.openConnection();
                    try {
                        this.checkPersistedSNS(node, acon);
                        Object var9_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        acon.close();
                        throw throwable;
                    }
                    acon.close();
                    {
                        break block5;
                    }
                }
                this.checkPersistedSNS(node, con);
            }
        }
    }

    private void checkPersistedSNS(NodeData node, WorkspaceStorageConnection acon) throws RepositoryException {
        QPathEntry myName;
        NodeData parent = (NodeData)acon.getItemData(node.getParentIdentifier());
        ItemData sibling = acon.getItemData(parent, new QPathEntry((myName = node.getQPath().getEntries()[node.getQPath().getEntries().length - 1]).getNamespace(), myName.getName(), myName.getIndex() - 1), ItemType.NODE);
        if (sibling == null || !sibling.isNode()) {
            throw new InvalidItemStateException("Node can't be saved " + node.getQPath().getAsString() + ". No same-name sibling exists with index " + (myName.getIndex() - 1) + ".");
        }
    }

    protected void doDelete(ItemData item, WorkspaceStorageConnection con) throws RepositoryException, InvalidItemStateException {
        if (item.isNode()) {
            con.delete((NodeData)item);
        } else {
            con.delete((PropertyData)item);
        }
    }

    protected void doUpdate(ItemData item, WorkspaceStorageConnection con) throws RepositoryException, InvalidItemStateException {
        if (item.isNode()) {
            con.update((NodeData)item);
        } else {
            con.update((PropertyData)item);
        }
    }

    protected void doAdd(ItemData item, WorkspaceStorageConnection con, Set<QPath> addedNodes) throws RepositoryException, InvalidItemStateException {
        if (item.isNode()) {
            NodeData node = (NodeData)item;
            this.checkSameNameSibling(node, con, addedNodes);
            addedNodes.add(node.getQPath());
            con.add(node);
        } else {
            con.add((PropertyData)item);
        }
    }

    protected void doRename(ItemData item, WorkspaceStorageConnection con, Set<QPath> addedNodes) throws RepositoryException, InvalidItemStateException {
        NodeData node = (NodeData)item;
        this.checkSameNameSibling(node, con, addedNodes);
        addedNodes.add(node.getQPath());
        con.rename(node);
    }

    public Calendar getCurrentTime() {
        return this.dataContainer.getCurrentTime();
    }

    @Override
    public void addItemPersistenceListener(ItemsPersistenceListener listener) {
        if (listener instanceof MandatoryItemsPersistenceListener) {
            this.mandatoryListeners.add((MandatoryItemsPersistenceListener)listener);
        } else {
            this.listeners.add(listener);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Workspace '" + this.dataContainer.getName() + "' listener registered: " + listener));
        }
    }

    @Override
    public void removeItemPersistenceListener(ItemsPersistenceListener listener) {
        if (listener instanceof MandatoryItemsPersistenceListener) {
            this.mandatoryListeners.remove(listener);
        } else {
            this.listeners.remove(listener);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Workspace '" + this.dataContainer.getName() + "' listener unregistered: " + listener));
        }
    }

    @Override
    public void addItemPersistenceListenerFilter(ItemsPersistenceListenerFilter filter) {
        this.listenerFilters.add(filter);
    }

    @Override
    public void removeItemPersistenceListenerFilter(ItemsPersistenceListenerFilter filter) {
        this.listenerFilters.remove(filter);
    }

    protected boolean isListenerAccepted(ItemsPersistenceListener listener) {
        for (ItemsPersistenceListenerFilter f : this.listenerFilters) {
            if (f.accept(listener)) continue;
            return false;
        }
        return true;
    }

    protected void notifySaveItems(ItemStateChangesLog changesLog, boolean isListenerTXAware) {
        for (MandatoryItemsPersistenceListener mlistener : this.mandatoryListeners) {
            if (mlistener.isTXAware() != isListenerTXAware) continue;
            mlistener.onSaveItems(changesLog);
        }
        for (ItemsPersistenceListener listener : this.listeners) {
            if (listener.isTXAware() != isListenerTXAware || !this.isListenerAccepted(listener)) continue;
            listener.onSaveItems(changesLog);
        }
    }

    private boolean isSystemDescendant(QPath path) {
        return path.isDescendantOf(Constants.JCR_SYSTEM_PATH) || path.equals(Constants.JCR_SYSTEM_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name, ItemType itemType) throws RepositoryException {
        ItemData itemData;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            itemData = con.getItemData(parentData, name, itemType);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return itemData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasItemData(NodeData parentData, QPathEntry name, ItemType itemType) throws RepositoryException {
        boolean bl;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            bl = con.hasItemData(parentData, name, itemType);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return bl;
    }

    class ChangesLogPersister {
        private final Set<QPath> addedNodes = new HashSet<QPath>();
        private WorkspaceStorageConnection thisConnection = null;
        private WorkspaceStorageConnection systemConnection = null;

        ChangesLogPersister() {
        }

        protected void commit() throws IllegalStateException, RepositoryException {
            if (this.thisConnection != null) {
                this.thisConnection.commit();
            }
            if (this.systemConnection != null && !this.systemConnection.equals(this.thisConnection)) {
                this.systemConnection.commit();
            }
        }

        protected void prepare() throws IllegalStateException, RepositoryException {
            if (this.thisConnection != null && this.thisConnection.isOpened()) {
                this.thisConnection.prepare();
            }
            if (this.systemConnection != null && !this.systemConnection.equals(this.thisConnection) && this.systemConnection.isOpened()) {
                this.systemConnection.prepare();
            }
        }

        protected void clear() {
            this.addedNodes.clear();
        }

        protected void rollback() throws IllegalStateException, RepositoryException {
            if (this.thisConnection != null && this.thisConnection.isOpened()) {
                this.thisConnection.rollback();
            }
            if (this.systemConnection != null && !this.systemConnection.equals(this.thisConnection) && this.systemConnection.isOpened()) {
                this.systemConnection.rollback();
            }
        }

        protected WorkspaceStorageConnection getSystemConnection() throws RepositoryException {
            WorkspaceStorageConnection workspaceStorageConnection;
            if (this.systemConnection == null) {
                WorkspaceStorageConnection workspaceStorageConnection2 = WorkspacePersistentDataManager.this.systemDataContainer != WorkspacePersistentDataManager.this.dataContainer ? (WorkspacePersistentDataManager.this.systemDataContainer.equals(WorkspacePersistentDataManager.this.dataContainer) && this.thisConnection != null ? WorkspacePersistentDataManager.this.systemDataContainer.reuseConnection(this.thisConnection) : WorkspacePersistentDataManager.this.systemDataContainer.openConnection(false)) : (this.thisConnection == null ? (this.thisConnection = WorkspacePersistentDataManager.this.dataContainer.openConnection(false)) : this.thisConnection);
                workspaceStorageConnection = this.systemConnection = workspaceStorageConnection2;
            } else {
                workspaceStorageConnection = this.systemConnection;
            }
            return workspaceStorageConnection;
        }

        protected WorkspaceStorageConnection getThisConnection() throws RepositoryException {
            WorkspaceStorageConnection workspaceStorageConnection;
            if (this.thisConnection == null) {
                WorkspaceStorageConnection workspaceStorageConnection2 = WorkspacePersistentDataManager.this.systemDataContainer != WorkspacePersistentDataManager.this.dataContainer ? (WorkspacePersistentDataManager.this.dataContainer.equals(WorkspacePersistentDataManager.this.systemDataContainer) && this.systemConnection != null ? WorkspacePersistentDataManager.this.dataContainer.reuseConnection(this.systemConnection) : WorkspacePersistentDataManager.this.dataContainer.openConnection(false)) : (this.systemConnection == null ? (this.systemConnection = WorkspacePersistentDataManager.this.dataContainer.openConnection(false)) : this.systemConnection);
                workspaceStorageConnection = this.thisConnection = workspaceStorageConnection2;
            } else {
                workspaceStorageConnection = this.thisConnection;
            }
            return workspaceStorageConnection;
        }

        protected PlainChangesLog save(PlainChangesLog changesLog) throws InvalidItemStateException, RepositoryException, IOException {
            PlainChangesLog newLog = FastAddPlainChangesLog.getInstance(changesLog);
            List<ItemState> states = changesLog.getAllStates();
            int length = states.size();
            for (int j = 0; j < length; ++j) {
                ItemData data;
                ItemData prevData;
                ItemData newData;
                ItemState prevState = states.get(j);
                if (prevState.getData() instanceof PersistedItemData) {
                    PersistedPropertyData propertyData;
                    List<ValueData> values;
                    newData = prevState.isDeleted() && prevState.getData() instanceof PersistedPropertyData ? ((values = (propertyData = (PersistedPropertyData)prevState.getData()).getValues()) != null && !values.isEmpty() ? new PersistedPropertyData(propertyData.getIdentifier(), propertyData.getQPath(), propertyData.getParentIdentifier(), propertyData.getPersistedVersion() + 1, propertyData.getType(), propertyData.isMultiValued(), null) : prevState.getData()) : prevState.getData();
                } else if (prevState.isNode()) {
                    prevData = (NodeData)prevState.getData();
                    newData = new PersistedNodeData(prevData.getIdentifier(), prevData.getQPath(), prevData.getParentIdentifier(), prevData.getPersistedVersion() + 1, prevData.getOrderNumber(), prevData.getPrimaryTypeName(), prevData.getMixinTypeNames(), prevData.getACL());
                } else {
                    prevData = (PropertyData)prevState.getData();
                    if (!prevState.isDeleted()) {
                        ArrayList<ValueData> values = new ArrayList<ValueData>();
                        for (int i = 0; i < prevData.getValues().size(); ++i) {
                            ValueData vd = prevData.getValues().get(i);
                            if (vd instanceof TransientValueData) {
                                TransientValueData tvd = (TransientValueData)vd;
                                PersistedValueData pvd = tvd.createPersistedCopy(i);
                                tvd.delegate((AbstractValueData)((Object)pvd));
                                values.add(pvd);
                                continue;
                            }
                            values.add(vd);
                        }
                        newData = new PersistedPropertyData(prevData.getIdentifier(), prevData.getQPath(), prevData.getParentIdentifier(), prevData.getPersistedVersion() + 1, prevData.getType(), prevData.isMultiValued(), values);
                    } else {
                        newData = new PersistedPropertyData(prevData.getIdentifier(), prevData.getQPath(), prevData.getParentIdentifier(), prevData.getPersistedVersion() + 1, prevData.getType(), prevData.isMultiValued(), null);
                    }
                }
                ItemState itemState = new ItemState(newData, prevState.getState(), prevState.isEventFire(), prevState.getAncestorToSave(), prevState.isInternallyCreated(), prevState.isPersisted(), prevState.getOldPath());
                newLog.add(itemState);
                if (!itemState.isPersisted()) continue;
                long start = 0L;
                if (LOG.isDebugEnabled()) {
                    start = System.currentTimeMillis();
                }
                WorkspaceStorageConnection conn = WorkspacePersistentDataManager.this.isSystemDescendant((data = itemState.getData()).getQPath()) ? this.getSystemConnection() : this.getThisConnection();
                if (itemState.isAdded()) {
                    WorkspacePersistentDataManager.this.doAdd(data, conn, this.addedNodes);
                } else if (itemState.isUpdated()) {
                    WorkspacePersistentDataManager.this.doUpdate(data, conn);
                } else if (itemState.isDeleted()) {
                    WorkspacePersistentDataManager.this.doDelete(data, conn);
                } else if (itemState.isRenamed()) {
                    WorkspacePersistentDataManager.this.doRename(data, conn, this.addedNodes);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)(ItemState.nameFromValue(itemState.getState()) + " " + (System.currentTimeMillis() - start) + "ms, " + data.getQPath().getAsString()));
            }
            return newLog;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConnectionMode {
        NORMAL,
        WITH_TRANSACTION_MANAGER,
        GLOBAL_TX;

    }

    protected class RemovableItemState {
        private boolean toBeRemoved;
        private final ItemState state;
        private final PlainChangesLogImpl changesLog;

        public RemovableItemState(ItemState state, PlainChangesLog changesLog) {
            this.state = state;
            this.changesLog = (PlainChangesLogImpl)changesLog;
        }

        public ItemState getState() {
            return this.state;
        }

        public PlainChangesLog getPlainChangesLog() {
            return this.changesLog;
        }

        public void markAsToBeRemoved() {
            this.toBeRemoved = true;
        }

        public boolean toBeRemoved() {
            return this.toBeRemoved;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ChangesLogWrapper
    implements ItemStateChangesLog {
        private ItemStateChangesLog log;

        ChangesLogWrapper(ItemStateChangesLog log) {
            this.log = log;
        }

        protected void setLog(ItemStateChangesLog log) {
            this.log = log;
        }

        protected ItemStateChangesLog getChangesLog() {
            return this.log;
        }

        protected ItemStateChangesLog optimizeAndGetChangesLog() {
            HashMap<String, LinkedList<RemovableItemState>> persistedCheckedStates = new HashMap<String, LinkedList<RemovableItemState>>();
            TransactionChangesLog orig = (TransactionChangesLog)this.log;
            ChangesLogIterator changesLogIterator = orig.getLogIterator();
            boolean skipOptimizeChangesLog = true;
            while (changesLogIterator.hasNextLog()) {
                PlainChangesLog changesLog = changesLogIterator.nextLog();
                List<ItemState> states = changesLog.getAllStates();
                int length = states.size();
                for (int i = 0; i < length; ++i) {
                    ItemState itemState = states.get(i);
                    if (!itemState.isPersisted() || itemState.isNode()) continue;
                    String pId = itemState.getData().getIdentifier();
                    LinkedList<RemovableItemState> removeItemStates = (LinkedList<RemovableItemState>)persistedCheckedStates.get(pId);
                    if (removeItemStates == null) {
                        removeItemStates = new LinkedList<RemovableItemState>();
                        persistedCheckedStates.put(pId, removeItemStates);
                    } else {
                        skipOptimizeChangesLog = false;
                    }
                    removeItemStates.add(new RemovableItemState(itemState, changesLog));
                }
            }
            if (!skipOptimizeChangesLog) {
                HashMap<PlainChangesLog, HashSet<ItemState>> itemsToBeRemoved = new HashMap<PlainChangesLog, HashSet<ItemState>>();
                for (LinkedList removableStates : persistedCheckedStates.values()) {
                    while (removableStates.size() > 1) {
                        RemovableItemState lastRemovableState = (RemovableItemState)removableStates.removeLast();
                        ItemState lastState = lastRemovableState.getState();
                        if (!lastState.isUpdated() && !lastState.isDeleted()) continue;
                        for (RemovableItemState removableCheckedState : removableStates) {
                            ItemState checkedState = removableCheckedState.getState();
                            if ((checkedState.isAdded() || checkedState.isUpdated()) && lastState.isDeleted()) {
                                removableCheckedState.markAsToBeRemoved();
                                if (checkedState.isAdded()) {
                                    lastRemovableState.markAsToBeRemoved();
                                }
                            } else if (checkedState.isAdded() && lastState.isUpdated()) {
                                removableCheckedState.markAsToBeRemoved();
                                lastState.makeStateAdded();
                            } else if (checkedState.isUpdated()) {
                                removableCheckedState.markAsToBeRemoved();
                            }
                            if (!removableCheckedState.toBeRemoved() && !lastRemovableState.toBeRemoved()) continue;
                            ArrayList<RemovableItemState> rItemStates = new ArrayList<RemovableItemState>(2);
                            if (removableCheckedState.toBeRemoved()) {
                                rItemStates.add(removableCheckedState);
                            }
                            if (lastRemovableState.toBeRemoved()) {
                                rItemStates.add(lastRemovableState);
                            }
                            int length = rItemStates.size();
                            for (int i = 0; i < length; ++i) {
                                RemovableItemState ris = (RemovableItemState)rItemStates.get(i);
                                HashSet<ItemState> items = (HashSet<ItemState>)itemsToBeRemoved.get(ris.getPlainChangesLog());
                                if (items == null) {
                                    items = new HashSet<ItemState>();
                                    itemsToBeRemoved.put(ris.getPlainChangesLog(), items);
                                }
                                items.add(ris.getState());
                            }
                        }
                        removableStates.clear();
                    }
                }
                TransactionChangesLog compressed = new TransactionChangesLog();
                compressed.setSystemId(orig.getSystemId());
                ChangesLogIterator iter = orig.getLogIterator();
                while (iter.hasNextLog()) {
                    PlainChangesLog changesLog = iter.nextLog();
                    Set statesToRemove = (Set)itemsToBeRemoved.get(changesLog);
                    if (statesToRemove != null) {
                        PlainChangesLog newLog = FastAddPlainChangesLog.getInstance(changesLog);
                        List<ItemState> states = changesLog.getAllStates();
                        int length = states.size();
                        for (int i = 0; i < length; ++i) {
                            ItemState is = states.get(i);
                            if (!statesToRemove.isEmpty() && statesToRemove.contains(is)) {
                                statesToRemove.remove(is);
                                continue;
                            }
                            newLog.add(is);
                        }
                        changesLog = newLog;
                    }
                    compressed.addLog(changesLog);
                }
                this.log = compressed;
                return this.log;
            }
            return this.log;
        }

        @Override
        public List<ItemState> getAllStates() {
            return this.log.getAllStates();
        }

        @Override
        public int getSize() {
            return this.log.getSize();
        }

        @Override
        public String dump() {
            return this.log.dump();
        }
    }
}

