/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.util.List;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.application.gadget.SourceStorage;
import org.exoplatform.application.gadget.impl.GadgetRegistryServiceImpl;
import org.exoplatform.application.registry.impl.ApplicationRegistryChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.upgrade.plugins.GadgetUpgrade;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradeLocalGadgetsPlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(UpgradeLocalGadgetsPlugin.class);
    private List<GadgetUpgrade> gadgets;
    protected RepositoryService repositoryService;
    protected ConfigurationManager configurationManager;
    protected SourceStorage sourceStorage;
    protected GadgetRegistryServiceImpl gadgetRegistryService;
    private ChromatticLifeCycle chromatticLifeCycle;

    public UpgradeLocalGadgetsPlugin(ConfigurationManager configurationManager, RepositoryService repositoryService, SourceStorage sourceStorage, GadgetRegistryService gadgetRegistryService, InitParams initParams, ChromatticManager chromatticManager) {
        super(initParams);
        this.gadgets = initParams.getObjectParamValues(GadgetUpgrade.class);
        this.repositoryService = repositoryService;
        this.configurationManager = configurationManager;
        this.sourceStorage = sourceStorage;
        this.gadgetRegistryService = (GadgetRegistryServiceImpl)gadgetRegistryService;
        ApplicationRegistryChromatticLifeCycle lifeCycle = (ApplicationRegistryChromatticLifeCycle)chromatticManager.getLifeCycle("app");
        this.chromatticLifeCycle = lifeCycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info((Object)("processing upgrading gadgets from version " + oldVersion + " to " + newVersion));
        try {
            for (GadgetUpgrade gadgetUpgrade : this.gadgets) {
                boolean done = true;
                this.chromatticLifeCycle.openContext();
                try {
                    Gadget gadget = this.gadgetRegistryService.getGadget(gadgetUpgrade.getName());
                    if (gadget == null) {
                        LOG.warn((Object)("Can't find gadget '" + gadgetUpgrade.getName() + "'."));
                        continue;
                    }
                    LOG.info((Object)("Start upgrading gadget " + gadgetUpgrade.getName() + " ..."));
                    try {
                        this.gadgetRegistryService.removeGadget(gadgetUpgrade.getName());
                        LOG.info((Object)("Upgrade of Gadget " + gadgetUpgrade.getName() + " is delegated to GadgetDeployer"));
                    }
                    catch (Exception noSuchGadgetException) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("gadget doesn't exist in the store: " + gadget.getName()));
                    }
                }
                catch (Exception exception) {
                    done = false;
                    LOG.error((Object)("Error while proceeding '" + gadgetUpgrade.getName() + "' gadget upgrade."), (Throwable)exception);
                }
                finally {
                    this.chromatticLifeCycle.closeContext(done);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Could not upgrade local gadget", (Throwable)e);
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

