/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.event;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.NewUserListener;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItem;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.core.model.SelectOption;
import org.exoplatform.webui.core.model.SelectOptionGroup;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormSelectBoxWithGroups;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/webui/create/UICreateEvent.gtmpl", events={@EventConfig(listeners={NextActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UICreateEvent
extends UIForm {
    public static final String PRIVATE_CALENDARS = "privateCalendar";
    public static final String SHARED_CALENDARS = "sharedCalendar";
    public static final String PUBLIC_CALENDARS = "publicCalendar";
    public static final String PRIVATE_TYPE = "0";
    public static final String SHARED_TYPE = "1";
    public static final String PUBLIC_TYPE = "2";
    public static final String COLON = ":";
    public static final String COMMA = ",";
    public static final String ANY = "*.*";
    public static final String ANY_OF = "*.";
    public static final String DOT = ".";
    public static final String SLASH_COLON = "/:";
    public static final String OPEN_PARENTHESIS = "(";
    public static final String CLOSE_PARENTHESIS = ")";
    private static Log log = ExoLogger.getLogger(UICreateEvent.class);
    static String CHOIX = "Choix";
    static String TITLE = "Title";
    public static String END_EVENT = "EndEvent";
    public static String CALENDAR = "Calendar";
    public static String START_EVENT = "StartEvent";
    public static String START_TIME = "start_time";
    public static String END_TIME = "end_time";
    public static String ALL_DAY = "all-day";
    private String calType_ = "0";
    public static final String TIMEFORMAT = "HH:mm";
    public static final String DISPLAY_TIMEFORMAT = "hh:mm a";
    public static final long DEFAULT_TIME_INTERVAL = 30L;

    public UICreateEvent() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(CHOIX, "Event", this.getTypeValue()));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(TITLE, TITLE, null));
        this.addUIFormInput((UIFormInput)new UIFormDateTimeInput(START_EVENT, START_EVENT, UICreateEvent.getInstanceOfCurrentCalendar().getTime(), false));
        this.addUIFormInput((UIFormInput)new UIFormDateTimeInput(END_EVENT, END_EVENT, UICreateEvent.getInstanceOfCurrentCalendar().getTime(), false));
        this.addUIFormInput((UIFormInput)new UIFormSelectBoxWithGroups(CALENDAR, CALENDAR, UICreateEvent.getCalendarOption()));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(START_TIME, START_TIME, UICreateEvent.getTimesSelectBoxOptions(DISPLAY_TIMEFORMAT)));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(END_TIME, END_TIME, UICreateEvent.getTimesSelectBoxOptions(DISPLAY_TIMEFORMAT)));
    }

    protected String getDateTimeFormat() {
        UIFormDateTimeInput fromField = (UIFormDateTimeInput)this.getChildById(START_EVENT);
        return fromField.getDatePattern_();
    }

    public Date getDateTime(UIFormDateTimeInput input, String selectId) throws Exception {
        String timeField = (String)this.getUIFormSelectBox(selectId).getValue();
        boolean isAllDate = ALL_DAY.equals(timeField);
        if (END_TIME.equals(selectId)) {
            return UICreateEvent.getEndDate(isAllDate, input.getDatePattern_(), (String)input.getValue(), TIMEFORMAT, timeField);
        }
        return UICreateEvent.getBeginDate(isAllDate, input.getDatePattern_(), (String)input.getValue(), TIMEFORMAT, timeField);
    }

    public static Date getBeginDate(boolean isAllDate, String dateFormat, String fromField, String timeFormat, String timeField) throws Exception {
        try {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            Locale locale = context.getParentAppRequestContext().getLocale();
            if (isAllDate) {
                SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
                df.setCalendar(UICreateEvent.getInstanceOfCurrentCalendar());
                return UICreateEvent.getBeginDay(df.parse(fromField)).getTime();
            }
            SimpleDateFormat df = new SimpleDateFormat(dateFormat + " " + timeFormat, locale);
            df.setCalendar(UICreateEvent.getInstanceOfCurrentCalendar());
            return df.parse(fromField + " " + timeField);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date getEndDate(boolean isAllDate, String dateFormat, String fromField, String timeFormat, String timeField) throws Exception {
        try {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            Locale locale = context.getParentAppRequestContext().getLocale();
            if (isAllDate) {
                SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
                df.setCalendar(UICreateEvent.getInstanceOfCurrentCalendar());
                return UICreateEvent.getEndDay(df.parse(fromField)).getTime();
            }
            SimpleDateFormat df = new SimpleDateFormat(dateFormat + " " + timeFormat, locale);
            df.setCalendar(UICreateEvent.getInstanceOfCurrentCalendar());
            return df.parse(fromField + " " + timeField);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CalendarSetting getCurrentUserCalendarSetting() {
        try {
            String user = UICreateEvent.getCurrentUser();
            CalendarSetting setting = UICreateEvent.getCalendarService().getCalendarSetting(user);
            return setting;
        }
        catch (Exception e) {
            log.warn((Object)"could not get calendar setting of user", (Throwable)e);
            return null;
        }
    }

    public static java.util.Calendar getInstanceOfCurrentCalendar() {
        try {
            CalendarSetting setting = UICreateEvent.getCurrentUserCalendarSetting();
            return UICreateEvent.getCalendarInstanceBySetting(setting);
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Could not get calendar setting!", (Throwable)e);
            }
            java.util.Calendar calendar = GregorianCalendar.getInstance();
            calendar.setLenient(false);
            return calendar;
        }
    }

    public static java.util.Calendar getCalendarInstanceBySetting(CalendarSetting calendarSetting) {
        java.util.Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        calendar.setTimeZone(TimeZone.getTimeZone(calendarSetting.getTimeZone()));
        calendar.setFirstDayOfWeek(Integer.parseInt(calendarSetting.getWeekStartOn()));
        calendar.setMinimalDaysInFirstWeek(4);
        return calendar;
    }

    public static java.util.Calendar getBeginDay(java.util.Calendar cal) {
        java.util.Calendar newCal = (java.util.Calendar)cal.clone();
        newCal.set(11, 0);
        newCal.set(12, 0);
        newCal.set(13, 0);
        newCal.set(14, 0);
        return newCal;
    }

    public static java.util.Calendar getEndDay(java.util.Calendar cal) {
        java.util.Calendar newCal = (java.util.Calendar)cal.clone();
        newCal.set(11, 0);
        newCal.set(12, 0);
        newCal.set(13, 0);
        newCal.set(14, 0);
        newCal.add(11, 24);
        return newCal;
    }

    public static java.util.Calendar getBeginDay(Date date) {
        java.util.Calendar cal = UICreateEvent.getInstanceOfCurrentCalendar();
        cal.setTime(date);
        return UICreateEvent.getBeginDay(cal);
    }

    public static java.util.Calendar getEndDay(Date date) {
        java.util.Calendar cal = UICreateEvent.getInstanceOfCurrentCalendar();
        cal.setTime(date);
        return UICreateEvent.getEndDay(cal);
    }

    private List<SelectItemOption<String>> getTypeValue() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption("Event", (Object)"Event"));
        options.add(new SelectItemOption("Task", (Object)"Task"));
        return options;
    }

    public static List<SelectItemOption<String>> getTimesSelectBoxOptions(String timeFormat) {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        return UICreateEvent.getTimesSelectBoxOptions(timeFormat, TIMEFORMAT, 30L, locale);
    }

    public static List<SelectItemOption<String>> getTimesSelectBoxOptions(String labelFormat, String valueFormat, long timeInteval) {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        return UICreateEvent.getTimesSelectBoxOptions(labelFormat, valueFormat, timeInteval, locale);
    }

    public static List<SelectItemOption<String>> getTimesSelectBoxOptions(String labelFormat, String valueFormat, long timeInteval, Locale locale) {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(UICreateEvent.getResourceBundle("UICreateEvent.label." + ALL_DAY, "All Day"), (Object)ALL_DAY));
        java.util.Calendar cal = java.util.Calendar.getInstance(TimeZone.getTimeZone(""));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        SimpleDateFormat dfLabel = new SimpleDateFormat(labelFormat, locale);
        dfLabel.setCalendar(cal);
        SimpleDateFormat dfValue = new SimpleDateFormat(valueFormat, locale);
        dfValue.setCalendar(cal);
        int day = cal.get(5);
        while (day == cal.get(5)) {
            options.add(new SelectItemOption(dfLabel.format(cal.getTime()), (Object)dfValue.format(cal.getTime())));
            cal.add(12, (int)timeInteval);
        }
        cal.set(5, day);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(14, 59);
        options.add(new SelectItemOption(dfLabel.format(cal.getTime()), (Object)dfValue.format(cal.getTime())));
        return options;
    }

    public static List<SelectItem> getCalendarOption() throws Exception {
        List lgcd;
        GroupCalendarData gcd;
        ArrayList<SelectItem> options = new ArrayList<SelectItem>();
        CalendarService calendarService = UICreateEvent.getCalendarService();
        String username = UICreateEvent.getCurrentUser();
        HashMap<String, String> hash = new HashMap<String, String>();
        SelectOptionGroup privGrp = new SelectOptionGroup(PRIVATE_CALENDARS);
        List calendars = calendarService.getUserCalendars(username, true);
        for (Calendar c : calendars) {
            if (c.getId().equals(Utils.getDefaultCalendarId((String)username)) && c.getName().equals(NewUserListener.defaultCalendarName)) {
                String newName = UICreateEvent.getResourceBundle("UICreateEvent.label." + NewUserListener.defaultCalendarId, NewUserListener.defaultCalendarId);
                c.setName(newName);
            }
            if (hash.containsKey(c.getId())) continue;
            hash.put(c.getId(), "");
            privGrp.addOption(new SelectOption(c.getName(), "0:" + c.getId()));
        }
        if (privGrp.getOptions().size() > 0) {
            options.add((SelectItem)privGrp);
        }
        if ((gcd = calendarService.getSharedCalendars(username, true)) != null) {
            SelectOptionGroup sharedGrp = new SelectOptionGroup(SHARED_CALENDARS);
            for (Calendar c : gcd.getCalendars()) {
                if (!UICreateEvent.canEdit(null, Utils.getEditPerUsers((Calendar)c), username)) continue;
                if (c.getId().equals(Utils.getDefaultCalendarId((String)c.getCalendarOwner())) && c.getName().equals(NewUserListener.defaultCalendarName)) {
                    String newName = UICreateEvent.getResourceBundle("UICreateEvent.label." + NewUserListener.defaultCalendarId, NewUserListener.defaultCalendarId);
                    c.setName(newName);
                }
                String owner = "";
                if (c.getCalendarOwner() != null) {
                    owner = c.getCalendarOwner() + " - ";
                }
                if (hash.containsKey(c.getId())) continue;
                hash.put(c.getId(), "");
                sharedGrp.addOption(new SelectOption(owner + c.getName(), "1:" + c.getId()));
            }
            if (sharedGrp.getOptions().size() > 0) {
                options.add((SelectItem)sharedGrp);
            }
        }
        if ((lgcd = calendarService.getGroupCalendars(UICreateEvent.getUserGroups(username), true, username)) != null) {
            SelectOptionGroup pubGrp = new SelectOptionGroup(PUBLIC_CALENDARS);
            String[] checkPerms = UICreateEvent.getCheckPermissionString().split(COMMA);
            for (GroupCalendarData g : lgcd) {
                String groupName = g.getName();
                for (Calendar c : g.getCalendars()) {
                    if (!UICreateEvent.hasEditPermission(c.getEditPermission(), checkPerms) || hash.containsKey(c.getId())) continue;
                    hash.put(c.getId(), "");
                    pubGrp.addOption(new SelectOption(UICreateEvent.getGroupCalendarName(groupName.substring(groupName.lastIndexOf("/") + 1), c.getName()), "2:" + c.getId()));
                }
            }
            if (pubGrp.getOptions().size() > 0) {
                options.add((SelectItem)pubGrp);
            }
        }
        return options;
    }

    public static CalendarService getCalendarService() throws Exception {
        return (CalendarService)PortalContainer.getInstance().getComponentInstance(CalendarService.class);
    }

    public static String getCheckPermissionString() throws Exception {
        Identity identity = ConversationState.getCurrent().getIdentity();
        StringBuffer sb = new StringBuffer(identity.getUserId());
        Set groupsId = identity.getGroups();
        for (String groupId : groupsId) {
            sb.append(COMMA).append(groupId).append(SLASH_COLON).append(ANY);
            sb.append(COMMA).append(groupId).append(SLASH_COLON).append(identity.getUserId());
        }
        Collection memberships = identity.getMemberships();
        for (MembershipEntry membership : memberships) {
            sb.append(COMMA).append(membership.getGroup()).append(SLASH_COLON).append(ANY_OF + membership.getMembershipType());
        }
        return sb.toString();
    }

    public static boolean hasEditPermission(String[] savePerms, String[] checkPerms) {
        if (savePerms != null) {
            for (String sp : savePerms) {
                for (String cp : checkPerms) {
                    if (!sp.equals(cp)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getResourceBundle(String key, String defaultValue) {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        try {
            return res.getString(key);
        }
        catch (MissingResourceException e) {
            log.warn((Object)("Can not find the resource for key: " + key));
            return defaultValue;
        }
    }

    public static String getCurrentUser() throws Exception {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public static boolean canEdit(OrganizationService oService, String[] savePerms, String username) throws Exception {
        String checkPerms = UICreateEvent.getCheckPermissionString();
        return UICreateEvent.hasEditPermission(savePerms, checkPerms.toString().split(COMMA));
    }

    public static final String[] getUserGroups(String username) throws Exception {
        ConversationState conversationState = ConversationState.getCurrent();
        Identity identity = conversationState.getIdentity();
        Set objs = identity.getGroups();
        String[] groups = new String[objs.size()];
        int i = 0;
        for (String obj : objs) {
            groups[i++] = obj;
        }
        return groups;
    }

    public static String getGroupCalendarName(String groupName, String calendarName) {
        return calendarName + " " + OPEN_PARENTHESIS + groupName + CLOSE_PARENTHESIS;
    }

    private String getEventSummary() {
        return (String)this.getUIStringInput(TITLE).getValue();
    }

    public static String enCodeTitle(String s) {
        StringBuffer buffer = new StringBuffer();
        if (s != null) {
            s = s.replaceAll("(<p>((\\&nbsp;)*)(\\s*)?</p>)|(<p>((\\&nbsp;)*)?(\\s*)</p>)", "<br/>").trim();
            s = s.replaceFirst("(<br/>)*", "");
            s = s.replaceAll("(\\w|\\$)(>?,?\\.?\\*?\\!?\\&?\\%?\\]?\\)?\\}?)(<br/><br/>)*", "$1$2");
            s.replaceAll("&", "&amp;").replaceAll("'", "&apos;");
            for (int j = 0; j < s.trim().length(); ++j) {
                char c = s.charAt(j);
                if (c == '<') {
                    buffer.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    buffer.append("&gt;");
                    continue;
                }
                if (c == '\'') {
                    buffer.append("&#39");
                    continue;
                }
                buffer.append(c);
            }
        }
        return buffer.toString();
    }

    private String getEventCalendar() {
        String values = (String)this.getUIFormSelectBoxGroup(CALENDAR).getValue();
        if (values != null && values.trim().length() > 0 && values.split(COLON).length > 0) {
            this.calType_ = values.split(COLON)[0];
            return values.split(COLON)[1];
        }
        return null;
    }

    public UIFormSelectBoxWithGroups getUIFormSelectBoxGroup(String id) {
        return (UIFormSelectBoxWithGroups)this.findComponentById(id);
    }

    public static class CancelActionListener
    extends EventListener<UICreateEvent> {
        public void execute(Event<UICreateEvent> event) throws Exception {
            UICreateEvent uisource = (UICreateEvent)((Object)event.getSource());
            WebuiRequestContext ctx = event.getRequestContext();
            Event cancelEvent = uisource.getParent().createEvent("Cancel", Event.Phase.DECODE, ctx);
            if (cancelEvent != null) {
                cancelEvent.broadcast();
            }
        }
    }

    public static class NextActionListener
    extends EventListener<UICreateEvent> {
        public void execute(Event<UICreateEvent> event) throws Exception {
            UICreateEvent uiForm = (UICreateEvent)((Object)event.getSource());
            String summary = uiForm.getEventSummary();
            if (summary == null || summary.trim().length() <= 0) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage(uiForm.getId() + ".msg.summary-field-required", null, 1));
                ((PortalRequestContext)event.getRequestContext().getParentAppRequestContext()).ignoreAJAXUpdateOnPortlets(true);
                return;
            }
            summary = summary.trim();
            summary = UICreateEvent.enCodeTitle(summary);
            UIFormDateTimeInput fromField = (UIFormDateTimeInput)uiForm.getChildById(START_EVENT);
            UIFormDateTimeInput toField = (UIFormDateTimeInput)uiForm.getChildById(END_EVENT);
            Date from = uiForm.getDateTime(fromField, START_TIME);
            Date to = uiForm.getDateTime(toField, END_TIME);
            if (from == null) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage(uiForm.getId() + ".msg.fromDate-format", null, 1));
                ((PortalRequestContext)event.getRequestContext().getParentAppRequestContext()).ignoreAJAXUpdateOnPortlets(true);
                return;
            }
            if (to == null) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage(uiForm.getId() + ".msg.toDate-format", null, 1));
                ((PortalRequestContext)event.getRequestContext().getParentAppRequestContext()).ignoreAJAXUpdateOnPortlets(true);
                return;
            }
            if (from.after(to) || from.equals(to)) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage(uiForm.getId() + ".msg.logic-required", null, 1));
                ((PortalRequestContext)event.getRequestContext().getParentAppRequestContext()).ignoreAJAXUpdateOnPortlets(true);
                return;
            }
            CalendarService calService = UICreateEvent.getCalendarService();
            if (calService.isRemoteCalendar(UICreateEvent.getCurrentUser(), uiForm.getEventCalendar())) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage(uiForm.getId() + ".msg.cant-add-event-on-remote-calendar", null, 1));
                ((PortalRequestContext)event.getRequestContext().getParentAppRequestContext()).ignoreAJAXUpdateOnPortlets(true);
                return;
            }
            try {
                CalendarEvent calEvent = new CalendarEvent();
                calEvent.setSummary(summary);
                calEvent.setCalendarId(uiForm.getEventCalendar());
                String username = UICreateEvent.getCurrentUser();
                boolean isEvent = "Event".equals(((UIFormRadioBoxInput)uiForm.getUIInput(CHOIX)).getValue());
                if (isEvent) {
                    calEvent.setEventType(CalendarEvent.TYPE_EVENT);
                    calEvent.setEventState(CalendarEvent.ST_BUSY);
                    calEvent.setRepeatType(CalendarEvent.RP_NOREPEAT);
                } else {
                    calEvent.setEventType(CalendarEvent.TYPE_TASK);
                    calEvent.setEventState(CalendarEvent.NEEDS_ACTION);
                    calEvent.setTaskDelegator(event.getRequestContext().getRemoteUser());
                }
                calEvent.setFromDateTime(from);
                calEvent.setToDateTime(to);
                calEvent.setCalType(uiForm.calType_);
                String calName = "";
                if (calService.getUserCalendar(username, uiForm.getEventCalendar()) != null) {
                    if (calService.getUserCalendar(username, uiForm.getEventCalendar()).getId().equals(Utils.getDefaultCalendarId((String)username))) {
                        calName = calService.getUserCalendar(username, uiForm.getEventCalendar()).getName();
                    }
                } else if (calService.getGroupCalendar(uiForm.getEventCalendar()) != null) {
                    calName = UICreateEvent.getGroupCalendarName(calService.getGroupCalendar(uiForm.getEventCalendar()).getGroups()[0].substring(calService.getGroupCalendar(uiForm.getEventCalendar()).getGroups()[0].lastIndexOf("/") + 1), calService.getGroupCalendar(uiForm.getEventCalendar()).getName());
                } else if (calService.getSharedCalendars(username, true).getCalendarById(uiForm.getEventCalendar()) != null) {
                    if (calService.getUserCalendar(username, uiForm.getEventCalendar()).getId().equals(Utils.getDefaultCalendarId((String)calService.getUserCalendar(username, uiForm.getEventCalendar()).getCalendarOwner())) && calService.getUserCalendar(username, uiForm.getEventCalendar()).getName().equals(NewUserListener.defaultCalendarName)) {
                        calName = UICreateEvent.getResourceBundle("UICreateEvent.label." + NewUserListener.defaultCalendarId, NewUserListener.defaultCalendarId);
                    }
                    String owner = "";
                    if (calService.getUserCalendar(username, uiForm.getEventCalendar()).getCalendarOwner() != null) {
                        owner = calService.getUserCalendar(username, uiForm.getEventCalendar()).getCalendarOwner() + " - ";
                    }
                    calName = owner + calName;
                }
                if (uiForm.calType_.equals(UICreateEvent.PRIVATE_TYPE)) {
                    calService.saveUserEvent(username, calEvent.getCalendarId(), calEvent, true);
                } else if (uiForm.calType_.equals(UICreateEvent.SHARED_TYPE)) {
                    calService.saveEventToSharedCalendar(username, calEvent.getCalendarId(), calEvent, true);
                } else if (uiForm.calType_.equals(UICreateEvent.PUBLIC_TYPE)) {
                    calService.savePublicEvent(calEvent.getCalendarId(), calEvent, true);
                }
                String defaultMsg = "The {0} added to the {1}.";
                String message = UICreateEvent.getResourceBundle(uiForm.getId() + ".msg.add-successfully." + calEvent.getEventType(), defaultMsg);
                message = message.replace("{1}", calName);
                Event cancelEvent = uiForm.getParent().createEvent("Cancel", Event.Phase.PROCESS, event.getRequestContext());
                if (cancelEvent != null) {
                    cancelEvent.broadcast();
                }
                event.getRequestContext().getJavascriptManager().require("SHARED/navigation-toolbar", "toolbarnav").addScripts("toolbarnav.UIPortalNavigation.cancelNextClick('UICreateList','UICreatePlatformToolBarPortlet','" + message + "');");
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fail to quick add event to the calendar", (Throwable)e);
                }
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage(uiForm.getId() + ".msg.add-unsuccessfully", null));
            }
        }
    }
}

