/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.config.AuthPropertyType;
import org.picketlink.identity.federation.core.config.KeyValueType;
import org.picketlink.identity.federation.core.impl.SecurityActions;
import org.picketlink.identity.federation.core.interfaces.TrustKeyConfigurationException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.interfaces.TrustKeyProcessingException;
import org.picketlink.identity.federation.core.util.EncryptionKeyUtil;
import org.picketlink.identity.federation.core.util.KeyStoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStoreKeyManager
implements TrustKeyManager {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private final Map<String, SecretKey> keys = new HashMap<String, SecretKey>();
    private final Map<String, Object> options = new HashMap<String, Object>();
    private final HashMap<String, String> domainAliasMap = new HashMap();
    private final HashMap<String, String> authPropsMap = new HashMap();
    private KeyStore ks = null;
    private String keyStoreURL;
    private char[] signingKeyPass;
    private String signingAlias;
    private String keyStorePass;
    public static final String KEYSTORE_URL = "KeyStoreURL";
    public static final String KEYSTORE_PASS = "KeyStorePass";
    public static final String SIGNING_KEY_PASS = "SigningKeyPass";
    public static final String SIGNING_KEY_ALIAS = "SigningKeyAlias";

    @Override
    public PrivateKey getSigningKey() throws TrustKeyConfigurationException, TrustKeyProcessingException {
        try {
            this.initKeyStore();
            return (PrivateKey)this.ks.getKey(this.signingAlias, this.signingKeyPass);
        }
        catch (KeyStoreException e) {
            throw logger.keyStoreConfigurationError(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw logger.keyStoreProcessingError(e);
        }
        catch (UnrecoverableKeyException e) {
            throw logger.keyStoreProcessingError(e);
        }
        catch (GeneralSecurityException e) {
            throw logger.keyStoreProcessingError(e);
        }
        catch (IOException e) {
            throw logger.keyStoreProcessingError(e);
        }
    }

    @Override
    public KeyPair getSigningKeyPair() throws TrustKeyConfigurationException, TrustKeyProcessingException {
        try {
            this.initKeyStore();
            PrivateKey privateKey = this.getSigningKey();
            PublicKey publicKey = KeyStoreUtil.getPublicKey(this.ks, this.signingAlias, this.signingKeyPass);
            return new KeyPair(publicKey, privateKey);
        }
        catch (KeyStoreException e) {
            throw logger.keyStoreConfigurationError(e);
        }
        catch (GeneralSecurityException e) {
            throw logger.keyStoreProcessingError(e);
        }
        catch (IOException e) {
            throw logger.keyStoreProcessingError(e);
        }
    }

    @Override
    public Certificate getCertificate(String alias) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        try {
            this.initKeyStore();
            if (alias == null || alias.length() == 0) {
                throw logger.keyStoreNullAlias();
            }
            return this.ks.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw logger.keyStoreConfigurationError(e);
        }
        catch (GeneralSecurityException e) {
            throw logger.keyStoreProcessingError(e);
        }
        catch (IOException e) {
            throw logger.keyStoreProcessingError(e);
        }
    }

    @Override
    public PublicKey getPublicKey(String alias) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        PublicKey publicKey = null;
        try {
            this.initKeyStore();
            Certificate cert = this.ks.getCertificate(alias);
            if (cert != null) {
                publicKey = cert.getPublicKey();
            } else {
                logger.keyStoreNullPublicKeyForAlias(alias);
            }
            return publicKey;
        }
        catch (KeyStoreException e) {
            throw logger.keyStoreConfigurationError(e);
        }
        catch (GeneralSecurityException e) {
            throw logger.keyStoreProcessingError(e);
        }
        catch (IOException e) {
            throw logger.keyStoreProcessingError(e);
        }
    }

    @Override
    public PublicKey getValidatingKey(String domain) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        PublicKey publicKey = null;
        try {
            this.initKeyStore();
            String domainAlias = this.domainAliasMap.get(domain);
            if (domainAlias == null) {
                throw logger.keyStoreMissingDomainAlias(domain);
            }
            try {
                publicKey = KeyStoreUtil.getPublicKey(this.ks, domainAlias, this.keyStorePass.toCharArray());
            }
            catch (UnrecoverableKeyException urke) {
                publicKey = KeyStoreUtil.getPublicKey(this.ks, domainAlias, this.signingKeyPass);
            }
        }
        catch (KeyStoreException e) {
            throw logger.keyStoreConfigurationError(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw logger.keyStoreProcessingError(e);
        }
        catch (GeneralSecurityException e) {
            throw logger.keyStoreProcessingError(e);
        }
        catch (IOException e) {
            throw logger.keyStoreProcessingError(e);
        }
        return publicKey;
    }

    private void initKeyStore() throws GeneralSecurityException, IOException {
        if (this.ks == null) {
            logger.keyStoreSetup();
            this.setUpKeyStore();
        }
        if (this.ks == null) {
            throw logger.keyStoreNullStore();
        }
    }

    @Override
    public void setAuthProperties(List<AuthPropertyType> authList) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        for (AuthPropertyType auth : authList) {
            this.authPropsMap.put(auth.getKey(), auth.getValue());
        }
        this.keyStoreURL = this.authPropsMap.get(KEYSTORE_URL);
        this.keyStorePass = this.authPropsMap.get(KEYSTORE_PASS);
        this.signingAlias = this.authPropsMap.get(SIGNING_KEY_ALIAS);
        String keypass = this.authPropsMap.get(SIGNING_KEY_PASS);
        if (keypass == null || keypass.length() == 0) {
            throw logger.keyStoreNullSigningKeyPass();
        }
        this.signingKeyPass = keypass.toCharArray();
    }

    @Override
    public void setValidatingAlias(List<KeyValueType> aliases) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        for (KeyValueType alias : aliases) {
            this.domainAliasMap.put(alias.getKey(), alias.getValue());
        }
    }

    @Override
    public SecretKey getEncryptionKey(String domain, String encryptionAlgorithm, int keyLength) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        SecretKey key = this.keys.get(domain);
        if (key == null) {
            try {
                key = EncryptionKeyUtil.getSecretKey(encryptionAlgorithm, keyLength);
            }
            catch (GeneralSecurityException e) {
                throw logger.keyStoreProcessingError(e);
            }
            this.keys.put(domain, key);
        }
        return key;
    }

    @Override
    public void addAdditionalOption(String key, Object value) {
        this.options.put(key, value);
    }

    @Override
    public Object getAdditionalOption(String key) {
        return this.options.get(key);
    }

    private void setUpKeyStore() throws GeneralSecurityException, IOException {
        if (this.keyStoreURL == null) {
            this.keyStoreURL = SecurityActions.getProperty("javax.net.ssl.keyStore", null);
        }
        if (this.keyStorePass == null) {
            this.keyStorePass = SecurityActions.getProperty("javax.net.ssl.keyStorePassword", null);
        }
        InputStream is = this.getKeyStoreInputStream(this.keyStoreURL);
        this.ks = KeyStoreUtil.getKeyStore(is, this.keyStorePass.toCharArray());
    }

    private InputStream getKeyStoreInputStream(String keyStore) {
        String userHome;
        File ksDir;
        InputStream is;
        block10: {
            is = null;
            try {
                File file = new File(keyStore);
                is = new FileInputStream(file);
            }
            catch (Exception e) {
                URL url = null;
                try {
                    url = new URL(keyStore);
                    is = url.openStream();
                }
                catch (Exception ex) {
                    url = SecurityActions.loadResource(this.getClass(), keyStore);
                    if (url == null) break block10;
                    try {
                        is = url.openStream();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
            }
        }
        if (is == null && (ksDir = new File(userHome = SecurityActions.getSystemProperty("user.home", "") + "/jbid-keystore")).exists()) {
            try {
                is = new FileInputStream(new File(userHome + "/" + keyStore));
            }
            catch (FileNotFoundException e) {
                is = null;
            }
        }
        if (is == null) {
            throw logger.keyStoreNotLocated(keyStore);
        }
        return is;
    }
}

