/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.config;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.picketlink.identity.federation.core.config.PicketLinkType;
import org.picketlink.identity.federation.core.config.ProviderType;
import org.picketlink.identity.federation.core.config.STSType;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.handler.config.Handlers;
import org.picketlink.identity.federation.core.parsers.AbstractParser;
import org.picketlink.identity.federation.core.parsers.config.SAMLConfigParser;
import org.picketlink.identity.federation.core.parsers.sts.STSConfigParser;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;

public class PicketLinkConfigParser
extends AbstractParser {
    public static final String PICKETLINK = "PicketLink";
    public static final String ENABLE_AUDIT = "EnableAudit";

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        PicketLinkType picketLinkType = new PicketLinkType();
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, PICKETLINK);
        QName attributeQName = new QName("", ENABLE_AUDIT);
        Attribute attribute = startElement.getAttributeByName(attributeQName);
        if (attribute != null) {
            picketLinkType.setEnableAudit(Boolean.parseBoolean(StaxParserUtil.getAttributeValue(attribute)));
        }
        startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
        String tag = StaxParserUtil.getStartElementName(startElement);
        while (xmlEventReader.hasNext()) {
            AbstractParser samlConfigParser;
            if ("PicketLinkIDP".equals(tag)) {
                samlConfigParser = new SAMLConfigParser();
                ProviderType idp = (ProviderType)((SAMLConfigParser)samlConfigParser).parse(xmlEventReader);
                picketLinkType.setIdpOrSP(idp);
            } else if ("PicketLinkSP".equals(tag)) {
                samlConfigParser = new SAMLConfigParser();
                ProviderType sp = (ProviderType)((SAMLConfigParser)samlConfigParser).parse(xmlEventReader);
                picketLinkType.setIdpOrSP(sp);
            } else if ("Handlers".equals(tag)) {
                samlConfigParser = new SAMLConfigParser();
                Handlers handlers = (Handlers)((SAMLConfigParser)samlConfigParser).parse(xmlEventReader);
                picketLinkType.setHandlers(handlers);
            } else if ("PicketLinkSTS".equals(tag)) {
                samlConfigParser = new STSConfigParser();
                STSType sts = (STSType)((STSConfigParser)samlConfigParser).parse(xmlEventReader);
                picketLinkType.setStsType(sts);
            }
            startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (startElement == null) break;
            tag = StaxParserUtil.getStartElementName(startElement);
        }
        return picketLinkType;
    }

    public boolean supports(QName qname) {
        return false;
    }
}

