/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.connections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.profile.UIProfileUserSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/social/webui/connections/UIInvitations.gtmpl", events={@EventConfig(listeners={ConfirmActionListener.class}), @EventConfig(listeners={IgnoreActionListener.class}), @EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={LoadMorePeopleActionListener.class})})})
public class UIInvitations
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIInvitations.class);
    private static final String INVITATION_REVOKED_INFO = "UIInvitations.label.RevokedInfo";
    UIProfileUserSearch uiProfileUserSearch = (UIProfileUserSearch)this.createUIComponent(UIProfileUserSearch.class, null, "UIProfileUserSearch");
    private static final int RECEIVED_INVITATION_PER_PAGE = 45;
    private boolean loadAtEnd = false;
    private int currentLoadIndex;
    private boolean enableLoadNext;
    private int loadingCapacity;
    private List<Identity> peopleList;
    private ListAccess<Identity> peopleListAccess;
    private int peopleNum;
    private boolean hasPeopleTab;
    String selectedChar = null;
    private Identity lastOwner = null;

    public boolean isHasPeopleTab() {
        return this.hasPeopleTab;
    }

    public void setHasPeopleTab(boolean hasPeopleTab) {
        this.hasPeopleTab = hasPeopleTab;
    }

    public final String getSelectedChar() {
        return this.selectedChar;
    }

    public final void setSelectedChar(String selectedChar) {
        this.selectedChar = selectedChar;
    }

    public UIInvitations() throws Exception {
        this.setHasPeopleTab(true);
        this.uiProfileUserSearch.setHasConnectionLink(false);
        this.addChild((UIComponent)this.uiProfileUserSearch);
        this.init();
    }

    public void init() {
        try {
            this.setLoadAtEnd(false);
            this.enableLoadNext = false;
            this.currentLoadIndex = 0;
            this.loadingCapacity = 45;
            this.peopleList = new ArrayList<Identity>();
            ArrayList<Identity> excludedIdentityList = new ArrayList<Identity>();
            excludedIdentityList.add(Utils.getViewerIdentity());
            this.uiProfileUserSearch.getProfileFilter().setExcludedIdentityList(excludedIdentityList);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setLoadingCapacity(int loadingCapacity) {
        this.loadingCapacity = loadingCapacity;
    }

    public boolean isEnableLoadNext() {
        return this.enableLoadNext;
    }

    public void setEnableLoadNext(boolean enableLoadNext) {
        this.enableLoadNext = enableLoadNext;
    }

    public boolean isLoadAtEnd() {
        return this.loadAtEnd;
    }

    public void setLoadAtEnd(boolean loadAtEnd) {
        this.loadAtEnd = loadAtEnd;
    }

    public List<Identity> getPeopleList() throws Exception {
        this.peopleList = this.loadPeople(0, this.currentLoadIndex + this.loadingCapacity);
        int realPeopleListSize = this.peopleList.size();
        this.setEnableLoadNext(realPeopleListSize >= 45 && realPeopleListSize < this.getPeopleNum());
        return this.peopleList;
    }

    public void setPeopleList(List<Identity> peopleList) {
        this.peopleList = peopleList;
    }

    public int getPeopleNum() {
        return this.peopleNum;
    }

    public void setPeopleNum(int peopleNum) {
        this.peopleNum = peopleNum;
    }

    public ListAccess<Identity> getPeopleListAccess() {
        return this.peopleListAccess;
    }

    public void setPeopleListAccess(ListAccess<Identity> peopleListAccess) {
        this.peopleListAccess = peopleListAccess;
    }

    public void increaseOffset() throws Exception {
        this.currentLoadIndex += this.loadingCapacity;
    }

    public void loadSearch() throws Exception {
        this.currentLoadIndex = 0;
        this.setPeopleList(this.loadPeople(this.currentLoadIndex, this.loadingCapacity));
    }

    private List<Identity> loadPeople(int index, int length) throws Exception {
        this.lastOwner = Utils.getOwnerIdentity();
        ProfileFilter filter = this.uiProfileUserSearch.getProfileFilter();
        ListAccess listAccess = Utils.getRelationshipManager().getIncomingByFilter(this.lastOwner, filter);
        Identity[] identities = (Identity[])listAccess.load(index, length);
        this.setPeopleNum(listAccess.getSize());
        this.setPeopleListAccess((ListAccess<Identity>)listAccess);
        this.uiProfileUserSearch.setPeopleNum(listAccess.getSize());
        return Arrays.asList(identities);
    }

    protected boolean isNewOwner() {
        Identity current = Utils.getOwnerIdentity();
        if (this.lastOwner == null || current == null) {
            return false;
        }
        return !this.lastOwner.getRemoteId().equals(current.getRemoteId());
    }

    public boolean isEditable() {
        return Utils.isOwner();
    }

    public static class SearchActionListener
    extends EventListener<UIInvitations> {
        public void execute(Event<UIInvitations> event) throws Exception {
            UIInvitations uiInvitations = (UIInvitations)((Object)event.getSource());
            WebuiRequestContext ctx = event.getRequestContext();
            UIProfileUserSearch uiSearch = uiInvitations.uiProfileUserSearch;
            String charSearch = ctx.getRequestParameter("objectId");
            ResourceBundle resApp = ctx.getApplicationResourceBundle();
            String defaultNameVal = resApp.getString(uiSearch.getId() + ".label.Name");
            String defaultPosVal = resApp.getString(uiSearch.getId() + ".label.Position");
            String defaultSkillsVal = resApp.getString(uiSearch.getId() + ".label.Skills");
            ProfileFilter filter = uiInvitations.uiProfileUserSearch.getProfileFilter();
            try {
                uiInvitations.setSelectedChar(charSearch);
                if (charSearch != null) {
                    ((UIFormStringInput)uiSearch.getChildById("Search")).setValue((Object)defaultNameVal);
                    ((UIFormStringInput)uiSearch.getChildById("position")).setValue((Object)defaultPosVal);
                    ((UIFormStringInput)uiSearch.getChildById("skills")).setValue((Object)defaultSkillsVal);
                    filter.setName(charSearch);
                    filter.setPosition("");
                    filter.setSkills("");
                    filter.setFirstCharacterOfName(charSearch.toCharArray()[0]);
                    if ("All".equals(charSearch)) {
                        filter.setFirstCharacterOfName('\u0000');
                        filter.setName("");
                    }
                    uiSearch.setRawSearchConditional("");
                } else if ("All".equals(uiSearch.getRawSearchConditional())) {
                    uiInvitations.setSelectedChar("All");
                }
                uiSearch.setProfileFilter(filter);
                uiSearch.setNewSearch(true);
            }
            catch (Exception e) {
                uiSearch.setIdentityList(new ArrayList<Identity>());
            }
            uiInvitations.loadSearch();
            uiInvitations.setLoadAtEnd(false);
        }
    }

    public static class IgnoreActionListener
    extends EventListener<UIInvitations> {
        public void execute(Event<UIInvitations> event) throws Exception {
            UIInvitations uiInvitations = (UIInvitations)((Object)event.getSource());
            String identityId = event.getRequestContext().getRequestParameter("objectId");
            Identity invitedIdentity = Utils.getIdentityManager().getIdentity(identityId, true);
            Identity invitingIdentity = Utils.getViewerIdentity();
            Relationship relationship = Utils.getRelationshipManager().get(invitingIdentity, invitedIdentity);
            uiInvitations.setLoadAtEnd(false);
            if (relationship == null || relationship.getStatus() != Relationship.Type.PENDING) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIInvitations.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            Utils.getRelationshipManager().deny(invitedIdentity, invitingIdentity);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiInvitations);
        }
    }

    public static class ConfirmActionListener
    extends EventListener<UIInvitations> {
        public void execute(Event<UIInvitations> event) throws Exception {
            UIInvitations uiInvitations = (UIInvitations)((Object)event.getSource());
            String identityId = event.getRequestContext().getRequestParameter("objectId");
            Identity invitedIdentity = Utils.getIdentityManager().getIdentity(identityId, true);
            Identity invitingIdentity = Utils.getOwnerIdentity();
            Relationship relationship = Utils.getRelationshipManager().get(invitingIdentity, invitedIdentity);
            uiInvitations.setLoadAtEnd(false);
            if (relationship == null || relationship.getStatus() != Relationship.Type.PENDING) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIInvitations.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            Utils.getRelationshipManager().confirm(invitedIdentity, invitingIdentity);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiInvitations);
        }
    }

    public static class LoadMorePeopleActionListener
    extends EventListener<UIInvitations> {
        public void execute(Event<UIInvitations> event) throws Exception {
            UIInvitations uiInvitations = (UIInvitations)((Object)event.getSource());
            if (uiInvitations.currentLoadIndex < uiInvitations.peopleNum) {
                uiInvitations.increaseOffset();
            } else {
                uiInvitations.setEnableLoadNext(false);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiInvitations);
        }
    }
}

