/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NameReferenceGraph;
import com.google.javascript.jscomp.NameReferenceGraphConstruction;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.rhino.Node;

class AnalyzeNameReferences
implements CompilerPass {
    private NameReferenceGraph graph;
    private final JSModuleGraph moduleGraph;
    private final AbstractCompiler compiler;

    AnalyzeNameReferences(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.moduleGraph = compiler.getModuleGraph();
    }

    @Override
    public void process(Node externs, Node root) {
        NameReferenceGraphConstruction gc = new NameReferenceGraphConstruction(this.compiler);
        gc.process(externs, root);
        this.graph = gc.getNameReferenceGraph();
        FixedPointGraphTraversal<NameReferenceGraph.Name, NameReferenceGraph.Reference> t = FixedPointGraphTraversal.newTraversal(new PropagateReferences());
        this.getInfo(this.graph.MAIN).markReference(null);
        t.computeFixedPoint((DiGraph<NameReferenceGraph.Name, NameReferenceGraph.Reference>)this.graph, Sets.newHashSet((Object[])new NameReferenceGraph.Name[]{this.graph.MAIN}));
    }

    public NameReferenceGraph getGraph() {
        return this.graph;
    }

    private NameInfo getInfo(NameReferenceGraph.Name symbol) {
        GraphNode name = this.graph.getNode(symbol);
        NameInfo info = (NameInfo)name.getAnnotation();
        if (info == null) {
            info = new NameInfo();
            name.setAnnotation(info);
        }
        return info;
    }

    final class NameInfo
    implements Annotation {
        private boolean referenced = false;
        private JSModule deepestCommonModuleRef = null;

        NameInfo() {
        }

        boolean isReferenced() {
            return this.referenced;
        }

        JSModule getDeepestCommonModuleRef() {
            return this.deepestCommonModuleRef;
        }

        boolean markReference(JSModule module) {
            boolean hasChanged = false;
            if (!this.referenced) {
                this.referenced = true;
                hasChanged = true;
            }
            if (AnalyzeNameReferences.this.moduleGraph != null) {
                JSModule originalDeepestCommon = this.deepestCommonModuleRef;
                this.deepestCommonModuleRef = this.deepestCommonModuleRef == null ? module : AnalyzeNameReferences.this.moduleGraph.getDeepestCommonDependencyInclusive(this.deepestCommonModuleRef, module);
                if (originalDeepestCommon != this.deepestCommonModuleRef) {
                    hasChanged = true;
                }
            }
            return hasChanged;
        }
    }

    private class PropagateReferences
    implements FixedPointGraphTraversal.EdgeCallback<NameReferenceGraph.Name, NameReferenceGraph.Reference> {
        private PropagateReferences() {
        }

        @Override
        public boolean traverseEdge(NameReferenceGraph.Name start, NameReferenceGraph.Reference edge, NameReferenceGraph.Name dest) {
            NameInfo startInfo = AnalyzeNameReferences.this.getInfo(start);
            NameInfo destInfo = AnalyzeNameReferences.this.getInfo(dest);
            if (startInfo.isReferenced()) {
                JSModule startModule = startInfo.getDeepestCommonModuleRef();
                if (startModule != null && AnalyzeNameReferences.this.moduleGraph.dependsOn(startModule, edge.getModule())) {
                    return destInfo.markReference(startModule);
                }
                return destInfo.markReference(edge.getModule());
            }
            return false;
        }
    }
}

