/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AnalyzePrototypeProperties;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.rhino.Node;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;

class CrossModuleMethodMotion
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(CrossModuleMethodMotion.class.getName());
    static final DiagnosticType NULL_COMMON_MODULE_ERROR = DiagnosticType.error("JSC_INTERNAL_ERROR_MODULE_DEPEND", "null deepest common module");
    private final AbstractCompiler compiler;
    private final IdGenerator idGenerator;
    private final AnalyzePrototypeProperties analyzer;
    private final JSModuleGraph moduleGraph;
    static final String STUB_METHOD_NAME = "JSCompiler_stubMethod";
    static final String UNSTUB_METHOD_NAME = "JSCompiler_unstubMethod";
    static final String STUB_DECLARATIONS = "var JSCompiler_stubMap = [];function JSCompiler_stubMethod(JSCompiler_stubMethod_id) {  return function() {    return JSCompiler_stubMap[JSCompiler_stubMethod_id].apply(        this, arguments);  };}function JSCompiler_unstubMethod(    JSCompiler_unstubMethod_id, JSCompiler_unstubMethod_body) {  return JSCompiler_stubMap[JSCompiler_unstubMethod_id] =       JSCompiler_unstubMethod_body;}";

    CrossModuleMethodMotion(AbstractCompiler compiler, IdGenerator idGenerator, boolean canModifyExterns) {
        this.compiler = compiler;
        this.idGenerator = idGenerator;
        this.moduleGraph = compiler.getModuleGraph();
        this.analyzer = new AnalyzePrototypeProperties(compiler, this.moduleGraph, canModifyExterns, false);
    }

    @Override
    public void process(Node externRoot, Node root) {
        if (this.moduleGraph != null && this.moduleGraph.getModuleCount() > 1) {
            this.analyzer.process(externRoot, root);
            this.moveMethods(this.analyzer.getAllNameInfo());
        }
    }

    private void moveMethods(Collection<AnalyzePrototypeProperties.NameInfo> allNameInfo) {
        boolean hasStubDeclaration = this.idGenerator.hasGeneratedAnyIds();
        for (AnalyzePrototypeProperties.NameInfo nameInfo : allNameInfo) {
            if (!nameInfo.isReferenced() || nameInfo.readsClosureVariables()) continue;
            JSModule deepestCommonModuleRef = nameInfo.getDeepestCommonModuleRef();
            if (deepestCommonModuleRef == null) {
                this.compiler.report(JSError.make(NULL_COMMON_MODULE_ERROR, new String[0]));
                continue;
            }
            Iterator<AnalyzePrototypeProperties.Symbol> declarations = nameInfo.getDeclarations().descendingIterator();
            while (declarations.hasNext()) {
                Node valueParent;
                AnalyzePrototypeProperties.Symbol symbol = declarations.next();
                if (!(symbol instanceof AnalyzePrototypeProperties.Property)) continue;
                AnalyzePrototypeProperties.Property prop = (AnalyzePrototypeProperties.Property)symbol;
                Node value = prop.getValue();
                if (!this.moduleGraph.dependsOn(deepestCommonModuleRef, prop.getModule()) || !value.isFunction() || (valueParent = value.getParent()).isGetterDef() || valueParent.isSetterDef()) continue;
                Node proto = prop.getPrototype();
                int stubId = this.idGenerator.newId();
                Node stubCall = new Node(37, Node.newString(38, STUB_METHOD_NAME), Node.newNumber(stubId)).copyInformationFromForTree(value);
                stubCall.putBooleanProp(50, true);
                valueParent.replaceChild(value, stubCall);
                Node unstubParent = this.compiler.getNodeForCodeInsertion(deepestCommonModuleRef);
                Node unstubCall = new Node(37, Node.newString(38, UNSTUB_METHOD_NAME), Node.newNumber(stubId), value);
                unstubCall.putBooleanProp(50, true);
                unstubParent.addChildToFront(new Node(130, new Node(86, new Node(33, proto.cloneTree(), Node.newString(40, nameInfo.name)), unstubCall)).copyInformationFromForTree(value));
                this.compiler.reportCodeChange();
                logger.fine("Moved method: " + proto.getQualifiedName() + "." + nameInfo.name + " from module " + prop.getModule() + " to module " + deepestCommonModuleRef);
            }
        }
        if (!hasStubDeclaration && this.idGenerator.hasGeneratedAnyIds()) {
            Node declarations = this.compiler.parseSyntheticCode(STUB_DECLARATIONS);
            this.compiler.getNodeForCodeInsertion(null).addChildrenToFront(declarations.removeChildren());
        }
    }

    static class IdGenerator
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private int currentId = 0;

        IdGenerator() {
        }

        boolean hasGeneratedAnyIds() {
            return this.currentId != 0;
        }

        int newId() {
            return this.currentId++;
        }
    }
}

