/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common;

import java.text.MessageFormat;
import java.util.List;

public class ResourceBundleUtil {
    private static final ThreadLocal<MessageFormat> messageFormatRef = new ThreadLocal<MessageFormat>(){

        @Override
        protected MessageFormat initialValue() {
            return new MessageFormat("");
        }
    };
    private static final String[] EMPTY_MESSAGE_ARGUMENTS = new String[0];

    public static String replaceArguments(String message, String[] messageArguments) {
        if (messageArguments == null) {
            messageArguments = EMPTY_MESSAGE_ARGUMENTS;
        }
        MessageFormat messageFormat = messageFormatRef.get();
        message = ResourceBundleUtil.processSingleQuote(message);
        messageFormat.applyPattern(message);
        return messageFormat.format(messageArguments);
    }

    public static String replaceArguments(String message, List<String> messageArguments) {
        return ResourceBundleUtil.replaceArguments(message, messageArguments.toArray(new String[0]));
    }

    public static String processSingleQuote(String message) {
        String temp = message;
        while (temp.indexOf("''") >= 0) {
            temp = temp.replace("''", "'");
        }
        return temp.replaceAll("'", "''");
    }
}

