/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public class ByteArrayClassLoader
extends ClassLoader {
    private static final boolean DEBUG = false;
    private final Map classes;

    public ByteArrayClassLoader(Map classes) {
        this.classes = classes;
    }

    public ByteArrayClassLoader(Map classes, ClassLoader parent) {
        super(parent);
        this.classes = classes;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        byte[] data = (byte[])this.classes.get(name);
        if (data == null) {
            throw new ClassNotFoundException(name);
        }
        return super.defineClass(name, data, 0, data.length, this.getClass().getProtectionDomain());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ByteArrayClassLoader)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        ByteArrayClassLoader that = (ByteArrayClassLoader)o;
        ClassLoader parentOfThis = this.getParent();
        ClassLoader parentOfThat = that.getParent();
        if (parentOfThis == null ? parentOfThat != null : !parentOfThis.equals(parentOfThat)) {
            return false;
        }
        if (this.classes.size() != that.classes.size()) {
            return false;
        }
        Iterator it = this.classes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            byte[] ba = (byte[])that.classes.get(me.getKey());
            if (ba == null) {
                return false;
            }
            if (Arrays.equals((byte[])me.getValue(), ba)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hc = this.getParent().hashCode();
        Iterator it = this.classes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            hc ^= me.getKey().hashCode();
            byte[] ba = (byte[])me.getValue();
            for (int i = 0; i < ba.length; ++i) {
                hc = 31 * hc ^ ba[i];
            }
        }
        return hc;
    }
}

