/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.shindig.common.util.Base32;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponseMetadataHelper {
    public static final String DATA_HASH = "DataHash";
    public static final String IMAGE_HEIGHT = "ImageHeight";
    public static final String IMAGE_WIDTH = "ImageWidth";
    private static final Logger LOG = Logger.getLogger(HttpResponseMetadataHelper.class.getName());

    public static HttpResponse updateMetadata(HttpResponse response, Map<String, String> values) {
        HashMap metadata = Maps.newHashMap(response.getMetadata());
        for (Map.Entry<String, String> val : values.entrySet()) {
            metadata.put(val.getKey(), val.getValue());
        }
        return new HttpResponseBuilder(response).setMetadata(metadata).create();
    }

    public String getHash(HttpResponse response) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(response.getResponseAsBytes());
            byte[] md5val = md5.digest();
            return new String(Base32.encodeBase32((byte[])md5val), "UTF-8");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.info("Error getting MD5 digest, ignored");
        }
        catch (UnsupportedEncodingException e) {
            LOG.info("Error parsing MD5 string as UTF8");
        }
        return null;
    }

    public static HttpResponse updateHash(HttpResponse response, HttpResponseMetadataHelper helper) {
        String hash;
        if (helper != null && (hash = helper.getHash(response)) != null) {
            return HttpResponseMetadataHelper.updateMetadata(response, (Map<String, String>)ImmutableMap.of((Object)DATA_HASH, (Object)hash));
        }
        return response;
    }
}

