/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.application.portlet;

import javax.portlet.PortletURL;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.web.application.URLBuilder;
import org.exoplatform.webui.core.UIComponent;

public class PortletURLBuilder
extends URLBuilder<UIComponent> {
    private final PortletURL url;
    public static final String CSRF_PROP = "gtn:csrfCheck";

    public PortletURLBuilder(PortletURL url) {
        this.url = url;
    }

    public String createAjaxURL(UIComponent targetComponent, String action, String confirm, String targetBeanId, Parameter[] params, boolean csrfCheck) {
        return this.createURL(true, confirm, targetComponent, action, targetBeanId, params, csrfCheck);
    }

    public String createURL(UIComponent targetComponent, String action, String confirm, String targetBeanId, Parameter[] params, boolean csrfCheck) {
        return this.createURL(false, confirm, targetComponent, action, targetBeanId, params, csrfCheck);
    }

    private String createURL(boolean ajax, String confirm, UIComponent targetComponent, String action, String targetBeanId, Parameter[] params, boolean csrfCheck) {
        this.url.getParameterMap().clear();
        this.url.setProperty("gtn:ajax", Boolean.toString(ajax));
        this.url.setProperty("gtn:confirm", confirm);
        this.url.setParameter("uicomponent", targetComponent.getId());
        if (action != null && action.trim().length() > 0) {
            this.url.setParameter("op", action);
        }
        if (targetBeanId != null && targetBeanId.trim().length() > 0) {
            this.url.setParameter("objectId", targetBeanId);
        }
        if (params != null && params.length > 0) {
            for (Parameter param : params) {
                this.url.setParameter(param.getName(), param.getValue());
            }
        }
        if (this.removeLocale) {
            this.url.setProperty("gtn:lang", "");
        } else if (this.locale != null) {
            this.url.setProperty("gtn:lang", this.locale.toString());
        }
        if (csrfCheck) {
            this.url.setProperty(CSRF_PROP, Boolean.TRUE.toString());
        }
        return this.url.toString();
    }
}

