/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.jcr.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class VersionNode {
    private boolean isExpanded;
    private List<VersionNode> children_;
    private static final Log LOG = ExoLogger.getLogger((String)VersionNode.class.getName());
    private Calendar createdTime_;
    private String name_;
    private String path_;
    private String ws_;
    private String uuid_;
    private String[] versionLabels_;

    public VersionNode(Version version, Session session) {
        block8: {
            this.isExpanded = true;
            this.children_ = new ArrayList<VersionNode>();
            this.name_ = "";
            this.path_ = "";
            this.ws_ = "";
            this.versionLabels_ = new String[0];
            try {
                block7: {
                    try {
                        this.createdTime_ = version.getCreated();
                        this.name_ = version.getName();
                        this.path_ = version.getPath();
                        this.ws_ = version.getSession().getWorkspace().getName();
                        this.uuid_ = version.getUUID();
                        this.versionLabels_ = version.getVersionHistory().getVersionLabels(version);
                    }
                    catch (UnsupportedRepositoryOperationException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.warn((Object)e.getMessage());
                        }
                    }
                    catch (Exception e) {
                        if (!LOG.isWarnEnabled()) break block7;
                        LOG.warn((Object)e.getMessage());
                    }
                }
                String uuid = version.getUUID();
                QueryManager queryManager = version.getSession().getWorkspace().getQueryManager();
                Query query = queryManager.createQuery("//element(*, nt:version)[@jcr:predecessors='" + uuid + "']", "xpath");
                QueryResult queryResult = query.execute();
                NodeIterator iterate = queryResult.getNodes();
                while (iterate.hasNext()) {
                    Version version1 = (Version)iterate.nextNode();
                    this.children_.add(new VersionNode(version1, session));
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block8;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
    }

    public VersionNode(Version version) throws RepositoryException {
        block7: {
            block6: {
                this.isExpanded = true;
                this.children_ = new ArrayList<VersionNode>();
                this.name_ = "";
                this.path_ = "";
                this.ws_ = "";
                this.versionLabels_ = new String[0];
                try {
                    this.createdTime_ = version.getCreated();
                    this.name_ = version.getName();
                    this.path_ = version.getPath();
                    this.ws_ = version.getSession().getWorkspace().getName();
                    this.uuid_ = version.getUUID();
                    this.versionLabels_ = version.getVersionHistory().getVersionLabels(version);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block6;
                    LOG.warn((Object)e.getMessage());
                }
            }
            try {
                Version[] versions = version.getSuccessors();
                if (versions == null || versions.length == 0) {
                    this.isExpanded = false;
                }
                for (Version versionChild : versions) {
                    this.children_.add(new VersionNode(versionChild));
                }
            }
            catch (PathNotFoundException e) {
                if (!LOG.isWarnEnabled()) break block7;
                LOG.warn((Object)e.getMessage());
            }
        }
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    public String getName() throws RepositoryException {
        return this.name_;
    }

    public String getWs() {
        return this.ws_;
    }

    public String getPath() throws RepositoryException {
        return this.path_;
    }

    public int getChildrenSize() {
        return this.children_.size();
    }

    public List<VersionNode> getChildren() {
        return this.children_;
    }

    public Calendar getCreatedTime() {
        return this.createdTime_;
    }

    public String[] getVersionLabels() {
        return this.versionLabels_;
    }

    public Node getNode(String nodeName) throws Exception {
        DMSConfiguration dmsConf = (DMSConfiguration)WCMCoreUtils.getService(DMSConfiguration.class);
        String systemWS = dmsConf.getConfig().getSystemWorkspace();
        ManageableRepository repo = WCMCoreUtils.getRepository();
        SessionProvider provider = systemWS.equals(this.ws_) ? WCMCoreUtils.getSystemSessionProvider() : WCMCoreUtils.getUserSessionProvider();
        return ((Node)provider.getSession(this.ws_, repo).getItem(this.path_)).getNode(nodeName);
    }

    public String getUUID() {
        return this.uuid_;
    }

    public VersionNode findVersionNode(String path) throws RepositoryException {
        if (this.path_.equals(path)) {
            return this;
        }
        VersionNode node = null;
        for (VersionNode child : this.children_) {
            node = child.findVersionNode(path);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public void removeVersionInChild(VersionNode versionNode1, VersionNode versionNodeRemove) throws RepositoryException {
        if (versionNode1.getChildren().contains(versionNodeRemove)) {
            versionNode1.getChildren().remove(versionNodeRemove);
        } else {
            for (VersionNode vsN : versionNode1.getChildren()) {
                this.removeVersionInChild(vsN, versionNodeRemove);
            }
        }
    }
}

