/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyManagerTrees;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeContainer;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeCreateChild;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.taxonomy.TaxonomyTreeData;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyNodeAlreadyExistsException;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UITaxonomyTreeCreateChildForm
extends UIForm {
    private static final String FIELD_PARENT = "parentPath";
    private static final String FIELD_NAME = "taxonomyName";

    public UITaxonomyTreeCreateChildForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormInputInfo(FIELD_PARENT, FIELD_PARENT, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
    }

    public void setParent(String path) {
        this.getUIFormInputInfo(FIELD_PARENT).setValue((Object)path);
        this.getUIStringInput(FIELD_NAME).setValue(null);
    }

    public static class CancelActionListener
    extends EventListener<UITaxonomyTreeCreateChildForm> {
        public void execute(Event<UITaxonomyTreeCreateChildForm> event) throws Exception {
            UITaxonomyTreeCreateChildForm uiForm = (UITaxonomyTreeCreateChildForm)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getParent();
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    public static class SaveActionListener
    extends EventListener<UITaxonomyTreeCreateChildForm> {
        public void execute(Event<UITaxonomyTreeCreateChildForm> event) throws Exception {
            UITaxonomyTreeCreateChildForm uiForm = (UITaxonomyTreeCreateChildForm)((Object)event.getSource());
            UITaxonomyTreeCreateChild uiCreateChild = (UITaxonomyTreeCreateChild)uiForm.getAncestorOfType(UITaxonomyTreeCreateChild.class);
            UITaxonomyTreeContainer uiTaxonomyTreeContainer = (UITaxonomyTreeContainer)uiForm.getAncestorOfType(UITaxonomyTreeContainer.class);
            UITaxonomyManagerTrees uiTaxonomyManageTrees = (UITaxonomyManagerTrees)uiForm.getAncestorOfType(UITaxonomyManagerTrees.class);
            TaxonomyTreeData taxoTreeData = uiTaxonomyTreeContainer.getTaxonomyTreeData();
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String title = (String)uiForm.getUIStringInput(UITaxonomyTreeCreateChildForm.FIELD_NAME).getValue();
            String name = Utils.cleanString((String)title);
            if (name == null || name.length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UITaxonomyTreeCreateChildForm.msg.name-null", null, 1));
                return;
            }
            try {
                TaxonomyService taxonomyService = (TaxonomyService)uiForm.getApplicationComponent(TaxonomyService.class);
                if (title.length() > Integer.parseInt(taxonomyService.getCategoryNameLength())) {
                    Object[] args = new Object[]{taxonomyService.getCategoryNameLength()};
                    uiApp.addMessage(new ApplicationMessage("UITaxonomyTreeCreateChildForm.msg.name-too-long", args, 1));
                    return;
                }
                String parentPath = (String)uiForm.getUIFormInputInfo(UITaxonomyTreeCreateChildForm.FIELD_PARENT).getValue();
                taxonomyService.addTaxonomyNode(taxoTreeData.getTaxoTreeWorkspace(), parentPath, Text.escapeIllegalJcrChars((String)name), Util.getPortalRequestContext().getRemoteUser());
                SessionProvider p = WCMCoreUtils.getUserSessionProvider();
                Session session = p.getSession(taxoTreeData.getTaxoTreeWorkspace(), WCMCoreUtils.getRepository());
                Node newNode = (Node)session.getItem(parentPath + "/" + name);
                if (newNode.canAddMixin("exo:rss-enable")) {
                    newNode.addMixin("exo:rss-enable");
                    newNode.setProperty("exo:title", title);
                }
                newNode.save();
                uiCreateChild.update();
            }
            catch (TaxonomyNodeAlreadyExistsException e) {
                Object[] arg = new Object[]{name};
                uiApp.addMessage(new ApplicationMessage("UITaxonomyTreeCreateChildForm.msg.exist", arg, 1));
                return;
            }
            catch (RepositoryException e) {
                Object[] arg = new Object[]{name};
                uiApp.addMessage(new ApplicationMessage("UITaxonomyTreeCreateChildForm.msg.error", arg, 1));
                return;
            }
            uiForm.reset();
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getParent();
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManageTrees);
        }
    }
}

