/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.Bookmark;

import java.net.URI;
import javax.jcr.Node;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="bookmarks/")
@Produces(value={"application/json"})
public class BookmarkRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(BookmarkRestService.class);
    private static final CacheControl cacheControl;

    @GET
    @Path(value="get")
    public Response get(@Context SecurityContext sc, @Context UriInfo uriInfo) throws Exception {
        try {
            SessionProvider sProvider;
            String viewerId = this.getUserId(sc, uriInfo);
            if (viewerId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            NodeHierarchyCreator nodeCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
            Node userPrivateNode = nodeCreator.getUserNode(sProvider = SessionProvider.createSystemProvider(), viewerId).getNode("Private");
            if (!userPrivateNode.hasNode("Bookmarks")) {
                Node bookmarksNode = userPrivateNode.addNode("Bookmarks");
                userPrivateNode.save();
                String default_bookmarks = "[{\"name\":\"Discussions\", \"link\":\"/$PORTAL/$SITENAME/forum\"},{\"name\":\"Wiki\", \"link\":\"/$PORTAL/$SITENAME/wiki\"},{\"name\":\"Documents\", \"link\":\"/$PORTAL/$SITENAME/documents\"},{\"name\":\"Agenda\", \"link\":\"/$PORTAL/$SITENAME/calendar\"}]";
                bookmarksNode.setProperty("exo:bookmarkService_bookmarks", default_bookmarks);
                if (bookmarksNode.canAddMixin("exo:hiddenable")) {
                    bookmarksNode.addMixin("exo:hiddenable");
                }
                bookmarksNode.save();
            }
            String bookmarks = userPrivateNode.getNode("Bookmarks").getProperty("exo:bookmarkService_bookmarks").getString();
            return Response.ok((Object)bookmarks, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.debug((Object)("Error in get bookmarks REST service: " + e.getMessage()), (Throwable)e);
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="set/{bookmarks}")
    public Response set(@PathParam(value="bookmarks") String bookmarks, @Context SecurityContext sc, @Context UriInfo uriInfo) throws Exception {
        try {
            SessionProvider sProvider;
            String viewerId = this.getUserId(sc, uriInfo);
            if (viewerId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            NodeHierarchyCreator nodeCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
            Node userPrivateNode = nodeCreator.getUserNode(sProvider = SessionProvider.createSystemProvider(), viewerId).getNode("Private");
            if (!userPrivateNode.hasNode("Bookmarks")) {
                userPrivateNode.addNode("Bookmarks");
                userPrivateNode.save();
            }
            Node bookmarksNode = userPrivateNode.getNode("Bookmarks");
            bookmarksNode.setProperty("exo:bookmarkService_bookmarks", bookmarks);
            bookmarksNode.save();
            return Response.ok((Object)"{\"status\":\"successed\"}", (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.debug((Object)("Error in set bookmarks REST service: " + e.getMessage()), (Throwable)e);
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    private String getUserId(SecurityContext sc, UriInfo uriInfo) {
        try {
            return sc.getUserPrincipal().getName();
        }
        catch (NullPointerException e) {
            return this.getViewerId(uriInfo);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getViewerId(UriInfo uriInfo) {
        String[] queryParts;
        URI uri = uriInfo.getRequestUri();
        String requestString = uri.getQuery();
        if (requestString == null) {
            return null;
        }
        for (String queryPart : queryParts = requestString.split("&")) {
            if (!queryPart.startsWith("opensocial_viewer_id")) continue;
            return queryPart.substring(queryPart.indexOf("=") + 1, queryPart.length());
        }
        return null;
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
    }
}

