/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.templates;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.cms.metadata.impl.MetadataServiceImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MetadataTemplateUpgradePlugin
extends UpgradeProductPlugin {
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    private MetadataService metadataService_;

    public MetadataTemplateUpgradePlugin(MetadataService metadataService, InitParams initParams) {
        super(initParams);
        this.metadataService_ = metadataService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        block7: {
            String unchangedMetadataTypes;
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
            }
            if (StringUtils.isEmpty((String)(unchangedMetadataTypes = PrivilegedSystemHelper.getProperty((String)"unchanged-metadata-templates")))) {
                unchangedMetadataTypes = "";
            }
            try {
                HashSet<String> unchangedMetadataTypeSet = new HashSet<String>();
                List configuredMetadataTypeSet = this.metadataService_.getMetadataList();
                ArrayList<String> removedMetadata = new ArrayList<String>();
                for (String unchangedMetadataType : unchangedMetadataTypes.split(",")) {
                    unchangedMetadataTypeSet.add(unchangedMetadataType.trim());
                }
                for (String metadataType : configuredMetadataTypeSet) {
                    if (unchangedMetadataTypeSet.contains(metadataType)) continue;
                    removedMetadata.add(metadataType);
                    this.log.info((Object)("Metadata " + metadataType + " will be updated."));
                }
                for (String removedMetadataNode : removedMetadata) {
                    this.metadataService_.removeMetadata(removedMetadataNode);
                }
                ((MetadataServiceImpl)this.metadataService_).start();
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block7;
                this.log.error((Object)"An unexpected error occurs when migrating metadata template", (Throwable)e);
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

