/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service.updater;

import java.io.IOException;
import java.io.InputStream;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Managed
@NameTemplate(value={@Property(key="product.group.id", value="org.exoplatform.forum"), @Property(key="location", value="{location}")})
@ManagedDescription(value="Plugin that allows to migration default template of FAQ viewer.")
public class FAQPreferenceTemplateUpdaterPlugin
extends UpgradeProductPlugin {
    private static Log LOG = ExoLogger.getLogger(FAQPreferenceTemplateUpdaterPlugin.class);
    private String location = null;

    public FAQPreferenceTemplateUpdaterPlugin(InitParams params) {
        super(params);
        ValueParam param = params.getValueParam("location");
        if (param == null) {
            LOG.warn((Object)("Value-param 'location' is missing for " + this.getName() + ". The plugin will not be used"));
        } else {
            this.location = param.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (this.shouldProceedToUpgrade(newVersion, oldVersion)) {
            LOG.info((Object)"\n Starts migration template of FAQ viewer");
            FAQService faqService = (FAQService)ExoContainerContext.getCurrentContainer().getComponentInstance(FAQService.class);
            InputStream in = null;
            try {
                in = this.getTemplateStream();
                if (in != null) {
                    byte[] data = new byte[in.available()];
                    in.read(data);
                    faqService.saveTemplate(new String(data, "UTF-8"));
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Failed to migtation template of FAQ viewer", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"Failed to execute migration template of FAQ viewer", (Throwable)e);
                    }
                }
            }
            LOG.info((Object)"\n End migration template of FAQ viewer!");
        }
    }

    public InputStream getTemplateStream() throws Exception {
        if (!CommonUtils.isEmpty((String)this.location)) {
            ConfigurationManager configurationManager = (ConfigurationManager)ExoContainerContext.getCurrentContainer().getComponentInstance(ConfigurationManager.class);
            return configurationManager.getInputStream(this.location);
        }
        return null;
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

