/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.RepeatableReadEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;

public class ClusteredRepeatableReadEntry
extends RepeatableReadEntry {
    private EntryVersion version;

    public ClusteredRepeatableReadEntry(Object key, Object value, EntryVersion version, long lifespan) {
        super(key, value, version, lifespan);
        this.version = version;
    }

    public boolean performWriteSkewCheck(DataContainer container) {
        InternalCacheEntry ice = container.get(this.key);
        if (ice == null) {
            return this.version == null;
        }
        if (ice.getVersion() == null) {
            throw new IllegalStateException("Entries cannot have null versions!");
        }
        if (this.version == null) {
            return true;
        }
        return InequalVersionComparisonResult.AFTER != ice.getVersion().compareTo(this.version);
    }

    @Override
    public EntryVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(EntryVersion version) {
        this.version = version;
    }
}

