/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcache;

import org.exoplatform.commons.cache.future.FutureCache;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.portletcache.MarkupFragment;
import org.exoplatform.services.portletcache.PortletRenderContext;
import org.exoplatform.services.portletcache.PortletRenderer;
import org.exoplatform.services.portletcache.WindowKey;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="fragmentcache"), @Property(key="type", value="content")})
@ManagedDescription(value="FragmentCache Service")
@RESTEndpoint(path="fragmentcacheservice")
public class FragmentCacheService
implements Startable {
    private static final int DEFAULT_CACHE_SIZE = 10000;
    private static final int DEFAULT_CACHE_CLEANUP = 30;
    private static final Log LOG = ExoLogger.getLogger((String)FragmentCacheService.class.getName());
    private ExoCache<WindowKey, MarkupFragment> markupCache_;
    private FutureCache<WindowKey, MarkupFragment, PortletRenderContext> futureCache;

    public FragmentCacheService(CacheService cacheService, InitParams params) {
        this.markupCache_ = cacheService.getCacheInstance(FragmentCacheService.class.getSimpleName());
        this.futureCache = new FutureExoCache((Loader)new PortletRenderer(LOG), this.markupCache_);
    }

    public MarkupFragment getMarkupFragment(PortletRenderContext context, WindowKey key) {
        return (MarkupFragment)this.futureCache.get((Object)context, (Object)key);
    }

    public void setCacheSize(int size) {
        this.markupCache_.setMaxSize(size);
    }

    public void start() {
    }

    public void stop() {
    }
}

