/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.space.model.Space;

public class LinkProviderUtils {
    public static final String RESOURCE_URL = "social/notifications";
    public static final String INVITE_TO_CONNECT = "social/notifications/inviteToConnect";
    public static final String CONFIRM_INVITATION_TO_CONNECT = "social/notifications/confirmInvitationToConnect";
    public static final String IGNORE_INVITATION_TO_CONNECT = "social/notifications/ignoreInvitationToConnect";
    public static final String ACCEPT_INVITATION_JOIN_SPACE = "social/notifications/acceptInvitationToJoinSpace";
    public static final String IGNORE_INVITATION_JOIN_SPACE = "social/notifications/ignoreInvitationToJoinSpace";
    public static final String VALIDATE_REQUEST_JOIN_SPACE = "social/notifications/validateRequestToJoinSpace";
    public static final String REFUSE_SPACE_REQUEST_ACTION = "social/notifications/refuseRequestToJoinSpace";
    public static final String REPLY_ACTIVITY = "social/notifications/replyActivity";
    public static final String VIEW_FULL_DISCUSSION = "social/notifications/viewFullDiscussion";
    public static final String REDIRECT_URL = "social/notifications/redirectUrl";

    public static String getInviteToConnectUrl(String receiverId, String senderId) {
        return LinkProviderUtils.getRestUrl(INVITE_TO_CONNECT, receiverId, senderId);
    }

    public static String getConfirmInvitationToConnectUrl(String senderId, String receiverId) {
        return LinkProviderUtils.getRestUrl(CONFIRM_INVITATION_TO_CONNECT, senderId, receiverId);
    }

    public static String getIgnoreInvitationToConnectUrl(String senderId, String receiverId) {
        return LinkProviderUtils.getRestUrl(IGNORE_INVITATION_TO_CONNECT, senderId, receiverId);
    }

    public static String getAcceptInvitationToJoinSpaceUrl(String spaceId, String userId) {
        return LinkProviderUtils.getRestUrl(ACCEPT_INVITATION_JOIN_SPACE, spaceId, userId);
    }

    public static String getIgnoreInvitationToJoinSpaceUrl(String spaceId, String userId) {
        return LinkProviderUtils.getRestUrl(IGNORE_INVITATION_JOIN_SPACE, spaceId, userId);
    }

    public static String getValidateRequestToJoinSpaceUrl(String spaceId, String userId) {
        return LinkProviderUtils.getRestUrl(VALIDATE_REQUEST_JOIN_SPACE, spaceId, userId);
    }

    public static String getRefuseRequestToJoinSpaceUrl(String spaceId, String userId) {
        return LinkProviderUtils.getRestUrl(REFUSE_SPACE_REQUEST_ACTION, spaceId, userId);
    }

    public static String getRedirectUrl(String type, String objectId) {
        return LinkProviderUtils.getRestUrl(REDIRECT_URL, type, objectId);
    }

    public static String getRestUrl(String type, String objectId1, String objectId2) {
        String baseUrl = LinkProviderUtils.getBaseRestUrl();
        return new StringBuffer(baseUrl).append("/").append(type).append("/").append(objectId1).append("/").append(objectId2).toString();
    }

    public static String getBaseRestUrl() {
        return new StringBuffer(CommonsUtils.getCurrentDomain()).append("/").append(CommonsUtils.getRestContextName()).toString();
    }

    public static String getUserAvatarUrl(Profile profile) {
        return CommonsUtils.getCurrentDomain() + (profile != null && profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/social-resources/skin/images/ShareImages/UserAvtDefault.png");
    }

    public static String getSpaceAvatarUrl(Space space) {
        return CommonsUtils.getCurrentDomain() + (space != null && space.getAvatarUrl() != null ? space.getAvatarUrl() : "/social-resources/skin/images/ShareImages/SpaceAvtDefault.png");
    }
}

