/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.rest.providers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import javax.xml.stream.XMLStreamConstants;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.management.api.ContentType;
import org.gatein.management.api.binding.BindingException;
import org.gatein.management.api.binding.Marshaller;
import org.gatein.management.rest.ContentTypeUtils;
import org.gatein.management.rest.providers.BindingProviderResolver;

@Provider
@Consumes(value={"application/xml", "application/json", "application/zip"})
@Produces(value={"application/xml", "application/json", "application/zip"})
public class ManagedComponentProvider<T>
implements MessageBodyReader<T>,
MessageBodyWriter<T>,
XMLStreamConstants {
    private static final Logger log = LoggerFactory.getLogger(ManagedComponentProvider.class);
    @Context
    private Providers providers;
    @Context
    private UriInfo uriInfo;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.getMarshaller(type, mediaType) != null;
    }

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return (T)this.getMarshaller(type, mediaType).unmarshal(entityStream);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.getMarshaller(type, mediaType) != null;
    }

    public long getSize(T entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(T entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            this.getMarshaller(type, mediaType).marshal(entity, entityStream);
        }
        catch (BindingException e) {
            log.error((Object)("Exception marshalling entity " + entity.getClass() + " for media type " + mediaType), (Throwable)e);
            throw new IOException("Exception marshalling data.");
        }
    }

    private Marshaller<T> getMarshaller(Type genericType, MediaType mediaType) {
        Class<T> type = this.getType(genericType);
        ContentType contentType = ContentTypeUtils.getContentType(mediaType);
        if (contentType == null) {
            log.warn((Object)("No content type found for media type " + mediaType));
            return null;
        }
        ContextResolver resolver = this.providers.getContextResolver(BindingProviderResolver.class, mediaType);
        if (resolver == null) {
            throw new RuntimeException("Could not find marshaller resolver for media type " + mediaType);
        }
        String componentName = null;
        if (this.uriInfo.getPathSegments().size() > 1) {
            componentName = ((PathSegment)this.uriInfo.getPathSegments().get(1)).getPath();
        }
        return ((BindingProviderResolver)resolver.getContext(type)).getMarshaller(type, contentType, componentName);
    }

    private Class<T> getType(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            Type[] arguments = pt.getActualTypeArguments();
            if (arguments != null && arguments.length == 1) {
                Type arg = arguments[0];
                if (arg instanceof TypeVariable) {
                    return (Class)((TypeVariable)arg).getBounds()[0];
                }
                return (Class)arg;
            }
            return (Class)pt.getRawType();
        }
        return (Class)genericType;
    }
}

