/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.impl;

import javax.servlet.http.HttpSessionEvent;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.impl.SessionManager;

public class SessionDestroyedListener
extends Listener<PortalContainer, HttpSessionEvent> {
    private static Log LOG = ExoLogger.getLogger((String)"SessionDestroyedListener");

    public void onEvent(Event<PortalContainer, HttpSessionEvent> event) throws Exception {
        PortalContainer container = (PortalContainer)event.getSource();
        String sessionId = ((HttpSessionEvent)event.getData()).getSession().getId();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Removing the key: " + sessionId));
        }
        try {
            SessionManager sessionManager = (SessionManager)container.getComponentInstanceOfType(SessionManager.class);
            sessionManager.removeSessionContainer(sessionId);
        }
        catch (Exception e) {
            LOG.warn((Object)("Can't remove the key: " + sessionId), (Throwable)e);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Removed the key: " + sessionId));
        }
        if (container.isStarted()) {
            WikiService wikiService = (WikiService)container.getComponentInstanceOfType(WikiService.class);
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            wikiService.deleteDraftNewPage(sessionId);
            RequestLifeCycle.end();
        }
    }
}

