/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.template;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.plugin.config.TemplateConfig;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.api.notification.template.Element;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.template.DigestTemplate;
import org.exoplatform.commons.notification.template.GroovyElement;
import org.exoplatform.commons.notification.template.GroovyElementVisitor;
import org.exoplatform.commons.notification.template.SimpleElementVistior;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.groovyscript.GroovyTemplate;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.gatein.common.io.IOTools;

public class TemplateUtils {
    private static final Log LOG = ExoLogger.getLogger(TemplateUtils.class);
    private static final String DIGEST_TEMPLATE_KEY = "Digest.{0}.{1}";
    private static final String SIMPLE_TEMPLATE_KEY = "Simple.{0}.{1}";
    private static final Pattern SCRIPT_REMOVE_PATTERN = Pattern.compile("<(script|style)[^>]*>[^<]*</(script|style)>", 2);
    private static final Pattern TAGS_REMOVE_PATTERN = Pattern.compile("<[^>]*>", 2);
    private static Map<String, Element> cacheTemplate = new ConcurrentHashMap<String, Element>();
    private static final int MAX_SUBJECT_LENGTH = 50;

    public static String processGroovy(TemplateContext ctx) {
        Element groovyElement = TemplateUtils.loadGroovyElement(ctx.getPluginId(), ctx.getLanguage());
        GroovyElementVisitor visitor = new GroovyElementVisitor();
        String content = visitor.with(ctx).visit(groovyElement).out();
        return content;
    }

    public static void loadGroovy(TemplateContext context, Element element, Writer out) {
        try {
            String groovyTemplate = element.getTemplate();
            if (groovyTemplate == null) {
                groovyTemplate = TemplateUtils.loadGroovyTemplate(element.getTemplateConfig().getTemplatePath());
                element.template(groovyTemplate);
            }
            if (groovyTemplate != null && groovyTemplate.length() > 0) {
                GroovyTemplate gTemplate = new GroovyTemplate(groovyTemplate);
                gTemplate.render(out, (Map)context);
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("The function only load groovy with GroovyElement type.");
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to load groovy template of plugin " + context.getPluginId() + "\n" + e.getMessage()));
        }
    }

    private static InputStream getTemplateInputStream(String templatePath) throws Exception {
        try {
            ConfigurationManager configurationManager = CommonsUtils.getService(ConfigurationManager.class);
            String uri = templatePath;
            if (templatePath.indexOf("war") < 0 && templatePath.indexOf("jar") < 0 && templatePath.indexOf("classpath") < 0) {
                URL url = null;
                if (templatePath.indexOf("/") == 0) {
                    templatePath = templatePath.substring(1);
                }
                if ((url = configurationManager.getURL(uri = "war:/" + templatePath)) == null) {
                    uri = "jar:/" + templatePath;
                    URL uRL = configurationManager.getURL(uri);
                }
            }
            return configurationManager.getInputStream(uri);
        }
        catch (Exception e) {
            throw new RuntimeException("Error to get notification template " + templatePath, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadGroovyTemplate(String templatePath) throws Exception {
        StringWriter templateText = new StringWriter();
        try (InputStreamReader reader = null;){
            reader = new InputStreamReader(TemplateUtils.getTemplateInputStream(templatePath));
            IOTools.copy((Reader)reader, (Writer)templateText);
        }
        return templateText.toString();
    }

    public static Element loadGroovyElement(String pluginId, String language) {
        TemplateConfig templateConfig = TemplateUtils.getTemplateConfig(pluginId);
        return new GroovyElement().language(language).config(templateConfig);
    }

    public static String processSubject(TemplateContext ctx) {
        String subject;
        Element subjectElement = null;
        String key = TemplateUtils.makeTemplateKey(SIMPLE_TEMPLATE_KEY, ctx.getPluginId(), ctx.getLanguage());
        if (cacheTemplate.containsKey(key)) {
            subjectElement = cacheTemplate.get(key);
        } else {
            TemplateConfig templateConfig = TemplateUtils.getTemplateConfig(ctx.getPluginId());
            subjectElement = NotificationUtils.getSubject(templateConfig, ctx.getPluginId(), ctx.getLanguage()).addNewLine(false);
            cacheTemplate.put(key, subjectElement);
        }
        String value = (String)ctx.get((Object)"ACTIVITY");
        if (value != null) {
            ctx.put((Object)"ACTIVITY", (Object)StringEscapeUtils.unescapeHtml((String)value));
        }
        if ((subject = (String)ctx.get((Object)"SUBJECT")) != null && subject.length() > 0) {
            ctx.put((Object)"SUBJECT", (Object)TemplateUtils.getExcerptSubject(subject));
            return subjectElement.accept(SimpleElementVistior.instance().with(ctx)).out();
        }
        subject = subjectElement.accept(SimpleElementVistior.instance().with(ctx)).out();
        return TemplateUtils.getExcerptSubject(subject);
    }

    public static String getExcerptSubject(String subject) {
        String newSubject = StringEscapeUtils.unescapeHtml((String)TemplateUtils.cleanHtmlTags(subject));
        if (newSubject != null && newSubject.length() > 50) {
            newSubject = newSubject.substring(0, 50);
            int lastSpace = newSubject.lastIndexOf(" ");
            return (lastSpace > 0 ? newSubject.substring(0, lastSpace) : newSubject) + "...";
        }
        return newSubject;
    }

    public static String cleanHtmlTags(String str) {
        if (str == null || str.trim().length() == 0) {
            return "";
        }
        String newSubject = StringUtils.replace((String)str, (String)"\n", (String)" ");
        newSubject = SCRIPT_REMOVE_PATTERN.matcher(newSubject).replaceAll("");
        newSubject = TAGS_REMOVE_PATTERN.matcher(newSubject).replaceAll(" ");
        return newSubject.replaceAll("\\s+", " ").trim();
    }

    public static String processDigest(TemplateContext ctx) {
        DigestTemplate digest = null;
        String key = TemplateUtils.makeTemplateKey(DIGEST_TEMPLATE_KEY, ctx.getPluginId(), ctx.getLanguage());
        if (cacheTemplate.containsKey(key)) {
            digest = (DigestTemplate)cacheTemplate.get(key);
        } else {
            TemplateConfig templateConfig = TemplateUtils.getTemplateConfig(ctx.getPluginId());
            digest = NotificationUtils.getDigest(templateConfig, ctx.getPluginId(), ctx.getLanguage());
            cacheTemplate.put(key, digest);
        }
        return digest.accept(SimpleElementVistior.instance().with(ctx)).out();
    }

    private static String makeTemplateKey(String pattern, String pluginId, String language) {
        return MessageFormat.format(pattern, pluginId, language);
    }

    private static TemplateConfig getTemplateConfig(String pluginId) {
        PluginConfig pluginConfig = NotificationContextImpl.cloneInstance().getPluginSettingService().getPluginConfig(pluginId);
        if (pluginConfig == null) {
            throw new IllegalStateException("PluginConfig is NULL with plugId = " + pluginId);
        }
        return pluginConfig.getTemplateConfig();
    }

    public static String getResourceBundle(String key, Locale locale, String resourcePath) {
        ResourceBundleService bundleService;
        ResourceBundle res;
        if (key == null || key.trim().length() == 0) {
            return "";
        }
        if (locale == null || locale.getLanguage().isEmpty()) {
            locale = Locale.ENGLISH;
        }
        if ((res = (bundleService = CommonsUtils.getService(ResourceBundleService.class)).getResourceBundle(resourcePath, locale)) == null || !res.containsKey(key)) {
            LOG.warn((Object)("Resource Bundle key not found. " + key + " in source path: " + resourcePath));
            return key;
        }
        return res.getString(key);
    }
}

