/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.LinkedList;
import javax.jcr.Session;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryManager;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryResultImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class EventListAccess
implements ListAccess<Row> {
    private static Log log = ExoLogger.getLogger(EventListAccess.class);
    private JCRDataStorage storage;
    private EventQuery query;
    private Integer size;

    public EventListAccess(JCRDataStorage storage, EventQuery eventQuery) {
        this.query = eventQuery;
        this.storage = storage;
    }

    public Row[] load(int offset, int limit) {
        try {
            Session session = this.storage.getSession(this.storage.createSystemProvider());
            QueryManager queryMan = session.getWorkspace().getQueryManager();
            QueryImpl jcrQuery = (QueryImpl)queryMan.createQuery(this.query.getQueryStatement(), this.query.getQueryType());
            if (limit > 0) {
                jcrQuery.setOffset((long)offset);
                jcrQuery.setLimit((long)limit);
            }
            QueryResultImpl queryResult = (QueryResultImpl)jcrQuery.execute();
            RowIterator rows = jcrQuery.execute().getRows();
            LinkedList<Row> results = new LinkedList<Row>();
            while (rows.hasNext()) {
                results.add(rows.nextRow());
            }
            this.size = queryResult.getTotalSize();
            return results.toArray(new Row[results.size()]);
        }
        catch (InvalidQueryException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"JCRQuery is invalid", (Throwable)ex);
            }
            return null;
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public int getSize() throws Exception {
        if (this.size == null) {
            System.out.println("Querying to get Size");
            this.load(0, 0);
        }
        return this.size;
    }
}

