/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.notification.plugin;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationChildPlugin;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.ext.activity.ForumActivityUtils;
import org.exoplatform.forum.notification.plugin.ForumNotificationUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class AnswerActivityChildPlugin
extends AbstractNotificationChildPlugin {
    public static final String ID = "ks-answer:spaces";
    private ExoSocialActivity activity = null;

    public AnswerActivityChildPlugin(InitParams initParams) {
        super(initParams);
    }

    public String makeContent(NotificationContext ctx) {
        try {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = new TemplateContext(ID, language);
            String activityId = notification.getValueOwnerParameter(ForumNotificationUtils.ACTIVITY_ID.getKey());
            this.activity = ForumActivityUtils.getActivityManager().getActivity(activityId);
            if (this.activity.isComment()) {
                this.activity = ForumActivityUtils.getActivityManager().getParentActivity(this.activity);
            }
            templateContext.put((Object)"ACTIVITY", (Object)this.activity.getTitle());
            String content = TemplateUtils.processGroovy((TemplateContext)templateContext);
            return content;
        }
        catch (Exception e) {
            return this.activity != null ? this.activity.getTitle() : "";
        }
    }

    public String getActivityParamValue(String key) {
        return ForumNotificationUtils.getActivityParamValue(this.activity, key);
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return false;
    }
}

