/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.viewer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.pdfviewer.PDFViewerService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.PInfo;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:resources/templates/PDFViewer.gtmpl", events={@EventConfig(listeners={NextPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={PreviousPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={GotoPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RotateRightPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RotateLeftPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ScalePageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DownloadFileActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ZoomInPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ZoomOutPageActionListener.class}, phase=Event.Phase.DECODE)})
public class PDFViewer
extends UIForm {
    private static final String PAGE_NUMBER = "pageNumber";
    private static final String SCALE_PAGE = "scalePage";
    private final String localeFile = "locale.portlet.viewer.PDFViewer";
    private int currentPageNumber_ = 1;
    private int maximumOfPage_ = 0;
    private float currentRotation_ = 0.0f;
    private float currentScale_ = 1.0f;
    private Map<String, String> metadatas = new HashMap<String, String>();

    public PDFViewer() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PAGE_NUMBER, PAGE_NUMBER, "1"));
        UIFormSelectBox uiScaleBox = new UIFormSelectBox(SCALE_PAGE, SCALE_PAGE, this.initScaleOptions());
        uiScaleBox.setOnChange("ScalePage");
        this.addUIFormInput((UIFormInput)uiScaleBox);
        uiScaleBox.setValue("1.0f");
    }

    public Method getMethod(UIComponent uiComponent, String name) throws NoSuchMethodException {
        return uiComponent.getClass().getMethod(name, new Class[0]);
    }

    public void initDatas() throws Exception {
        UIComponent uiParent = this.getParent();
        Method method = this.getMethod(uiParent, "getOriginalNode");
        Node originalNode = null;
        if (method != null) {
            originalNode = (Node)method.invoke((Object)uiParent, (Object[])null);
        }
        if (originalNode != null) {
            Document document = this.getDocument(originalNode);
            if (document != null) {
                this.maximumOfPage_ = document.getNumberOfPages();
                this.metadatas.clear();
                this.putDocumentInfo(document.getInfo());
                document.dispose();
            } else {
                this.maximumOfPage_ = -1;
            }
        }
    }

    public Map getMetadataExtraction() {
        return this.metadatas;
    }

    public int getMaximumOfPage() throws Exception {
        if (this.maximumOfPage_ == 0) {
            this.initDatas();
        }
        return this.maximumOfPage_;
    }

    public float getCurrentRotation() {
        return this.currentRotation_;
    }

    public void setRotation(float rotation) {
        this.currentRotation_ = rotation;
    }

    public float getCurrentScale() {
        return this.currentScale_;
    }

    public void setScale(float scale) {
        this.currentScale_ = scale;
    }

    public int getPageNumber() {
        return this.currentPageNumber_;
    }

    public void setPageNumber(int pageNum) {
        this.currentPageNumber_ = pageNum;
    }

    public String getResourceBundle(String key) {
        Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
        ResourceBundleService resourceBundleService = (ResourceBundleService)WCMCoreUtils.getService(ResourceBundleService.class);
        ResourceBundle resourceBundle = resourceBundleService.getResourceBundle("locale.portlet.viewer.PDFViewer", locale, ((Object)((Object)this)).getClass().getClassLoader());
        return resourceBundle.getString(key);
    }

    private Document getDocument(Node node) throws RepositoryException, Exception {
        PDFViewerService pdfViewerService = (PDFViewerService)this.getApplicationComponent(PDFViewerService.class);
        String repository = (String)this.getMethod(this.getParent(), "getRepository").invoke((Object)this.getParent(), (Object[])null);
        return pdfViewerService.initDocument(node, repository);
    }

    private void putDocumentInfo(PInfo documentInfo) {
        if (documentInfo != null) {
            if (documentInfo.getTitle() != null && documentInfo.getTitle().length() > 0) {
                this.metadatas.put("title", documentInfo.getTitle());
            }
            if (documentInfo.getAuthor() != null && documentInfo.getAuthor().length() > 0) {
                this.metadatas.put("author", documentInfo.getAuthor());
            }
            if (documentInfo.getSubject() != null && documentInfo.getSubject().length() > 0) {
                this.metadatas.put("subject", documentInfo.getSubject());
            }
            if (documentInfo.getKeywords() != null && documentInfo.getKeywords().length() > 0) {
                this.metadatas.put("keyWords", documentInfo.getKeywords());
            }
            if (documentInfo.getCreator() != null && documentInfo.getCreator().length() > 0) {
                this.metadatas.put("creator", documentInfo.getCreator());
            }
            if (documentInfo.getProducer() != null && documentInfo.getProducer().length() > 0) {
                this.metadatas.put("producer", documentInfo.getProducer());
            }
            if (documentInfo.getCreationDate() != null) {
                this.metadatas.put("creationDate", documentInfo.getCreationDate().toString());
            }
            if (documentInfo.getModDate() != null) {
                this.metadatas.put("modDate", documentInfo.getModDate().toString());
            }
        }
    }

    private List<SelectItemOption<String>> initScaleOptions() {
        ArrayList<SelectItemOption<String>> scaleOptions = new ArrayList<SelectItemOption<String>>();
        scaleOptions.add(new SelectItemOption("5%", (Object)"0.05f"));
        scaleOptions.add(new SelectItemOption("10%", (Object)"0.1f"));
        scaleOptions.add(new SelectItemOption("25%", (Object)"0.25f"));
        scaleOptions.add(new SelectItemOption("50%", (Object)"0.5f"));
        scaleOptions.add(new SelectItemOption("75%", (Object)"0.75f"));
        scaleOptions.add(new SelectItemOption("100%", (Object)"1.0f"));
        scaleOptions.add(new SelectItemOption("125%", (Object)"1.25f"));
        scaleOptions.add(new SelectItemOption("150%", (Object)"1.5f"));
        scaleOptions.add(new SelectItemOption("200%", (Object)"2.0f"));
        scaleOptions.add(new SelectItemOption("300%", (Object)"3.0f"));
        return scaleOptions;
    }

    public static Node getFileLangNode(Node currentNode) throws Exception {
        if (currentNode.isNodeType("nt:unstructured") && currentNode.getNodes().getSize() > 0L) {
            NodeIterator nodeIter = currentNode.getNodes();
            while (nodeIter.hasNext()) {
                Node ntFile = nodeIter.nextNode();
                if (!ntFile.isNodeType("nt:file")) continue;
                return ntFile;
            }
            return currentNode;
        }
        return currentNode;
    }

    public static class ZoomOutPageActionListener
    extends EventListener<PDFViewer> {
        public void execute(Event<PDFViewer> event) throws Exception {
            PDFViewer pdfViewer = (PDFViewer)((Object)event.getSource());
            String scale = (String)pdfViewer.getUIFormSelectBox(PDFViewer.SCALE_PAGE).getValue();
            String[] arrValue = new String[]{"0.05f", "0.1f", "0.25f", "0.5f", "0.75f", "1.0f", "1.25f", "1.5f", "2.0f", "3.0f"};
            if (scale.equals(arrValue[0])) {
                return;
            }
            for (int i = 0; i < arrValue.length - 1; ++i) {
                if (!scale.equals(arrValue[i])) continue;
                pdfViewer.setScale(Float.parseFloat(arrValue[i - 1]));
                pdfViewer.getUIFormSelectBox(PDFViewer.SCALE_PAGE).setValue(arrValue[i - 1]);
                break;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pdfViewer);
        }
    }

    public static class ZoomInPageActionListener
    extends EventListener<PDFViewer> {
        public void execute(Event<PDFViewer> event) throws Exception {
            PDFViewer pdfViewer = (PDFViewer)((Object)event.getSource());
            String[] arrValue = new String[]{"0.05f", "0.1f", "0.25f", "0.5f", "0.75f", "1.0f", "1.25f", "1.5f", "2.0f", "3.0f"};
            String scale = (String)pdfViewer.getUIFormSelectBox(PDFViewer.SCALE_PAGE).getValue();
            if (scale.equals(arrValue[arrValue.length - 1])) {
                return;
            }
            for (int i = 0; i < arrValue.length - 1; ++i) {
                if (!scale.equals(arrValue[i])) continue;
                pdfViewer.setScale(Float.parseFloat(arrValue[i + 1]));
                pdfViewer.getUIFormSelectBox(PDFViewer.SCALE_PAGE).setValue(arrValue[i + 1]);
                break;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pdfViewer);
        }
    }

    public static class DownloadFileActionListener
    extends EventListener<PDFViewer> {
        public void execute(Event<PDFViewer> event) throws Exception {
            PDFViewer pdfViewer = (PDFViewer)((Object)event.getSource());
            UIComponent uiParent = pdfViewer.getParent();
            Method methodGetNode = pdfViewer.getMethod(uiParent, "getNode");
            Node node = (Node)methodGetNode.invoke((Object)uiParent, (Object[])null);
            node = PDFViewer.getFileLangNode(node);
            String repository = (String)pdfViewer.getMethod(uiParent, "getRepository").invoke((Object)uiParent, (Object[])null);
            PDFViewerService pdfViewerService = (PDFViewerService)pdfViewer.getApplicationComponent(PDFViewerService.class);
            File file = pdfViewerService.getPDFDocumentFile(node, repository);
            String fileName = node.getName();
            int index = fileName.lastIndexOf(46);
            if (index < 0) {
                fileName = fileName + ".pdf";
            } else if (index == fileName.length() - 1) {
                fileName = fileName + "pdf";
            } else {
                String extension = fileName.substring(index + 1);
                fileName = fileName.replace(extension, "pdf");
            }
            DownloadService dservice = (DownloadService)pdfViewer.getApplicationComponent(DownloadService.class);
            InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)new BufferedInputStream(new FileInputStream(file)), DMSMimeTypeResolver.getInstance().getMimeType(".pdf"));
            dresource.setDownloadName(fileName);
            String downloadLink = dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
            RequireJS requireJS = event.getRequestContext().getJavascriptManager().getRequireJS();
            requireJS.require("SHARED/ecm-utils", "ecmutil").addScripts("ecmutil.ECMUtils.ajaxRedirect('" + downloadLink + "');");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pdfViewer);
        }
    }

    public static class ScalePageActionListener
    extends EventListener<PDFViewer> {
        public void execute(Event<PDFViewer> event) throws Exception {
            PDFViewer pdfViewer = (PDFViewer)((Object)event.getSource());
            String scale = (String)pdfViewer.getUIFormSelectBox(PDFViewer.SCALE_PAGE).getValue();
            pdfViewer.setScale(Float.parseFloat(scale));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pdfViewer);
        }
    }

    public static class RotateLeftPageActionListener
    extends EventListener<PDFViewer> {
        public void execute(Event<PDFViewer> event) throws Exception {
            PDFViewer pdfViewer = (PDFViewer)((Object)event.getSource());
            pdfViewer.setRotation(pdfViewer.currentRotation_ + 90.0f);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pdfViewer);
        }
    }

    public static class RotateRightPageActionListener
    extends EventListener<PDFViewer> {
        public void execute(Event<PDFViewer> event) throws Exception {
            PDFViewer pdfViewer = (PDFViewer)((Object)event.getSource());
            pdfViewer.setRotation(pdfViewer.currentRotation_ + 270.0f);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pdfViewer);
        }
    }

    public static class GotoPageActionListener
    extends EventListener<PDFViewer> {
        public void execute(Event<PDFViewer> event) throws Exception {
            PDFViewer pdfViewer = (PDFViewer)((Object)event.getSource());
            String pageStr = (String)pdfViewer.getUIStringInput(PDFViewer.PAGE_NUMBER).getValue();
            int pageNumber = 1;
            try {
                pageNumber = Integer.parseInt(pageStr);
            }
            catch (NumberFormatException e) {
                pageNumber = pdfViewer.currentPageNumber_;
            }
            if (pageNumber >= pdfViewer.maximumOfPage_) {
                pageNumber = pdfViewer.maximumOfPage_;
            } else if (pageNumber < 1) {
                pageNumber = 1;
            }
            pdfViewer.getUIStringInput(PDFViewer.PAGE_NUMBER).setValue((Object)Integer.toString(pageNumber));
            pdfViewer.setPageNumber(pageNumber);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pdfViewer);
        }
    }

    public static class NextPageActionListener
    extends EventListener<PDFViewer> {
        public void execute(Event<PDFViewer> event) throws Exception {
            PDFViewer pdfViewer = (PDFViewer)((Object)event.getSource());
            if (pdfViewer.currentPageNumber_ == pdfViewer.maximumOfPage_) {
                pdfViewer.getUIStringInput(PDFViewer.PAGE_NUMBER).setValue((Object)Integer.toString(pdfViewer.currentPageNumber_));
            } else {
                pdfViewer.getUIStringInput(PDFViewer.PAGE_NUMBER).setValue((Object)Integer.toString(pdfViewer.currentPageNumber_ + 1));
                pdfViewer.setPageNumber(pdfViewer.currentPageNumber_ + 1);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pdfViewer);
        }
    }

    public static class PreviousPageActionListener
    extends EventListener<PDFViewer> {
        public void execute(Event<PDFViewer> event) throws Exception {
            PDFViewer pdfViewer = (PDFViewer)((Object)event.getSource());
            if (pdfViewer.currentPageNumber_ == 1) {
                pdfViewer.getUIStringInput(PDFViewer.PAGE_NUMBER).setValue((Object)Integer.toString(pdfViewer.currentPageNumber_));
            } else {
                pdfViewer.getUIStringInput(PDFViewer.PAGE_NUMBER).setValue((Object)Integer.toString(pdfViewer.currentPageNumber_ - 1));
                pdfViewer.setPageNumber(pdfViewer.currentPageNumber_ - 1);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pdfViewer);
        }
    }
}

