/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.definitions;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinCommand;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinEnvironment;
import uk.ac.ed.ph.snuggletex.definitions.CommandType;
import uk.ac.ed.ph.snuggletex.definitions.Globals;
import uk.ac.ed.ph.snuggletex.definitions.LaTeXMode;
import uk.ac.ed.ph.snuggletex.definitions.TextFlowContext;
import uk.ac.ed.ph.snuggletex.dombuilding.CommandHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.EnvironmentHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.InterpretableSimpleMathHandler;
import uk.ac.ed.ph.snuggletex.semantics.Interpretation;
import uk.ac.ed.ph.snuggletex.semantics.InterpretationType;
import uk.ac.ed.ph.snuggletex.semantics.MathInterpretation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefinitionMap {
    public final Map<String, BuiltinCommand> builtinCommandMap;
    public final Map<String, BuiltinEnvironment> builtinEnvironmentMap;
    private final InterpretableSimpleMathHandler interpretableSimpleMathBuilder = new InterpretableSimpleMathHandler();

    public DefinitionMap() {
        this.builtinCommandMap = new HashMap<String, BuiltinCommand>();
        this.builtinEnvironmentMap = new HashMap<String, BuiltinEnvironment>();
    }

    public BuiltinCommand getCommandByTeXName(String texName) {
        return this.builtinCommandMap.get(texName);
    }

    public BuiltinEnvironment getEnvironmentByTeXName(String texName) {
        return this.builtinEnvironmentMap.get(texName);
    }

    public static boolean isInputableTeXName(String texName) {
        return texName != null && (texName.charAt(0) != '<' || texName.length() <= 3 || !texName.endsWith(">"));
    }

    public BuiltinCommand addSimpleCommand(String name, EnumSet<LaTeXMode> allowedModes, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.SIMPLE, false, 0, allowedModes, null, null, handler, context, null));
    }

    public BuiltinCommand addSimpleCommand(String name, EnumSet<LaTeXMode> allowedModes, Interpretation interpretation, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.SIMPLE, false, 0, allowedModes, null, interpretation, handler, context, null));
    }

    public BuiltinCommand addSimpleMathCommand(String name, MathInterpretation interpretation, CommandHandler handler) {
        return this.addCommand(new BuiltinCommand(name, CommandType.SIMPLE, false, 0, Globals.MATH_MODE_ONLY, null, interpretation, handler, null, null));
    }

    public BuiltinCommand addSimpleMathCommand(String name, MathInterpretation interpretation) {
        return this.addSimpleMathCommand(name, interpretation, this.interpretableSimpleMathBuilder);
    }

    public BuiltinCommand addCombinerCommand(String name, EnumSet<LaTeXMode> allowedModes, EnumSet<InterpretationType> allowedCombinerInterpretationTypes, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.COMBINER, false, 0, allowedModes, null, null, handler, context, allowedCombinerInterpretationTypes));
    }

    public BuiltinCommand addComplexCommand(String name, boolean allowOptionalArgument, int arguments, EnumSet<LaTeXMode> allowedModes, LaTeXMode[] argumentModes, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.COMPLEX, allowOptionalArgument, arguments, allowedModes, argumentModes, null, handler, context, null));
    }

    public BuiltinCommand addComplexCommandSameArgMode(String name, boolean allowOptionalArgument, int arguments, EnumSet<LaTeXMode> allowedModes, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.COMPLEX, allowOptionalArgument, arguments, allowedModes, null, null, handler, context, null));
    }

    public BuiltinCommand addComplexCommandSameArgMode(String name, boolean allowOptionalArgument, int arguments, EnumSet<LaTeXMode> allowedModes, Interpretation interpretation, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.COMPLEX, allowOptionalArgument, arguments, allowedModes, null, interpretation, handler, context, null));
    }

    public BuiltinCommand addComplexCommandOneArg(String name, boolean allowOptionalArgument, EnumSet<LaTeXMode> allowedModes, LaTeXMode argumentMode, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.COMPLEX, allowOptionalArgument, 1, allowedModes, new LaTeXMode[]{argumentMode}, null, handler, context, null));
    }

    public BuiltinCommand addComplexCommandOneArg(String name, boolean allowOptionalArgument, EnumSet<LaTeXMode> allowedModes, LaTeXMode argumentMode, Interpretation interpretation, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.COMPLEX, allowOptionalArgument, 1, allowedModes, new LaTeXMode[]{argumentMode}, interpretation, handler, context, null));
    }

    private BuiltinCommand addCommand(BuiltinCommand command) {
        if (DefinitionMap.isInputableTeXName(command.getTeXName())) {
            this.builtinCommandMap.put(command.getTeXName(), command);
        }
        return command;
    }

    public BuiltinEnvironment addEnvironment(String name, EnumSet<LaTeXMode> allowedModes, LaTeXMode contentMode, Interpretation interpretation, EnvironmentHandler handler, TextFlowContext context) {
        return this.addEnvironment(new BuiltinEnvironment(name, false, 0, allowedModes, contentMode, interpretation, handler, context));
    }

    public BuiltinEnvironment addEnvironment(String name, boolean allowOptionalArgument, int argumentCount, EnumSet<LaTeXMode> allowedModes, LaTeXMode contentMode, Interpretation interpretation, EnvironmentHandler handler, TextFlowContext context) {
        return this.addEnvironment(new BuiltinEnvironment(name, allowOptionalArgument, argumentCount, allowedModes, contentMode, interpretation, handler, context));
    }

    private BuiltinEnvironment addEnvironment(BuiltinEnvironment environment) {
        if (DefinitionMap.isInputableTeXName(environment.getTeXName())) {
            this.builtinEnvironmentMap.put(environment.getTeXName(), environment);
        }
        return environment;
    }
}

