/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.dombuilding;

import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinEnvironment;
import uk.ac.ed.ph.snuggletex.definitions.GlobalBuiltins;
import uk.ac.ed.ph.snuggletex.dombuilding.EnvironmentHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.tokens.ArgumentContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.Token;

public final class MathEnvironmentHandler
implements EnvironmentHandler {
    public void handleEnvironment(DOMBuilder builder, Element parentElement, EnvironmentToken token) throws SnuggleParseException {
        BuiltinEnvironment environment = token.getEnvironment();
        if (builder.isBuildingMathMLIsland()) {
            Element mrow = builder.appendMathMLElement(parentElement, "mrow");
            builder.handleTokens(mrow, token.getContent(), false);
        } else {
            boolean isDisplayMath = environment == GlobalBuiltins.ENV_DISPLAYMATH;
            this.buildMathElement(builder, parentElement, token, token.getContent(), isDisplayMath);
        }
    }

    public void buildMathElement(DOMBuilder builder, Element parentElement, Token token, ArgumentContainerToken contentToken, boolean isDisplayMath) throws SnuggleParseException {
        builder.setOutputContext(isDisplayMath ? DOMBuilder.OutputContext.MATHML_BLOCK : DOMBuilder.OutputContext.MATHML_INLINE);
        Element math = builder.appendMathMLElement(parentElement, "math");
        if (isDisplayMath) {
            math.setAttribute("display", "block");
        }
        if (builder.getOptions().isAddingMathAnnotations()) {
            Element semantics = builder.appendMathMLElement(math, "semantics");
            builder.handleMathTokensAsSingleElement(semantics, contentToken);
            Element annotation = builder.appendMathMLTextElement(semantics, "annotation", ((Object)token.getSlice().extract()).toString(), true);
            annotation.setAttribute("encoding", "SnuggleTeX");
        } else {
            builder.handleTokens(math, contentToken, false);
        }
        builder.setOutputContext(DOMBuilder.OutputContext.XHTML);
    }
}

