/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.utilities;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.SnuggleRuntimeException;
import uk.ac.ed.ph.snuggletex.internal.FrozenSlice;
import uk.ac.ed.ph.snuggletex.internal.SnuggleInputReader;
import uk.ac.ed.ph.snuggletex.internal.WorkingDocument;

public final class MessageFormatter {
    public static final PropertyResourceBundle ERROR_MESSAGE_BUNDLE;
    public static final PropertyResourceBundle GENERAL_MESSAGE_BUNDLE;
    private static final int TRUNCATE_LENGTH = 20;

    public static String getErrorMessage(InputError error) {
        return MessageFormatter.getErrorMessage(error.getErrorCode().toString(), error.getArguments());
    }

    public static String getErrorMessage(String errorCode, Object[] arguments) {
        return MessageFormat.format(ERROR_MESSAGE_BUNDLE.getString(errorCode), arguments);
    }

    public static String formatErrorAsString(InputError error) {
        StringBuffer resultBuilder = new StringBuffer();
        MessageFormatter.appendErrorAsString(resultBuilder, error);
        return resultBuilder.toString();
    }

    public static Element formatErrorAsXML(Document ownerDocument, InputError error, boolean fullDetails) {
        Element result = ownerDocument.createElementNS("http://www.ph.ed.ac.uk/snuggletex", "error");
        result.setAttribute("code", error.getErrorCode().name());
        if (fullDetails) {
            StringBuffer messageBuilder = new StringBuffer(MessageFormatter.getErrorMessage(error));
            FrozenSlice errorSlice = error.getSlice();
            if (errorSlice != null) {
                MessageFormatter.appendSliceContext(messageBuilder, errorSlice);
            }
            result.appendChild(ownerDocument.createTextNode(messageBuilder.toString()));
        }
        return result;
    }

    public static Element formatErrorAsXHTML(Document ownerDocument, InputError error) {
        Element result = ownerDocument.createElementNS("http://www.w3.org/1999/xhtml", "div");
        result.setAttribute("class", "error");
        Element heading = ownerDocument.createElementNS("http://www.w3.org/1999/xhtml", "h2");
        heading.appendChild(ownerDocument.createTextNode("SnuggleTeX Error (" + (Object)((Object)error.getErrorCode()) + ")"));
        Element pre = ownerDocument.createElementNS("http://www.w3.org/1999/xhtml", "pre");
        StringBuffer messageBuilder = new StringBuffer(MessageFormatter.getErrorMessage(error));
        FrozenSlice errorSlice = error.getSlice();
        if (errorSlice != null) {
            MessageFormatter.appendSliceContext(messageBuilder, errorSlice);
        }
        pre.appendChild(ownerDocument.createTextNode(messageBuilder.toString()));
        result.appendChild(heading);
        result.appendChild(pre);
        return result;
    }

    public static void appendErrorAsString(StringBuffer messageBuilder, InputError error) {
        new MessageFormat(GENERAL_MESSAGE_BUNDLE.getString("error_as_string")).format(new Object[]{error.getErrorCode().toString(), MessageFormatter.getErrorMessage(error)}, messageBuilder, (FieldPosition)null);
        FrozenSlice errorSlice = error.getSlice();
        if (errorSlice != null) {
            MessageFormatter.appendSliceContext(messageBuilder, errorSlice);
        }
    }

    private static void appendNewlineIfRequired(StringBuffer messageBuilder) {
        if (messageBuilder.length() > 0) {
            messageBuilder.append('\n');
        }
    }

    public static void appendSliceContext(StringBuffer messageBuilder, FrozenSlice slice) {
        WorkingDocument document = slice.getDocument();
        WorkingDocument.IndexResolution errorResolution = document.resolveIndex(slice.startIndex, false);
        if (errorResolution == null) {
            errorResolution = document.resolveIndex(slice.startIndex, true);
        }
        if (errorResolution == null) {
            throw new SnuggleLogicException("Could not resolve component containing error slice starting at " + slice.startIndex);
        }
        WorkingDocument.Slice errorSlice = errorResolution.slice;
        WorkingDocument.CharacterSource errorComponent = errorSlice.resolvedComponent;
        int errorIndex = errorResolution.indexInComponent;
        MessageFormatter.appendFrame(messageBuilder, errorComponent, errorIndex);
    }

    private static void appendFrame(StringBuffer messageBuilder, WorkingDocument.CharacterSource source, int offsetInSource) {
        WorkingDocument.SourceContext context = source.context;
        if (context instanceof SnuggleInputReader) {
            SnuggleInputReader inputContext = (SnuggleInputReader)context;
            int[] location = inputContext.getLineAndColumn(offsetInSource);
            MessageFormatter.appendNewlineIfRequired(messageBuilder);
            new MessageFormat(GENERAL_MESSAGE_BUNDLE.getString("input_context")).format(new Object[]{location[0], location[1], inputContext.getInput().getIdentifier()}, messageBuilder, (FieldPosition)null);
        } else if (context instanceof WorkingDocument.SubstitutionContext) {
            WorkingDocument.SubstitutionContext substitutionContext = (WorkingDocument.SubstitutionContext)context;
            MessageFormatter.appendNewlineIfRequired(messageBuilder);
            new MessageFormat(GENERAL_MESSAGE_BUNDLE.getString("subs_context")).format(new Object[]{offsetInSource, MessageFormatter.formatText(source.substitutedText), MessageFormatter.formatText(substitutionContext.replacement)}, messageBuilder, (FieldPosition)null);
        } else {
            throw new SnuggleLogicException("Unexpected SourceContext " + context.getClass().getName());
        }
        if (source.substitutedSource != null) {
            MessageFormatter.appendFrame(messageBuilder, source.substitutedSource, source.substitutionOffset);
        }
    }

    private static String formatText(CharSequence content) {
        String result = ((Object)content).toString().replaceAll("\\s", " ");
        if (result.length() > 20) {
            result = result.substring(0, 20) + "...";
        }
        return result;
    }

    static {
        try {
            ERROR_MESSAGE_BUNDLE = (PropertyResourceBundle)ResourceBundle.getBundle("uk/ac/ed/ph/snuggletex/error-messages");
            GENERAL_MESSAGE_BUNDLE = (PropertyResourceBundle)ResourceBundle.getBundle("uk/ac/ed/ph/snuggletex/general-messages");
        }
        catch (MissingResourceException e) {
            throw new SnuggleRuntimeException(e);
        }
    }
}

