/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.utilities;

import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import uk.ac.ed.ph.snuggletex.internal.util.XMLUtilities;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetCache;

public final class StylesheetManager {
    private StylesheetCache stylesheetCache;

    public StylesheetManager() {
        this(null);
    }

    public StylesheetManager(StylesheetCache cache) {
        this.stylesheetCache = cache;
    }

    public StylesheetCache getStylesheetCache() {
        return this.stylesheetCache;
    }

    public void setStylesheetCache(StylesheetCache stylesheetCache) {
        this.stylesheetCache = stylesheetCache;
    }

    public Templates getStylesheet(String classPathUri) {
        return this.getStylesheet(classPathUri, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Templates getStylesheet(String classPathUri, boolean requireXSLT20) {
        Templates result;
        if (this.stylesheetCache == null) {
            result = this.compileStylesheet(classPathUri, requireXSLT20);
        } else {
            StylesheetCache stylesheetCache = this.stylesheetCache;
            synchronized (stylesheetCache) {
                result = this.stylesheetCache.getStylesheet(classPathUri);
                if (result == null) {
                    result = this.compileStylesheet(classPathUri, requireXSLT20);
                    this.stylesheetCache.putStylesheet(classPathUri, result);
                }
            }
        }
        return result;
    }

    private Templates compileStylesheet(String classPathUri, boolean requireXSLT20) {
        TransformerFactory transformerFactory = requireXSLT20 ? XMLUtilities.createSaxonTransformerFactory() : XMLUtilities.createJAXPTransformerFactory();
        return XMLUtilities.compileInternalStylesheet(transformerFactory, classPathUri);
    }
}

