/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.database.ReflectionUtil");

    public static final void setValue(Object bean, Field field, Object value) throws Exception {
        Class<?> clazz = bean.getClass();
        Method method = ReflectionUtil.getMethod("set", field, clazz);
        if (method != null) {
            method.invoke(bean, value);
        }
        if ((method = ReflectionUtil.getMethod("put", field, clazz)) != null) {
            method.invoke(bean, value);
        }
        field.setAccessible(true);
        field.set(bean, value);
    }

    public static final Object getValue(Object bean, Field field) throws Exception {
        Class<?> clazz = bean.getClass();
        Method method = ReflectionUtil.getMethod("get", field, clazz);
        if (method != null) {
            return method.invoke(bean, new Object[0]);
        }
        method = ReflectionUtil.getMethod("is", field, clazz);
        if (method != null) {
            return method.invoke(bean, new Object[0]);
        }
        field.setAccessible(true);
        return field.get(bean);
    }

    public static final Method getMethod(String prefix, Field field, Class<? extends Object> clazz) throws Exception {
        StringBuilder name = new StringBuilder(field.getName());
        name.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        name.insert(0, prefix);
        try {
            Method method = clazz.getDeclaredMethod(name.toString(), new Class[0]);
            return method;
        }
        catch (Exception e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
            return null;
        }
    }

    public static final List<Method> getMethod(Class<?> clazz, String name) throws Exception {
        Method[] methods = clazz.getDeclaredMethods();
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods) {
            if (!method.getName().equals(name)) continue;
            list.add(method);
        }
        return list;
    }
}

