/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.config.Attribute;
import org.jboss.security.config.BaseSecurityInfo;
import org.jboss.security.config.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationInfo
extends BaseSecurityInfo<AuthorizationModuleEntry> {
    public AuthorizationInfo(String name) {
        super(name);
    }

    public AuthorizationModuleEntry[] getAuthorizationModuleEntry() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONFIG_ENTRY_PERM);
        }
        AuthorizationModuleEntry[] entries = new AuthorizationModuleEntry[this.moduleEntries.size()];
        this.moduleEntries.toArray(entries);
        return entries;
    }

    @Override
    protected BaseSecurityInfo<AuthorizationModuleEntry> create(String name) {
        return new AuthorizationInfo(name);
    }

    public void writeContent(XMLStreamWriter writer) throws XMLStreamException {
        for (int i = 0; i < this.moduleEntries.size(); ++i) {
            AuthorizationModuleEntry entry = (AuthorizationModuleEntry)this.moduleEntries.get(i);
            writer.writeStartElement(Element.POLICY_MODULE.getLocalName());
            writer.writeAttribute(Attribute.CODE.getLocalName(), entry.getPolicyModuleName());
            writer.writeAttribute(Attribute.FLAG.getLocalName(), entry.getControlFlag().toString().toLowerCase());
            Map<String, Object> options = entry.getOptions();
            if (options != null && options.size() > 0) {
                for (Map.Entry<String, Object> option : options.entrySet()) {
                    writer.writeStartElement(Element.MODULE_OPTION.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), option.getKey());
                    writer.writeAttribute(Attribute.VALUE.getLocalName(), option.getValue().toString());
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

