/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache;

import java.io.File;
import java.io.Serializable;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.transaction.TransactionManager;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedNodeData;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.dataflow.persistent.WorkspaceStorageCache;
import org.exoplatform.services.jcr.dataflow.persistent.WorkspaceStorageCacheListener;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.NullItemData;
import org.exoplatform.services.jcr.datamodel.NullNodeData;
import org.exoplatform.services.jcr.datamodel.NullPropertyData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.DataRestoreContext;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache.BufferedJBossCache;
import org.exoplatform.services.jcr.jbosscache.ExoJBossCacheFactory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.transaction.ActionNonTxAware;
import org.exoplatform.services.transaction.TransactionService;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.Node;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.ExpirationAlgorithmConfig;
import org.jboss.cache.eviction.FIFOAlgorithmConfig;
import org.jboss.cache.jmx.JmxRegistrationManager;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheWorkspaceStorageCache
implements WorkspaceStorageCache,
Startable,
Backupable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JBossCacheWorkspaceStorageCache");
    private final boolean enabled;
    private final boolean shareable;
    public static final String JBOSSCACHE_CONFIG = "jbosscache-configuration";
    public static final String JBOSSCACHE_EXPIRATION = "jbosscache-expiration-time";
    public static final String JBOSSCACHE_SHAREABLE = "jbosscache-shareable";
    public static final Boolean JBOSSCACHE_SHAREABLE_DEFAULT = Boolean.FALSE;
    public static final long JBOSSCACHE_EXPIRATION_DEFAULT = 900000L;
    public static final String ITEMS = "$ITEMS".intern();
    public static final String NULL_ITEMS = "$NULL_ITEMS".intern();
    public static final String CHILD_NODES = "$CHILD_NODES".intern();
    public static final String CHILD_PROPS = "$CHILD_PROPS".intern();
    public static final String CHILD_NODES_LIST = "$CHILD_NODES_LIST".intern();
    public static final String CHILD_PROPS_LIST = "$CHILD_PROPS_LIST".intern();
    public static final String CHILD_PROPS_BY_PATTERN_LIST = "$CHILD_PROPS_BY_PATTERN_LIST".intern();
    public static final String CHILD_NODES_BY_PATTERN_LIST = "$CHILD_NODES_BY_PATTERN_LIST".intern();
    public static final String CHILD_NODES_BY_PAGE_LIST = "$CHILD_NODES_BY_PAGE_LIST".intern();
    public static final String LOCKS = "$LOCKS".intern();
    public static final String REFERENCE = "$REFERENCE".intern();
    public static final String ITEM_DATA = "$data".intern();
    public static final String ITEM_ID = "$id".intern();
    public static final String ITEM_LIST = "$lists".intern();
    public static final String PATTERN_OBJ = "$pattern".intern();
    protected final BufferedJBossCache cache;
    protected final Fqn<String> itemsRoot;
    protected final Fqn<String> refRoot;
    protected final Fqn<String> childNodes;
    protected final Fqn<String> childProps;
    protected final Fqn<String> childNodesList;
    protected final Fqn<String> childPropsList;
    protected final Fqn<String> childNodesByPageList;
    protected final Fqn<String> childPropsByPatternList;
    protected final Fqn<String> childNodesByPatternList;
    protected final Fqn<String> rootFqn;
    private final CacheActionNonTxAware<Void, Void> commitTransaction = new CacheActionNonTxAware<Void, Void>(){

        @Override
        protected Void execute(Void arg) throws RuntimeException {
            JBossCacheWorkspaceStorageCache.this.cache.commitTransaction();
            return null;
        }
    };
    private final CacheActionNonTxAware<ItemData, String> getFromCacheById = new CacheActionNonTxAware<ItemData, String>(){

        @Override
        protected ItemData execute(String id) throws RuntimeException {
            return JBossCacheWorkspaceStorageCache.this.getFromCacheById(id);
        }
    };
    private final CacheActionNonTxAware<ItemData, String> getFromBufferedCacheById = new CacheActionNonTxAware<ItemData, String>(){

        @Override
        protected ItemData execute(String id) throws RuntimeException {
            return JBossCacheWorkspaceStorageCache.this.getFromBufferedCacheById(id);
        }
    };
    private final CacheActionNonTxAware<List<NodeData>, NodeData> getChildNodes = new CacheActionNonTxAware<List<NodeData>, NodeData>(){

        @Override
        protected List<NodeData> execute(NodeData parent) throws RuntimeException {
            Set set = (Set)JBossCacheWorkspaceStorageCache.this.cache.get(JBossCacheWorkspaceStorageCache.this.makeChildListFqn(JBossCacheWorkspaceStorageCache.this.childNodesList, parent.getIdentifier()), (Serializable)((Object)ITEM_LIST));
            if (set != null) {
                if (set instanceof FakeValueSet) {
                    return null;
                }
                ArrayList<NodeData> childs = new ArrayList<NodeData>();
                for (String child : set) {
                    NodeData node = (NodeData)JBossCacheWorkspaceStorageCache.this.cache.get(JBossCacheWorkspaceStorageCache.this.makeItemFqn(child), (Serializable)((Object)ITEM_DATA));
                    if (node == null) {
                        return null;
                    }
                    childs.add(node);
                }
                Collections.sort(childs, new NodesOrderComparator());
                return childs;
            }
            return null;
        }
    };
    private final CacheActionNonTxAware<ItemData, Object> getFromCacheByPath = new CacheActionNonTxAware<ItemData, Object>(){

        @Override
        protected ItemData execute(Object ... args) throws RuntimeException {
            String parentId = (String)args[0];
            QPathEntry name = (QPathEntry)args[1];
            ItemType itemType = (ItemType)((Object)args[2]);
            String itemId = null;
            if (itemType == ItemType.UNKNOWN) {
                String propId;
                itemId = (String)JBossCacheWorkspaceStorageCache.this.cache.get(JBossCacheWorkspaceStorageCache.this.makeChildFqn(JBossCacheWorkspaceStorageCache.this.childNodes, parentId, name), (Serializable)((Object)ITEM_ID));
                if ((itemId == null || itemId.equals("_null_id")) && (propId = (String)JBossCacheWorkspaceStorageCache.this.cache.get(JBossCacheWorkspaceStorageCache.this.makeChildFqn(JBossCacheWorkspaceStorageCache.this.childProps, parentId, name), (Serializable)((Object)ITEM_ID))) != null) {
                    itemId = propId;
                }
            } else {
                itemId = itemType == ItemType.NODE ? (String)JBossCacheWorkspaceStorageCache.this.cache.get(JBossCacheWorkspaceStorageCache.this.makeChildFqn(JBossCacheWorkspaceStorageCache.this.childNodes, parentId, name), (Serializable)((Object)ITEM_ID)) : (String)JBossCacheWorkspaceStorageCache.this.cache.get(JBossCacheWorkspaceStorageCache.this.makeChildFqn(JBossCacheWorkspaceStorageCache.this.childProps, parentId, name), (Serializable)((Object)ITEM_ID));
            }
            if (itemId != null) {
                if (itemId.equals("_null_id")) {
                    if (itemType == ItemType.UNKNOWN || itemType == ItemType.NODE) {
                        return new NullNodeData();
                    }
                    return new NullPropertyData();
                }
                return JBossCacheWorkspaceStorageCache.this.get(itemId);
            }
            return null;
        }
    };
    private final CacheActionNonTxAware<Integer, NodeData> getChildNodesCount = new CacheActionNonTxAware<Integer, NodeData>(){

        @Override
        protected Integer execute(NodeData parent) throws RuntimeException {
            Set set = (Set)JBossCacheWorkspaceStorageCache.this.cache.get(JBossCacheWorkspaceStorageCache.this.makeChildListFqn(JBossCacheWorkspaceStorageCache.this.childNodesList, parent.getIdentifier()), (Serializable)((Object)ITEM_LIST));
            return set != null ? set.size() : -1;
        }
    };
    private final CacheActionNonTxAware<List<PropertyData>, Object> getChildProps = new CacheActionNonTxAware<List<PropertyData>, Object>(){

        @Override
        protected List<PropertyData> execute(Object ... args) throws RuntimeException {
            String parentId = (String)args[0];
            boolean withValue = (Boolean)args[1];
            Set set = (Set)JBossCacheWorkspaceStorageCache.this.cache.get(JBossCacheWorkspaceStorageCache.this.makeChildListFqn(JBossCacheWorkspaceStorageCache.this.childPropsList, parentId), (Serializable)((Object)ITEM_LIST));
            if (set != null) {
                ArrayList<PropertyData> childs = new ArrayList<PropertyData>();
                for (Object child : set) {
                    PropertyData prop = (PropertyData)JBossCacheWorkspaceStorageCache.this.cache.get(JBossCacheWorkspaceStorageCache.this.makeItemFqn((String)child), (Serializable)((Object)ITEM_DATA));
                    if (prop == null || prop instanceof NullItemData) {
                        return null;
                    }
                    if (withValue && prop.getValues().size() <= 0) {
                        return null;
                    }
                    childs.add(prop);
                }
                return childs;
            }
            return null;
        }
    };
    private final CacheActionNonTxAware<List<PropertyData>, String> getReferencedProperties = new CacheActionNonTxAware<List<PropertyData>, String>(){

        @Override
        protected List<PropertyData> execute(String identifier) throws RuntimeException {
            Set set = (Set)JBossCacheWorkspaceStorageCache.this.cache.get(JBossCacheWorkspaceStorageCache.this.makeRefFqn(identifier), (Serializable)((Object)ITEM_LIST));
            if (set != null) {
                ArrayList<PropertyData> props = new ArrayList<PropertyData>();
                for (String propId : set) {
                    PropertyData prop = (PropertyData)JBossCacheWorkspaceStorageCache.this.cache.get(JBossCacheWorkspaceStorageCache.this.makeItemFqn(propId), (Serializable)((Object)ITEM_DATA));
                    if (prop == null || prop instanceof NullItemData) {
                        return null;
                    }
                    List<ValueData> lData = prop.getValues();
                    int length = lData.size();
                    for (int i = 0; i < length; ++i) {
                        ValueData vdata = lData.get(i);
                        try {
                            if (!ValueDataUtil.getString(vdata).equals(identifier)) continue;
                            props.add(prop);
                            continue;
                        }
                        catch (IllegalStateException e) {
                            if (!LOG.isTraceEnabled()) continue;
                            LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                            continue;
                        }
                        catch (RepositoryException e) {
                            if (!LOG.isTraceEnabled()) continue;
                            LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                        }
                    }
                }
                return props;
            }
            return null;
        }
    };
    private final CacheActionNonTxAware<Long, Void> getSize = new CacheActionNonTxAware<Long, Void>(){

        @Override
        protected Long execute(Void arg) throws RuntimeException {
            DataContainer container = (DataContainer)JBossCacheWorkspaceStorageCache.this.cache.getComponentRegistry().getComponent(DataContainer.class);
            return JBossCacheWorkspaceStorageCache.numNodes((InternalNode<Serializable, Object>)container.peekInternalNode(JBossCacheWorkspaceStorageCache.this.rootFqn, false));
        }
    };
    protected volatile boolean initialized;
    private JmxRegistrationManager jmxManager;

    public JBossCacheWorkspaceStorageCache(ExoContainerContext ctx, WorkspaceEntry wsConfig, TransactionService transactionService, ConfigurationManager cfm) throws RepositoryException, RepositoryConfigurationException {
        if (wsConfig.getCache() == null) {
            throw new RepositoryConfigurationException("Cache configuration not found");
        }
        this.enabled = wsConfig.getCache().isEnabled();
        this.shareable = wsConfig.getCache().getParameterBoolean(JBOSSCACHE_SHAREABLE, JBOSSCACHE_SHAREABLE_DEFAULT);
        ExoJBossCacheFactory factory = transactionService != null ? new ExoJBossCacheFactory(cfm, transactionService.getTransactionManager()) : new ExoJBossCacheFactory(cfm);
        Cache parentCache = factory.createCache(wsConfig.getCache());
        List evictionConfigurations = parentCache.getConfiguration().getEvictionConfig().getEvictionRegionConfigs();
        evictionConfigurations.add(parentCache.getConfiguration().getEvictionConfig().getDefaultEvictionRegionConfig());
        boolean useExpiration = false;
        for (EvictionRegionConfig evictionRegionConfig : evictionConfigurations) {
            FIFOAlgorithmConfig fifoConfig;
            EvictionAlgorithmConfig config = evictionRegionConfig.getEvictionAlgorithmConfig();
            if (config instanceof ExpirationAlgorithmConfig) {
                ((ExpirationAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).setExpirationKeyName("expiration");
                useExpiration = true;
                continue;
            }
            if (!(config instanceof FIFOAlgorithmConfig) || (fifoConfig = (FIFOAlgorithmConfig)config).getMinTimeToLive() <= 0L) continue;
            LOG.warn((Object)"The FIFO algorithm with a minTimeToLive greater than 0 can cause a memory leak, please use another eviction algorithm or set the minTimeToLive to 0.");
        }
        if (useExpiration) {
            LOG.info((Object)"Using BufferedJBossCache compatible with Expiration algorithm.");
        }
        this.rootFqn = Fqn.fromElements((Object[])new String[]{wsConfig.getUniqueName()});
        parentCache = ExoJBossCacheFactory.getUniqueInstance(ExoJBossCacheFactory.CacheType.JCR_CACHE, this.rootFqn, parentCache, wsConfig.getCache().getParameterBoolean(JBOSSCACHE_SHAREABLE, JBOSSCACHE_SHAREABLE_DEFAULT));
        if (ctx != null) {
            this.jmxManager = ExoJBossCacheFactory.getJmxRegistrationManager(ctx, parentCache, ExoJBossCacheFactory.CacheType.JCR_CACHE);
        }
        this.cache = new BufferedJBossCache(parentCache, useExpiration, wsConfig.getCache().getParameterTime(JBOSSCACHE_EXPIRATION, 900000L));
        this.itemsRoot = Fqn.fromRelativeElements(this.rootFqn, (Object[])new String[]{ITEMS});
        this.refRoot = Fqn.fromRelativeElements(this.rootFqn, (Object[])new String[]{REFERENCE});
        this.childNodes = Fqn.fromRelativeElements(this.rootFqn, (Object[])new String[]{CHILD_NODES});
        this.childProps = Fqn.fromRelativeElements(this.rootFqn, (Object[])new String[]{CHILD_PROPS});
        this.childNodesList = Fqn.fromRelativeElements(this.rootFqn, (Object[])new String[]{CHILD_NODES_LIST});
        this.childPropsList = Fqn.fromRelativeElements(this.rootFqn, (Object[])new String[]{CHILD_PROPS_LIST});
        this.childNodesByPageList = Fqn.fromRelativeElements(this.rootFqn, (Object[])new String[]{CHILD_NODES_BY_PAGE_LIST});
        this.childPropsByPatternList = Fqn.fromRelativeElements(this.rootFqn, (Object[])new String[]{CHILD_PROPS_BY_PATTERN_LIST});
        this.childNodesByPatternList = Fqn.fromRelativeElements(this.rootFqn, (Object[])new String[]{CHILD_NODES_BY_PATTERN_LIST});
        if (this.cache.getConfiguration().getCacheMode() == Configuration.CacheMode.LOCAL) {
            this.init();
        }
    }

    public JBossCacheWorkspaceStorageCache(WorkspaceEntry wsConfig, TransactionService transactionService, ConfigurationManager cfm) throws RepositoryException, RepositoryConfigurationException {
        this(null, wsConfig, transactionService, cfm);
    }

    public JBossCacheWorkspaceStorageCache(ExoContainerContext ctx, WorkspaceEntry wsConfig, ConfigurationManager cfm) throws RepositoryException, RepositoryConfigurationException {
        this(ctx, wsConfig, null, cfm);
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.cache.create();
        this.cache.start();
        this.createResidentNode(this.childNodes);
        this.createResidentNode(this.refRoot);
        this.createResidentNode(this.childNodesList);
        this.createResidentNode(this.childProps);
        this.createResidentNode(this.childPropsList);
        this.createResidentNode(this.childNodesByPageList);
        this.createResidentNode(this.childPropsByPatternList);
        this.createResidentNode(this.childNodesByPatternList);
        this.createResidentNode(this.itemsRoot);
        if (this.jmxManager != null) {
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    JBossCacheWorkspaceStorageCache.this.jmxManager.registerAllMBeans();
                    return null;
                }
            });
        }
        this.initialized = true;
    }

    public void start() {
        this.init();
    }

    public void stop() {
        if (this.jmxManager != null) {
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    JBossCacheWorkspaceStorageCache.this.jmxManager.unregisterAllMBeans();
                    return null;
                }
            });
        }
        if (this.shareable) {
            this.cache.getNode(this.itemsRoot).setResident(false);
            this.cache.evict(this.itemsRoot, true);
            this.cache.getRegion(this.itemsRoot, false).processEvictionQueues();
            this.cache.getNode(this.refRoot).setResident(false);
            this.cache.evict(this.refRoot, true);
            this.cache.getRegion(this.refRoot, false).processEvictionQueues();
            this.cache.getNode(this.childNodes).setResident(false);
            this.cache.evict(this.childNodes, true);
            this.cache.getRegion(this.childNodes, false).processEvictionQueues();
            this.cache.getNode(this.childProps).setResident(false);
            this.cache.evict(this.childProps, true);
            this.cache.getRegion(this.childProps, false).processEvictionQueues();
            this.cache.getNode(this.childNodesList).setResident(false);
            this.cache.evict(this.childNodesList, true);
            this.cache.getRegion(this.childNodesList, false).processEvictionQueues();
            this.cache.getNode(this.childPropsList).setResident(false);
            this.cache.evict(this.childPropsList, true);
            this.cache.getRegion(this.childPropsList, false).processEvictionQueues();
            this.cache.getNode(this.childNodesByPageList).setResident(false);
            this.cache.evict(this.childNodesByPageList, true);
            this.cache.getRegion(this.childNodesByPageList, false).processEvictionQueues();
            this.cache.getNode(this.childNodesByPatternList).setResident(false);
            this.cache.evict(this.childNodesByPatternList, true);
            this.cache.getRegion(this.childNodesByPatternList, false).processEvictionQueues();
            this.cache.getNode(this.childPropsByPatternList).setResident(false);
            this.cache.evict(this.childPropsByPatternList, true);
            this.cache.getRegion(this.childPropsByPatternList, false).processEvictionQueues();
        }
        this.cache.stop();
    }

    protected void createResidentNode(Fqn fqn) {
        Node<Serializable, Object> cacheRoot = this.cache.getRoot();
        if (!cacheRoot.hasChild(fqn)) {
            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            cacheRoot.addChild(fqn).setResident(true);
        } else {
            this.cache.getNode(fqn).setResident(true);
        }
    }

    protected static String readJBCConfig(WorkspaceEntry wsConfig) throws RepositoryConfigurationException {
        if (wsConfig.getCache() != null) {
            return wsConfig.getCache().getParameterValue(JBOSSCACHE_CONFIG);
        }
        throw new RepositoryConfigurationException("Cache configuration not found");
    }

    public TransactionManager getTransactionManager() {
        return this.cache.getTransactionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(ItemData item) {
        if (item instanceof NullItemData) {
            this.putNullItem((NullItemData)item);
            return;
        }
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            if (item.isNode()) {
                this.putNode((NodeData)item, ModifyChildOption.NOT_MODIFY);
            } else {
                this.putProperty((PropertyData)item, ModifyChildOption.NOT_MODIFY);
            }
            Object var4_3 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    @Override
    public void remove(ItemData item) {
        this.removeItem(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String identifier, ItemData item) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            this.cache.remove(this.makeItemFqn(identifier), (Serializable)((Object)ITEM_DATA), item);
            Object var5_4 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSaveItems(ItemStateChangesLog itemStates) {
        boolean rollback = true;
        try {
            ItemState lastDelete = null;
            this.cache.beginTransaction();
            Set<String> idsToSkip = null;
            List<ItemState> states = itemStates.getAllStates();
            int length = states.size();
            for (int i = 0; i < length; ++i) {
                ItemState state = states.get(i);
                if (state.isAdded()) {
                    if (state.isPersisted()) {
                        this.putItem(state.getData());
                    }
                } else if (state.isUpdated()) {
                    if (state.isPersisted()) {
                        ItemData prevItem = this.putItemInBufferedCache(state.getData());
                        if (state.isNode() && (prevItem != null || state.getOldPath() != null)) {
                            ItemState nextState;
                            idsToSkip = this.updateInBuffer((NodeData)state.getData(), prevItem != null ? prevItem.getQPath() : state.getOldPath(), idsToSkip);
                            if (!(i + 1 >= length || (nextState = states.get(i + 1)).isUpdated() && nextState.isNode() && nextState.isPersisted())) {
                                idsToSkip = null;
                            }
                        }
                    }
                } else if (state.isDeleted()) {
                    if (state.isPersisted()) {
                        this.removeItem(state.getData());
                    }
                } else if (state.isRenamed()) {
                    this.renameItem(state, lastDelete);
                } else if (state.isPathChanged()) {
                    this.updateTreePath(state.getOldPath(), state.getData().getQPath(), (Set<String>)null);
                } else if (state.isMixinChanged() && state.isPersisted()) {
                    this.updateMixin((NodeData)state.getData());
                }
                if (!state.isDeleted()) continue;
                lastDelete = state;
            }
            this.cache.commitTransaction();
            rollback = false;
            Object var12_11 = null;
            if (rollback) {
                this.cache.rollbackTransaction();
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (rollback) {
                this.cache.rollbackTransaction();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildNodes(NodeData parent, List<NodeData> childs) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            HashSet<String> set = new HashSet<String>();
            for (NodeData child : childs) {
                this.putNode(child, ModifyChildOption.NOT_MODIFY);
                set.add(child.getIdentifier());
            }
            this.cache.putIfAbsent(this.makeChildListFqn(this.childNodesList, parent.getIdentifier()), (Serializable)((Object)ITEM_LIST), set);
            Object var8_7 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildNodesByPage(NodeData parent, List<NodeData> childs, int fromOrderNum) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            Fqn<String> fqn = this.makeChildListFqn(this.childNodesByPageList, parent.getIdentifier());
            HashMap pages = (HashMap)this.cache.get(fqn, (Serializable)((Object)ITEM_LIST));
            if (pages == null) {
                pages = new HashMap();
            }
            HashSet<String> set = new HashSet<String>();
            for (NodeData child : childs) {
                this.putNode(child, ModifyChildOption.NOT_MODIFY);
                set.add(child.getIdentifier());
            }
            pages.put(fromOrderNum, set);
            this.cache.putOnly(fqn, (Serializable)((Object)ITEM_LIST), pages);
            Object var11_10 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildNodes(NodeData parent, QPathEntryFilter pattern, List<NodeData> childs) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            Fqn<String> fqn = this.makeChildFqn(this.childNodesByPatternList, parent.getIdentifier(), pattern.getQPathEntry());
            HashSet<String> set = new HashSet<String>();
            for (NodeData child : childs) {
                this.putNode(child, ModifyChildOption.NOT_MODIFY);
                set.add(child.getIdentifier());
            }
            if (childs.size() > 0) {
                this.cache.putIfAbsent(fqn, (Serializable)((Object)PATTERN_OBJ), pattern);
            }
            this.cache.putIfAbsent(fqn, (Serializable)((Object)ITEM_LIST), set);
            Object var10_9 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildProperties(NodeData parent, List<PropertyData> childs) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            if (childs.size() > 0) {
                HashSet<String> set = new HashSet<String>();
                for (PropertyData child : childs) {
                    this.putProperty(child, ModifyChildOption.NOT_MODIFY);
                    set.add(child.getIdentifier());
                }
                this.cache.putIfAbsent(this.makeChildListFqn(this.childPropsList, parent.getIdentifier()), (Serializable)((Object)ITEM_LIST), set);
            } else {
                LOG.warn((Object)("Empty properties list cached " + (parent != null ? parent.getQPath().getAsString() : parent)));
            }
            Object var8_7 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildProperties(NodeData parent, QPathEntryFilter pattern, List<PropertyData> childProperties) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            if (childProperties.size() > 0) {
                HashSet<String> set = new HashSet<String>();
                for (PropertyData child : childProperties) {
                    this.putProperty(child, ModifyChildOption.NOT_MODIFY);
                    set.add(child.getIdentifier());
                }
                Fqn<String> fqn = this.makeChildFqn(this.childPropsByPatternList, parent.getIdentifier(), pattern.getQPathEntry());
                this.cache.putIfAbsent(fqn, (Serializable)((Object)PATTERN_OBJ), pattern);
                this.cache.putIfAbsent(fqn, (Serializable)((Object)ITEM_LIST), set);
            }
            Object var9_8 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    @Override
    public void addChildPropertiesList(NodeData parent, List<PropertyData> childProperties) {
    }

    @Override
    public ItemData get(String parentId, QPathEntry name, ItemType itemType) {
        return (ItemData)this.getFromCacheByPath.run(new Object[]{parentId, name, itemType});
    }

    @Override
    public ItemData get(String id) {
        return (ItemData)this.getFromCacheById.run(id);
    }

    @Override
    public List<NodeData> getChildNodes(NodeData parent) {
        return (List)this.getChildNodes.run(parent);
    }

    @Override
    public List<NodeData> getChildNodesByPage(NodeData parent, int fromOrderNum) {
        Map pages = (Map)this.cache.get(this.makeChildListFqn(this.childNodesByPageList, parent.getIdentifier()), (Serializable)((Object)ITEM_LIST));
        if (pages == null) {
            return null;
        }
        Set set = (Set)pages.get(fromOrderNum);
        if (set == null) {
            return null;
        }
        ArrayList<NodeData> childs = new ArrayList<NodeData>();
        for (String child : set) {
            NodeData node = (NodeData)this.cache.get(this.makeItemFqn(child), (Serializable)((Object)ITEM_DATA));
            if (node == null) {
                return null;
            }
            childs.add(node);
        }
        Collections.sort(childs, new NodesOrderComparator());
        return childs;
    }

    @Override
    public List<NodeData> getChildNodes(NodeData parent, QPathEntryFilter pattern) {
        Set set = (Set)this.cache.get(this.makeChildFqn(this.childNodesByPatternList, parent.getIdentifier(), pattern.getQPathEntry()), (Serializable)((Object)ITEM_LIST));
        if (set != null) {
            ArrayList<NodeData> childs = new ArrayList<NodeData>();
            for (Object child : set) {
                NodeData node = (NodeData)this.cache.get(this.makeItemFqn((String)child), (Serializable)((Object)ITEM_DATA));
                if (node == null) {
                    return null;
                }
                childs.add(node);
            }
            Collections.sort(childs, new NodesOrderComparator());
            return childs;
        }
        return null;
    }

    @Override
    public int getChildNodesCount(NodeData parent) {
        return (Integer)this.getChildNodesCount.run(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildNodesCount(NodeData parent, int count) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            this.cache.putIfAbsent(this.makeChildListFqn(this.childNodesList, parent.getIdentifier()), (Serializable)((Object)ITEM_LIST), new FakeValueSet(count));
            Object var5_4 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    @Override
    public List<PropertyData> getChildProperties(NodeData parent) {
        return this.getChildProps(parent.getIdentifier(), true);
    }

    @Override
    public List<PropertyData> getChildProperties(NodeData parent, QPathEntryFilter pattern) {
        Set set = (Set)this.cache.get(this.makeChildFqn(this.childPropsByPatternList, parent.getIdentifier(), pattern.getQPathEntry()), (Serializable)((Object)ITEM_LIST));
        if (set != null) {
            ArrayList<PropertyData> childs = new ArrayList<PropertyData>();
            for (Object child : set) {
                PropertyData prop = (PropertyData)this.cache.get(this.makeItemFqn((String)child), (Serializable)((Object)ITEM_DATA));
                if (prop == null || prop instanceof NullItemData) {
                    return null;
                }
                if (prop.getValues().size() <= 0) {
                    return null;
                }
                childs.add(prop);
            }
            return childs;
        }
        return null;
    }

    @Override
    public List<PropertyData> listChildProperties(NodeData parent) {
        return this.getChildProps(parent.getIdentifier(), false);
    }

    @Override
    public List<PropertyData> getReferencedProperties(String identifier) {
        return (List)this.getReferencedProperties.run(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReferencedProperties(String identifier, List<PropertyData> refProperties) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            HashSet<String> set = new HashSet<String>();
            for (PropertyData prop : refProperties) {
                this.putProperty(prop, ModifyChildOption.NOT_MODIFY);
                set.add(prop.getIdentifier());
            }
            this.cache.putIfAbsent(this.makeRefFqn(identifier), (Serializable)((Object)ITEM_LIST), set);
            Object var8_7 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    protected List<PropertyData> getChildProps(String parentId, boolean withValue) {
        return (List)this.getChildProps.run(parentId, withValue);
    }

    @Override
    public long getSize() {
        return (Long)this.getSize.run();
    }

    private static long numNodes(InternalNode<Serializable, Object> n) {
        long count = 0L;
        if (n != null) {
            Set children = n.getChildren();
            if (children.isEmpty()) {
                Fqn fqn = n.getFqn();
                int size = fqn.size();
                if (size < 3) {
                    return 0L;
                }
                if (size > 3) {
                    return 1L;
                }
                if (fqn.get(1).equals(CHILD_NODES) || fqn.get(1).equals(CHILD_PROPS) || fqn.get(1).equals(CHILD_NODES_BY_PATTERN_LIST) || fqn.get(1).equals(CHILD_PROPS_BY_PATTERN_LIST)) {
                    return 0L;
                }
                return 1L;
            }
            for (InternalNode child : children) {
                count += JBossCacheWorkspaceStorageCache.numNodes((InternalNode<Serializable, Object>)child);
            }
        }
        return count;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.initialized;
    }

    @Override
    public boolean isPatternSupported() {
        return true;
    }

    @Override
    public boolean isChildNodesByPageSupported() {
        return true;
    }

    protected Fqn<String> makeItemFqn(String itemId) {
        return Fqn.fromRelativeElements(this.itemsRoot, (Object[])new String[]{itemId});
    }

    protected Fqn<String> makeRefFqn(String itemId) {
        return Fqn.fromRelativeElements(this.refRoot, (Object[])new String[]{itemId});
    }

    protected Fqn<String> makeChildFqn(Fqn<String> root, String parentId, QPathEntry childName) {
        return Fqn.fromRelativeElements(root, (Object[])new String[]{parentId, childName.getAsString(true)});
    }

    protected Fqn<String> makeChildFqn(Fqn<String> root, String parentId, String childName) {
        return Fqn.fromRelativeElements(root, (Object[])new String[]{parentId, childName});
    }

    protected Fqn<String> makeChildListFqn(Fqn<String> root, String parentId) {
        return Fqn.fromRelativeElements(root, (Object[])new String[]{parentId});
    }

    protected ItemData getFromCacheById(String id) {
        return (ItemData)this.cache.get(this.makeItemFqn(id), (Serializable)((Object)ITEM_DATA));
    }

    protected ItemData getFromBufferedCacheById(String id) {
        return (ItemData)this.cache.getFromBuffer(this.makeItemFqn(id), (Serializable)((Object)ITEM_DATA));
    }

    protected ItemData putItem(ItemData item) {
        if (item.isNode()) {
            return this.putNode((NodeData)item, ModifyChildOption.MODIFY);
        }
        return this.putProperty((PropertyData)item, ModifyChildOption.MODIFY);
    }

    protected ItemData putItemInBufferedCache(ItemData item) {
        if (item.isNode()) {
            return this.putNodeInBufferedCache((NodeData)item, ModifyChildOption.MODIFY);
        }
        return this.putProperty((PropertyData)item, ModifyChildOption.MODIFY);
    }

    protected ItemData putNode(NodeData node, ModifyChildOption modifyListsOfChild) {
        if (node.getParentIdentifier() != null) {
            this.cache.put(this.makeChildFqn(this.childNodes, node.getParentIdentifier(), node.getQPath().getEntries()[node.getQPath().getEntries().length - 1]), (Serializable)((Object)ITEM_ID), node.getIdentifier(), modifyListsOfChild == ModifyChildOption.NOT_MODIFY, true);
            if (modifyListsOfChild != ModifyChildOption.NOT_MODIFY) {
                this.cache.addToPatternList(this.makeChildListFqn(this.childNodesByPatternList, node.getParentIdentifier()), PATTERN_OBJ, ITEM_LIST, node);
                this.cache.addToList(this.makeChildListFqn(this.childNodesList, node.getParentIdentifier()), ITEM_LIST, node.getIdentifier(), modifyListsOfChild == ModifyChildOption.FORCE_MODIFY);
                this.cache.invalidateNode(this.makeChildListFqn(this.childNodesByPageList, node.getParentIdentifier()));
            }
        }
        return (ItemData)this.cache.put(this.makeItemFqn(node.getIdentifier()), (Serializable)((Object)ITEM_DATA), node, modifyListsOfChild == ModifyChildOption.NOT_MODIFY, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putNullItem(NullItemData item) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            if (!item.getIdentifier().equals("_null_id")) {
                this.cache.putIfAbsent(this.makeItemFqn(item.getIdentifier()), (Serializable)((Object)ITEM_DATA), item);
            } else if (item.getName() != null && item.getParentIdentifier() != null) {
                if (item.isNode()) {
                    this.cache.putIfAbsent(this.makeChildFqn(this.childNodes, item.getParentIdentifier(), item.getName()), (Serializable)((Object)ITEM_ID), "_null_id");
                } else {
                    this.cache.putIfAbsent(this.makeChildFqn(this.childProps, item.getParentIdentifier(), item.getName()), (Serializable)((Object)ITEM_ID), "_null_id");
                }
            }
            Object var4_3 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    protected ItemData putNodeInBufferedCache(NodeData node, ModifyChildOption modifyListsOfChild) {
        ItemData returnedData;
        if (node.getParentIdentifier() != null) {
            this.cache.putOnly(this.makeChildFqn(this.childNodes, node.getParentIdentifier(), node.getQPath().getEntries()[node.getQPath().getEntries().length - 1]), (Serializable)((Object)ITEM_ID), node.getIdentifier());
            if (modifyListsOfChild != ModifyChildOption.NOT_MODIFY) {
                this.cache.addToList(this.makeChildListFqn(this.childNodesList, node.getParentIdentifier()), ITEM_LIST, node.getIdentifier(), modifyListsOfChild == ModifyChildOption.FORCE_MODIFY);
            }
        }
        return (returnedData = (ItemData)this.cache.putInBuffer(this.makeItemFqn(node.getIdentifier()), (Serializable)((Object)ITEM_DATA), node)) instanceof NullItemData ? null : returnedData;
    }

    protected PropertyData putProperty(PropertyData prop, ModifyChildOption modifyListsOfChild) {
        this.cache.put(this.makeChildFqn(this.childProps, prop.getParentIdentifier(), prop.getQPath().getEntries()[prop.getQPath().getEntries().length - 1]), (Serializable)((Object)ITEM_ID), prop.getIdentifier(), modifyListsOfChild == ModifyChildOption.NOT_MODIFY, true);
        if (modifyListsOfChild != ModifyChildOption.NOT_MODIFY) {
            this.cache.addToPatternList(this.makeChildListFqn(this.childPropsByPatternList, prop.getParentIdentifier()), PATTERN_OBJ, ITEM_LIST, prop);
            this.cache.addToList(this.makeChildListFqn(this.childPropsList, prop.getParentIdentifier()), ITEM_LIST, prop.getIdentifier(), modifyListsOfChild == ModifyChildOption.FORCE_MODIFY);
        }
        if (modifyListsOfChild != ModifyChildOption.NOT_MODIFY && prop.getType() == 9) {
            List<ValueData> lData = prop.getValues();
            int length = lData.size();
            for (int i = 0; i < length; ++i) {
                String nodeIdentifier;
                block7: {
                    ValueData vdata = lData.get(i);
                    nodeIdentifier = null;
                    try {
                        nodeIdentifier = ValueDataUtil.getString(vdata);
                    }
                    catch (IllegalStateException e) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                        }
                    }
                    catch (RepositoryException e) {
                        if (!LOG.isTraceEnabled()) break block7;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
                this.cache.addToList(this.makeRefFqn(nodeIdentifier), ITEM_LIST, prop.getIdentifier(), modifyListsOfChild == ModifyChildOption.FORCE_MODIFY);
            }
        }
        ItemData returnedData = (ItemData)this.cache.put(this.makeItemFqn(prop.getIdentifier()), (Serializable)((Object)ITEM_DATA), prop, modifyListsOfChild == ModifyChildOption.NOT_MODIFY, false);
        return returnedData instanceof NullItemData ? null : (PropertyData)returnedData;
    }

    protected void removeItem(ItemData item) {
        if (item.isNode()) {
            if (item.getParentIdentifier() != null) {
                this.cache.removeNode(this.makeChildFqn(this.childNodes, item.getParentIdentifier(), item.getQPath().getEntries()[item.getQPath().getEntries().length - 1]));
                this.cache.removeFromList(this.makeChildListFqn(this.childNodesList, item.getParentIdentifier()), ITEM_LIST, item.getIdentifier());
                this.cache.removeFromPatternList(this.makeChildListFqn(this.childNodesByPatternList, item.getParentIdentifier()), PATTERN_OBJ, ITEM_LIST, item);
                this.cache.invalidateNode(this.makeChildListFqn(this.childNodesByPageList, item.getParentIdentifier()));
            }
            this.cache.removeNode(this.makeChildListFqn(this.childNodes, item.getIdentifier()));
            this.cache.removeNode(this.makeChildListFqn(this.childNodesList, item.getIdentifier()));
            this.cache.removeNode(this.makeChildListFqn(this.childProps, item.getIdentifier()));
            this.cache.removeNode(this.makeChildListFqn(this.childPropsList, item.getIdentifier()));
            this.cache.removeNode(this.makeChildListFqn(this.childNodesByPageList, item.getIdentifier()));
            this.cache.removeNode(this.makeChildListFqn(this.childNodesByPatternList, item.getIdentifier()));
            this.cache.removeNode(this.makeChildListFqn(this.childPropsByPatternList, item.getIdentifier()));
            this.cache.removeNode(this.makeRefFqn(item.getIdentifier()));
        } else {
            this.cache.removeNode(this.makeChildFqn(this.childProps, item.getParentIdentifier(), item.getQPath().getEntries()[item.getQPath().getEntries().length - 1]));
            this.cache.removeFromList(this.makeChildListFqn(this.childPropsList, item.getParentIdentifier()), ITEM_LIST, item.getIdentifier());
            this.cache.removeFromPatternList(this.makeChildListFqn(this.childPropsByPatternList, item.getParentIdentifier()), PATTERN_OBJ, ITEM_LIST, item);
        }
        this.cache.removeNode(this.makeItemFqn(item.getIdentifier()));
    }

    protected void updateMixin(NodeData node) {
        NodeData prevData = (NodeData)this.cache.put(this.makeItemFqn(node.getIdentifier()), (Serializable)((Object)ITEM_DATA), (Object)node);
        if (prevData != null && !(prevData instanceof NullItemData)) {
            if (prevData.getACL() == null || !prevData.getACL().equals(node.getACL())) {
                this.updateChildsACL(node.getIdentifier(), node.getACL());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Previous NodeData not found for mixin update " + node.getQPath().getAsString()));
        }
    }

    protected Set<String> updateInBuffer(NodeData node, QPath prevPath, Set<String> idsToSkip) {
        int prevNodeIndex;
        int nodeIndex;
        Fqn<String> prevFqn = this.makeChildFqn(this.childNodes, node.getParentIdentifier(), prevPath.getEntries()[prevPath.getEntries().length - 1]);
        if (node.getIdentifier().equals(this.cache.getFromBuffer(prevFqn, (Serializable)((Object)ITEM_ID))) && !this.cache.removeNode(prevFqn) && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Node doesn't exist as a child but update asked " + node.getQPath().getAsString()));
        }
        if ((nodeIndex = node.getQPath().getEntries()[node.getQPath().getEntries().length - 1].getIndex()) != (prevNodeIndex = prevPath.getEntries()[prevPath.getEntries().length - 1].getIndex())) {
            return this.updateTreePath(prevPath, node.getQPath(), idsToSkip);
        }
        return null;
    }

    protected void renameItem(ItemState renamedState, ItemState deletedState) {
        ItemData data = renamedState.getData();
        ItemData prevData = (ItemData)this.getFromBufferedCacheById.run(data.getIdentifier());
        if (data.isNode()) {
            if (renamedState.isPersisted()) {
                this.removeItem(deletedState.getData());
                this.putItem(renamedState.getData());
            } else {
                this.cache.putOnly(this.makeItemFqn(data.getIdentifier()), (Serializable)((Object)ITEM_DATA), data);
            }
        } else {
            PropertyData prop = (PropertyData)data;
            if (prevData != null && !(prevData instanceof NullItemData)) {
                PersistedPropertyData newProp = new PersistedPropertyData(prop.getIdentifier(), prop.getQPath(), prop.getParentIdentifier(), prop.getPersistedVersion(), prop.getType(), prop.isMultiValued(), ((PropertyData)prevData).getValues());
                this.cache.putOnly(this.makeItemFqn(newProp.getIdentifier()), (Serializable)((Object)ITEM_DATA), newProp);
            } else {
                this.cache.remove(this.makeItemFqn(data.getIdentifier()), (Serializable)((Object)ITEM_DATA));
            }
        }
    }

    protected Set<String> updateTreePath(QPath prevRootPath, QPath newRootPath, Set<String> idsToSkip) {
        HashSet<String> result = new HashSet<String>();
        Map<Fqn, Map<Serializable, Object>> changes = this.cache.getLastChanges();
        for (Fqn fqn : changes.keySet()) {
            ItemData data;
            if (!fqn.isChildOf(this.itemsRoot) || (data = (ItemData)changes.get(fqn).get(ITEM_DATA)) == null || idsToSkip != null && idsToSkip.contains(data.getIdentifier()) || !this.updateTreePath(prevRootPath, newRootPath, data)) continue;
            result.add(data.getIdentifier());
        }
        Node<Serializable, Object> items = this.cache.getNode(this.itemsRoot);
        Set childrenNames = items.getChildrenNames();
        for (String id : childrenNames) {
            ItemData data;
            Fqn<String> fqn = this.makeItemFqn(id);
            if (changes.containsKey(fqn) || (data = (ItemData)this.cache.get(fqn, (Serializable)((Object)ITEM_DATA))) == null || !this.updateTreePath(prevRootPath, newRootPath, data)) continue;
            result.add(data.getIdentifier());
        }
        return result;
    }

    private boolean updateTreePath(QPath prevRootPath, QPath newRootPath, ItemData data) {
        QPath nodeQPath = data.getQPath();
        if (nodeQPath != null && nodeQPath.isDescendantOf(prevRootPath)) {
            QPathEntry[] relativePath;
            block6: {
                relativePath = null;
                try {
                    relativePath = nodeQPath.getRelPath(nodeQPath.getDepth() - prevRootPath.getDepth());
                }
                catch (IllegalPathException e) {
                    if (!LOG.isTraceEnabled()) break block6;
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
            if (relativePath == null) {
                LOG.error((Object)("Could not get the relative path of the node " + nodeQPath + " with " + (nodeQPath.getDepth() - prevRootPath.getDepth()) + " as relative degree"));
                return false;
            }
            QPath newPath = QPath.makeChildPath(newRootPath, relativePath);
            if (data.isNode()) {
                NodeData prevNode = (NodeData)data;
                PersistedNodeData newNode = new PersistedNodeData(prevNode.getIdentifier(), newPath, prevNode.getParentIdentifier(), prevNode.getPersistedVersion(), prevNode.getOrderNumber(), prevNode.getPrimaryTypeName(), prevNode.getMixinTypeNames(), prevNode.getACL());
                this.cache.putOnly(this.makeItemFqn(newNode.getIdentifier()), (Serializable)((Object)ITEM_DATA), newNode);
            } else {
                PropertyData prevProp = (PropertyData)data;
                PersistedPropertyData newProp = new PersistedPropertyData(prevProp.getIdentifier(), newPath, prevProp.getParentIdentifier(), prevProp.getPersistedVersion(), prevProp.getType(), prevProp.isMultiValued(), prevProp.getValues());
                this.cache.putOnly(this.makeItemFqn(newProp.getIdentifier()), (Serializable)((Object)ITEM_DATA), newProp);
            }
            return true;
        }
        return false;
    }

    protected void updateChildsACL(String parentId, AccessControlList acl) {
        ChildNodesIterator iter = new ChildNodesIterator(parentId);
        block0: while (iter.hasNext()) {
            NodeData prevNode = (NodeData)iter.next();
            boolean hasExoPrivilegeable = false;
            boolean hasExoOwneable = false;
            for (InternalQName mixin : prevNode.getMixinTypeNames()) {
                if (mixin.equals((Object)Constants.EXO_PRIVILEGEABLE)) {
                    hasExoPrivilegeable = true;
                    if (!hasExoOwneable) continue;
                    continue block0;
                }
                if (!mixin.equals((Object)Constants.EXO_OWNEABLE)) continue;
                hasExoOwneable = true;
                if (hasExoPrivilegeable) continue block0;
            }
            AccessControlList newAcl = null;
            if (hasExoOwneable) {
                newAcl = new AccessControlList(prevNode.getACL().getOwner(), acl.getPermissionEntries());
            } else if (hasExoPrivilegeable) {
                newAcl = new AccessControlList(acl.getOwner(), prevNode.getACL().getPermissionEntries());
            }
            if (newAcl != null) {
                if (newAcl.equals(prevNode.getACL())) continue;
                acl = newAcl;
            }
            TransientNodeData newNode = new TransientNodeData(prevNode.getQPath(), prevNode.getIdentifier(), prevNode.getPersistedVersion(), prevNode.getPrimaryTypeName(), prevNode.getMixinTypeNames(), prevNode.getOrderNumber(), prevNode.getParentIdentifier(), acl);
            this.cache.putOnly(this.makeItemFqn(newNode.getIdentifier()), (Serializable)((Object)ITEM_DATA), newNode);
            this.updateChildsACL(newNode.getIdentifier(), acl);
        }
    }

    @Override
    public void beginTransaction() {
        this.cache.beginTransaction();
    }

    @Override
    public void commitTransaction() {
        this.cache.commitTransaction();
    }

    @Override
    public void rollbackTransaction() {
        this.cache.rollbackTransaction();
    }

    @Override
    public boolean isTXAware() {
        return true;
    }

    private void dedicatedTxCommit() {
        this.commitTransaction.run();
    }

    @Override
    public void backup(File storageDir) throws BackupException {
    }

    @Override
    @Managed
    @ManagedDescription(value="Remove all the existing items from the cache")
    public void clean() throws BackupException {
        LOG.info((Object)"Start to clean all the existing items from Jboss cache");
        this.cleanCache();
    }

    @Override
    public DataRestore getDataRestorer(DataRestoreContext context) throws BackupException {
        return new DataRestore(){

            public void clean() throws BackupException {
                LOG.info((Object)"Start to clean all the existing items from Jboss cache");
                JBossCacheWorkspaceStorageCache.this.cleanCache();
            }

            public void restore() throws BackupException {
            }

            public void commit() throws BackupException {
            }

            public void rollback() throws BackupException {
            }

            public void close() throws BackupException {
            }
        };
    }

    private void cleanCache() {
        if (this.cache.getCacheStatus() == CacheStatus.STARTED) {
            this.cache.beginTransaction();
            this.cache.removeNode(this.itemsRoot);
            this.cache.removeNode(this.refRoot);
            this.cache.removeNode(this.childNodes);
            this.cache.removeNode(this.childProps);
            this.cache.removeNode(this.childNodesList);
            this.cache.removeNode(this.childPropsList);
            this.cache.removeNode(this.childNodesByPageList);
            this.cache.removeNode(this.childNodesByPatternList);
            this.cache.removeNode(this.childPropsByPatternList);
            this.cache.commitTransaction();
            this.createResidentNode(this.childNodes);
            this.createResidentNode(this.refRoot);
            this.createResidentNode(this.childNodesList);
            this.createResidentNode(this.childProps);
            this.createResidentNode(this.childPropsList);
            this.createResidentNode(this.childNodesByPageList);
            this.createResidentNode(this.childNodesByPatternList);
            this.createResidentNode(this.childPropsByPatternList);
            this.createResidentNode(this.itemsRoot);
        }
    }

    @Override
    public void addListener(WorkspaceStorageCacheListener listener) {
        throw new UnsupportedOperationException("The cache listeners are not supported by the JBossCacheWorkspaceStorageCache");
    }

    @Override
    public void removeListener(WorkspaceStorageCacheListener listener) {
        throw new UnsupportedOperationException("The cache listeners are not supported by the JBossCacheWorkspaceStorageCache");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FakeValueSet
    extends HashSet<String> {
        private static final long serialVersionUID = 6163005084471981227L;

        public FakeValueSet() {
        }

        public FakeValueSet(int size) {
            for (int i = 0; i < size; ++i) {
                this.add(Integer.toString(i));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class CacheActionNonTxAware<R, A>
    extends ActionNonTxAware<R, A, RuntimeException> {
        protected CacheActionNonTxAware() {
        }

        @Override
        protected TransactionManager getTransactionManager() {
            return JBossCacheWorkspaceStorageCache.this.getTransactionManager();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ModifyChildOption {
        NOT_MODIFY,
        MODIFY,
        FORCE_MODIFY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ChildPropertiesIterator<P extends PropertyData>
    extends ChildItemsIterator<P> {
        ChildPropertiesIterator(String parentId) {
            super(JBossCacheWorkspaceStorageCache.this.childProps, parentId);
        }

        @Override
        public P next() {
            return (P)((PropertyData)super.next());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ChildNodesIterator<N extends NodeData>
    extends ChildItemsIterator<N> {
        ChildNodesIterator(String parentId) {
            super(JBossCacheWorkspaceStorageCache.this.childNodes, parentId);
        }

        @Override
        public N next() {
            return (N)((NodeData)super.next());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ChildItemsIterator<T extends ItemData>
    implements Iterator<T> {
        final Iterator<Object> childs;
        final String parentId;
        final Fqn<String> root;
        T next;

        ChildItemsIterator(Fqn<String> root, String parentId) {
            this.parentId = parentId;
            this.root = root;
            Fqn<String> parentFqn = JBossCacheWorkspaceStorageCache.this.makeChildListFqn(root, parentId);
            Node<Serializable, Object> parent = JBossCacheWorkspaceStorageCache.this.cache.getNode(parentFqn);
            if (parent != null) {
                this.childs = JBossCacheWorkspaceStorageCache.this.cache.getChildrenNames(parentFqn).iterator();
                this.fetchNext();
            } else {
                this.childs = null;
                this.next = null;
            }
        }

        protected void fetchNext() {
            if (this.childs.hasNext()) {
                ItemData n = null;
                do {
                    String itemId;
                    if ((itemId = (String)JBossCacheWorkspaceStorageCache.this.cache.get(JBossCacheWorkspaceStorageCache.this.makeChildFqn(this.root, this.parentId, (String)this.childs.next()), (Serializable)((Object)ITEM_ID))) == null) continue;
                    n = (ItemData)JBossCacheWorkspaceStorageCache.this.cache.get(JBossCacheWorkspaceStorageCache.this.makeItemFqn(itemId), (Serializable)((Object)ITEM_DATA));
                } while (n == null && this.childs.hasNext());
                this.next = n;
            } else {
                this.next = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            T current = this.next;
            this.fetchNext();
            return current;
        }

        @Override
        public void remove() {
            throw new IllegalArgumentException("Not implemented");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodesOrderComparator<N extends NodeData>
    implements Comparator<NodeData> {
        NodesOrderComparator() {
        }

        @Override
        public int compare(NodeData n1, NodeData n2) {
            return n1.getOrderNumber() - n2.getOrderNumber();
        }
    }
}

