/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.service.thread;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;

public class ThreadPoolConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String POOL_SIZE = "pool-size";
    private final String MAX_POOL_SIZE = "max-pool-size";
    private final String ASYNC_MODE = "async-mode";
    private final String THREAD_PRIORITY = "thread-priority";
    private String id;
    private Boolean defaultProfile;
    private Integer poolSize;
    private Integer maxPoolSize;
    private Long keepAliveTime;
    private TimeUnit timeUnit;
    private Integer maxQueueSize;
    private int priority = 5;
    private boolean asyncMode;

    public ThreadPoolConfig(InitParams params) {
        this.setKeepAliveTime(10L);
        this.setTimeUnit(TimeUnit.SECONDS);
        this.setMaxQueueSize(100);
        ValueParam poolSize = params.getValueParam("pool-size");
        ValueParam maxPoolSize = params.getValueParam("max-pool-size");
        ValueParam asyncMode = params.getValueParam("async-mode");
        ValueParam threadPriority = params.getValueParam("thread-priority");
        try {
            this.poolSize = Integer.valueOf(poolSize.getValue());
        }
        catch (Exception e) {
            this.poolSize = 5;
        }
        try {
            this.maxPoolSize = Integer.valueOf(maxPoolSize.getValue());
        }
        catch (Exception e) {
            this.maxPoolSize = 5;
        }
        try {
            this.priority = Integer.valueOf(threadPriority.getValue());
        }
        catch (Exception e) {
            this.priority = 10;
        }
        try {
            this.asyncMode = Boolean.valueOf(asyncMode.getValue());
        }
        catch (Exception e) {
            this.asyncMode = false;
        }
    }

    public ThreadPoolConfig() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean isDefaultProfile() {
        return this.defaultProfile != null && this.defaultProfile != false;
    }

    public void setDefaultProfile(Boolean defaultProfile) {
        this.defaultProfile = defaultProfile;
    }

    public Integer getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(Integer poolSize) {
        this.poolSize = poolSize;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public Long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(Long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public Integer getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(Integer maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isAsyncMode() {
        return this.asyncMode;
    }

    public void setAsyncMode(boolean asyncMode) {
        this.asyncMode = asyncMode;
    }
}

