/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.service;

import org.apache.commons.lang.Validate;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;

public class LinkProvider {
    public static final String RESOURCE_URL = "/social-resources";
    public static final String JAVASCRIPT_RESOURCE_URL = "/social-resources/javascript/";
    public static final String PROFILE_DEFAULT_AVATAR_URL = "/social-resources/skin/images/ShareImages/UserAvtDefault.png";
    public static final String SPACE_DEFAULT_AVATAR_URL = "/social-resources/skin/images/ShareImages/SpaceAvtDefault.png";
    public static final String HAS_CONNECTION_ICON = "/social-resources/skin/social/webui/UIManageUsers/DefaultSkin/background/StatusIcon.png";
    public static final String WAITING_CONFIRMATION_ICON = "/social-resources/skin/social/webui/UIManageUsers/DefaultSkin/background/WaittingConfirm.png";
    public static final String SPACE_MANAGER_ICON = "/social-resources/skin/social/webui/UIManageSpaces/DefaultSkin/background/Manager.png";
    public static final String SPACE_MEMBER_ICON = "/social-resources/skin/social/webui/UIManageSpaces/DefaultSkin/background/Member.png";
    public static final String SPACE_WAITING_CONFIRM_ICON = "/social-resources/skin/social/webui/UIManageSpaces/DefaultSkin/background/WaitingConfirm.png";
    public static final String STARTER_ACTIVITY_AVATAR = "/social-resources/skin/images/Activity/starterAvt.png";
    public static final String STARTER_ACTIVITY_IMAGE = "/social-resources/skin/images/Activity/starterActImg.png";
    public static final String ROUTE_DELIMITER = "/";
    private static IdentityManager identityManager;
    private static Log LOG;
    public static String DEFAULT_PORTAL_OWNER;

    public LinkProvider(InitParams params) {
        if (params.getValueParam("predefinedOwner") != null) {
            DEFAULT_PORTAL_OWNER = params.getValueParam("predefinedOwner").getValue();
        }
    }

    public static String getSpaceUri(String prettyName) {
        SpaceService spaceService = LinkProvider.getSpaceService();
        Space space = spaceService.getSpaceByPrettyName(prettyName);
        RequestContext ctx = RequestContext.getCurrentInstance();
        if (ctx != null) {
            NodeURL nodeURL = (NodeURL)ctx.createURL(NodeURL.TYPE);
            NavigationResource resource = new NavigationResource(SiteType.GROUP, space.getGroupId(), space.getUrl());
            return nodeURL.setResource(resource).toString();
        }
        return null;
    }

    public static String getProfileUri(String username) {
        return LinkProvider.buildProfileUri(username, null, null);
    }

    public static String getProfileUri(String username, String portalOwner) {
        return LinkProvider.buildProfileUri(username, null, portalOwner);
    }

    public static String getProfileLink(String username) {
        return LinkProvider.getProfileLink(username, null);
    }

    public static String getProfileLink(String username, String portalOwner) {
        Identity identity = LinkProvider.getIdentityManager().getOrCreateIdentity("organization", username, true);
        Validate.notNull((Object)identity, (String)"Identity must not be null.");
        String configured_domain_url = null;
        try {
            configured_domain_url = CommonsUtils.getCurrentDomain();
        }
        catch (NullPointerException e) {
            configured_domain_url = null;
        }
        return "<a href=\"" + (configured_domain_url != null ? configured_domain_url : "") + LinkProvider.buildProfileUri(identity.getRemoteId(), null, portalOwner) + "\" target=\"_parent\">" + identity.getProfile().getFullName() + "</a>";
    }

    public static String getAbsoluteProfileUrl(String userName, String portalName, String portalOwner, String host) {
        return host + LinkProvider.buildProfileUri(userName, portalName, portalOwner);
    }

    public static String getUserActivityUri(String remoteId) {
        return LinkProvider.getActivityUri("organization", remoteId);
    }

    public static String getUserConnectionsUri(String remoteId) {
        return LinkProvider.getBaseUri(null, null) + "/connections/all-people" + ROUTE_DELIMITER + remoteId;
    }

    public static String getUserConnectionsYoursUri(String remoteId) {
        return LinkProvider.getBaseUri(null, null) + "/connections/network" + ROUTE_DELIMITER + remoteId;
    }

    public static String getUserProfileUri(String remoteId) {
        return LinkProvider.getBaseUri(null, null) + "/profile" + ROUTE_DELIMITER + remoteId;
    }

    public static String getActivityUri(String providerId, String remoteId) {
        String prefix = LinkProvider.getBaseUri(null, null) + ROUTE_DELIMITER;
        if (providerId.equals("organization")) {
            return String.format("%sactivities/%s", prefix, remoteId);
        }
        if (providerId.equals("space")) {
            return String.format("/%s/g/:spaces:%s/%s", LinkProvider.getPortalName(null), remoteId, remoteId);
        }
        LOG.warn((Object)("Failed to getActivityLink with providerId: " + providerId));
        return null;
    }

    public static String getActivityUriForSpace(String remoteId, String groupId) {
        return String.format("/%s/g/:spaces:%s/%s", LinkProvider.getPortalName(null), groupId, remoteId);
    }

    public static String buildAvatarImageUri(AvatarAttachment avatarAttachment) {
        return LinkProvider.buildAvatarImageUri(PortalContainer.getInstance(), avatarAttachment);
    }

    public static String buildAvatarImageUri(Space space) {
        return LinkProvider.buildAvatarImageUri(space.getAvatarAttachment());
    }

    public static String buildAvatarImageUri(String identityName) {
        return String.format("/rest/jcr/repository/social/production/soc:providers/soc:space/soc:%s/soc:profile/soc:avatar", identityName);
    }

    public static String escapeJCRSpecialCharacters(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("[", "%5B").replace("]", "%5D").replace(":", "%3A");
    }

    public static String getAvatarImageSource(PortalContainer portalContainer, Profile profile) {
        AvatarAttachment avatarAttachment = (AvatarAttachment)profile.getProperty("avatar");
        if (avatarAttachment != null) {
            return LinkProvider.buildAvatarImageUri(portalContainer, avatarAttachment);
        }
        return null;
    }

    public static String getAvatarImageSource(Profile profile) {
        String avatarUrl = profile.getAvatarUrl();
        if (avatarUrl != null) {
            return avatarUrl;
        }
        AvatarAttachment avatarAttachment = (AvatarAttachment)profile.getProperty("avatar");
        if (avatarAttachment != null) {
            avatarUrl = LinkProvider.buildAvatarImageUri(avatarAttachment);
            profile.setAvatarUrl(avatarUrl);
            LinkProvider.getIdentityManager().saveProfile(profile);
            return avatarUrl;
        }
        return null;
    }

    private static String buildAvatarImageUri(PortalContainer container, AvatarAttachment avatarAttachment) {
        String avatarUrl = null;
        try {
            if (avatarAttachment != null) {
                String repository = ((RepositoryService)container.getComponentInstanceOfType(RepositoryService.class)).getCurrentRepository().getConfiguration().getName();
                avatarUrl = ROUTE_DELIMITER + container.getRestContextName() + "/jcr/" + repository + ROUTE_DELIMITER + avatarAttachment.getWorkspace() + avatarAttachment.getDataPath() + "/?upd=" + avatarAttachment.getLastModified();
                avatarUrl = LinkProvider.escapeJCRSpecialCharacters(avatarUrl);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to build avatar url from avatar attachment for: " + e.getMessage()));
        }
        return avatarUrl;
    }

    private static String buildProfileUri(String userName, String portalName, String portalOwner) {
        if (portalOwner == null || portalOwner.trim().length() == 0) {
            portalOwner = DEFAULT_PORTAL_OWNER;
        }
        return LinkProvider.getBaseUri(portalName, portalOwner) + "/profile" + ROUTE_DELIMITER + userName;
    }

    private static String getBaseUri(String portalName, String portalOwner) {
        return ROUTE_DELIMITER + LinkProvider.getPortalName(portalName) + ROUTE_DELIMITER + LinkProvider.getPortalOwner(portalOwner);
    }

    public static String getUserNotificationSettingUri(String remoteId) {
        return LinkProvider.getBaseUri(null, null) + "/notifications" + ROUTE_DELIMITER + remoteId;
    }

    public static String getRedirectUri(String type) {
        if (type.isEmpty()) {
            return LinkProvider.getBaseUri(null, null);
        }
        return LinkProvider.getBaseUri(null, null) + ROUTE_DELIMITER + type;
    }

    private static IdentityManager getIdentityManager() {
        if (identityManager == null) {
            identityManager = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
        }
        return identityManager;
    }

    private static SpaceService getSpaceService() {
        return (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
    }

    private static String getPortalOwner(String portalOwner) {
        if (portalOwner == null || portalOwner.trim().length() == 0) {
            try {
                return Util.getPortalRequestContext().getPortalOwner();
            }
            catch (Exception e) {
                return DEFAULT_PORTAL_OWNER;
            }
        }
        return portalOwner;
    }

    private static String getPortalName(String portalName) {
        if (portalName == null || portalName.trim().length() == 0) {
            return PortalContainer.getCurrentPortalContainerName();
        }
        return portalName;
    }

    static {
        LOG = ExoLogger.getLogger(LinkProvider.class);
        DEFAULT_PORTAL_OWNER = "classic";
    }
}

