/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.converter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.converter.Converter;
import net.sourceforge.jeuclid.converter.ConverterPlugin;
import org.w3c.dom.Node;

public class ImageIOConverter
implements ConverterPlugin {
    private final ImageWriter writer;
    private final boolean removeAlpha;

    ImageIOConverter(ImageWriter imageWriter, boolean bl) {
        this.writer = imageWriter;
        this.removeAlpha = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension convert(Node node, LayoutContext layoutContext, OutputStream outputStream) throws IOException {
        MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(outputStream);
        BufferedImage bufferedImage = Converter.getInstance().render(node, layoutContext);
        if (this.removeAlpha && bufferedImage.getColorModel().hasAlpha()) {
            bufferedImage = this.removeAlpha(bufferedImage);
        }
        ImageWriter imageWriter = this.writer;
        synchronized (imageWriter) {
            this.writer.setOutput(memoryCacheImageOutputStream);
            this.writer.write(bufferedImage);
        }
        memoryCacheImageOutputStream.close();
        return new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public ConverterPlugin.DocumentWithDimension convert(Node node, LayoutContext layoutContext) {
        return null;
    }

    private BufferedImage removeAlpha(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        return bufferedImage2;
    }
}

