/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.MoreAsserts;
import com.google.caja.util.TestUtil;
import java.util.ArrayList;
import java.util.Arrays;

public class HtmlLexerTest
extends CajaTestCase {
    public final void testHtmlLexer() throws Exception {
        CharProducer p = this.fromResource("htmllexerinput1.html");
        StringBuilder actual = new StringBuilder();
        this.lex(new HtmlLexer(p), actual);
        String golden = this.fromResource("htmllexergolden1.txt").toString();
        HtmlLexerTest.assertEquals((String)golden, (String)actual.toString());
    }

    public final void testXmlLexer() throws Exception {
        CharProducer p = this.fromResource("htmllexerinput2.xml");
        StringBuilder actual = new StringBuilder();
        HtmlLexer lexer = new HtmlLexer(p);
        lexer.setTreatedAsXml(true);
        this.lex(lexer, actual);
        String golden = TestUtil.readResource(((Object)((Object)this)).getClass(), "htmllexergolden2.txt");
        HtmlLexerTest.assertEquals((String)golden, (String)actual.toString());
    }

    public final void testEofInTag() throws Exception {
        this.assertTokens("<div", true, "TAGBEGIN: <div");
        this.assertTokens("</div", true, "TAGBEGIN: </div");
        this.assertTokens("<div\n", true, "TAGBEGIN: <div");
        this.assertTokens("</div\n", true, "TAGBEGIN: </div");
        this.assertTokens("<div", false, "TAGBEGIN: <div");
        this.assertTokens("</div", false, "TAGBEGIN: </div");
        this.assertTokens("<div\n", false, "TAGBEGIN: <div");
        this.assertTokens("</div\n", false, "TAGBEGIN: </div");
    }

    public final void testPartialTagInCData() throws Exception {
        this.assertTokens("<script>w('</b')</script>", false, "TAGBEGIN: <script", "TAGEND: >", "UNESCAPED: w('</b')", "TAGBEGIN: </script", "TAGEND: >");
    }

    public final void testUrlEndingInSlashOutsideQuotes() throws Exception {
        this.assertTokens("<a href=http://foo.com/>Clicky</a>", false, "TAGBEGIN: <a", "ATTRNAME: href", "ATTRVALUE: http://foo.com/", "TAGEND: >", "TEXT: Clicky", "TAGBEGIN: </a", "TAGEND: >");
        this.assertTokens("<a href=http://foo.com/>Clicky</a>", true, "TAGBEGIN: <a", "ATTRNAME: href", "ATTRVALUE: http://foo.com/", "TAGEND: >", "TEXT: Clicky", "TAGBEGIN: </a", "TAGEND: >");
    }

    public final void testShortTags() throws Exception {
        this.assertTokens("<p<a href=\"/\">first part of the text</> second part", false, "TAGBEGIN: <p", "ATTRNAME: <a", "ATTRNAME: href", "ATTRVALUE: \"/\"", "TAGEND: >", "TEXT: first part of the text</> second part");
        this.assertTokens("<p/b/", false, "TAGBEGIN: <p", "ATTRNAME: /", "ATTRNAME: b/");
        this.assertTokens("<p<b>", false, "TAGBEGIN: <p", "ATTRNAME: <b", "TAGEND: >");
    }

    private void lex(HtmlLexer lexer, Appendable out) throws Exception {
        int maxTypeLength = 0;
        for (HtmlTokenType t : HtmlTokenType.values()) {
            maxTypeLength = Math.max(maxTypeLength, t.name().length());
        }
        while (lexer.hasNext()) {
            Token t = lexer.next();
            String escaped = t.text.replace("\\", "\\\\").replace("\n", "\\n");
            String type = ((HtmlTokenType)t.type).toString();
            while (type.length() < maxTypeLength) {
                type = type + " ";
            }
            out.append(type).append(" [").append(escaped).append("]  :  ").append(t.pos.toString()).append("\n");
        }
    }

    private void assertTokens(String markup, boolean asXml, String ... golden) throws ParseException {
        HtmlLexer lexer = new HtmlLexer(this.fromString(markup));
        lexer.setTreatedAsXml(asXml);
        ArrayList<String> actual = new ArrayList<String>();
        while (lexer.hasNext()) {
            Token t = lexer.next();
            actual.add(t.type + ": " + t.text);
        }
        MoreAsserts.assertListsEqual(Arrays.asList(golden), actual);
    }
}

