/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.stages.PipelineStageTestCase;
import com.google.caja.plugin.stages.ResolveUriStage;
import com.google.caja.util.ContentType;

public class ResolveUriStageTest
extends PipelineStageTestCase {
    public final void testEmptyDoc() throws Exception {
        this.assertPipeline(ResolveUriStageTest.job("", ContentType.HTML), ResolveUriStageTest.job("", ContentType.HTML));
    }

    public final void testLink() throws Exception {
        this.assertPipeline(ResolveUriStageTest.job("<a href=foo.html>foo</a>", ContentType.HTML), ResolveUriStageTest.job("<a href=\"test://example.org/foo.html\">foo</a>", ContentType.HTML));
    }

    public final void testAnchorOnly() throws Exception {
        this.assertPipeline(ResolveUriStageTest.job("<a href=#bar>foo</a>", ContentType.HTML), ResolveUriStageTest.job("<a href=\"#bar\">foo</a>", ContentType.HTML));
    }

    public final void testLinkWithAnchor() throws Exception {
        this.assertPipeline(ResolveUriStageTest.job("<a href=foo.html#bar>foo</a>", ContentType.HTML), ResolveUriStageTest.job("<a href=\"test://example.org/foo.html#bar\">foo</a>", ContentType.HTML));
    }

    public final void testLinkWithBase() throws Exception {
        this.assertPipeline(ResolveUriStageTest.job("<base href=http://example.org/bar/baz/foo.html><a href=../boo.html>foo</a>", ContentType.HTML), ResolveUriStageTest.job("<base href=\"http://example.org/bar/baz/foo.html\" /><a href=\"http://example.org/bar/boo.html\">foo</a>", ContentType.HTML));
    }

    public final void testUnresolvableUrl() throws Exception {
        this.assertPipeline(ResolveUriStageTest.job("<base href=http://example.org/bar/baz/foo.html><a href=../../../../boo.html>foo</a>", ContentType.HTML), ResolveUriStageTest.job("<base href=\"http://example.org/bar/baz/foo.html\" /><a href=\"../../../../boo.html\">foo</a>", ContentType.HTML));
    }

    public final void testMalformedUrl() throws Exception {
        this.assertPipeline(ResolveUriStageTest.job("<a href='foo bar'>foo</a>", ContentType.HTML), ResolveUriStageTest.job("<a href=\"test://example.org/foo%20bar\">foo</a>", ContentType.HTML));
    }

    public final void testOpaqueUrl() throws Exception {
        this.assertPipeline(ResolveUriStageTest.job("<a href=mailto:bob@example.com>foo</a>", ContentType.HTML), ResolveUriStageTest.job("<a href=\"mailto:bob%40example.com\">foo</a>", ContentType.HTML));
    }

    public final void testJavascriptUrl() throws Exception {
        this.assertPipeline(ResolveUriStageTest.job("<a href='javascript:foo() + bar([1, 2, 3]) * 4'>foo</a>", ContentType.HTML), ResolveUriStageTest.job("<a href=\"javascript:foo%28%29%20+%20bar%28%5b1,%202,%203%5d%29%20%2a%204\">foo</a>", ContentType.HTML));
    }

    protected boolean runPipeline(Jobs jobs) throws Exception {
        return new ResolveUriStage(HtmlSchema.getDefault(this.mq)).apply(jobs);
    }
}

