/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.display.internal;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.context.Execution;
import org.xwiki.display.internal.DocumentDisplayer;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.util.ParserUtils;
import org.xwiki.velocity.VelocityManager;

public abstract class AbstractDocumentTitleDisplayer
implements DocumentDisplayer {
    private static final String DOCUMENT_REFERENCE_STACK_KEY = "internal.displayer.title.documentReferenceStack";
    @Inject
    private Logger logger;
    @Inject
    @Named(value="plain/1.0")
    private Parser plainTextParser;
    @Inject
    private VelocityManager velocityManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    private Execution execution;
    private ParserUtils parserUtils = new ParserUtils();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XDOM display(DocumentModelBridge document, DocumentDisplayerParameters parameters) {
        Map<Object, Object> xwikiContext = this.getXWikiContextMap();
        Stack<DocumentReference> documentReferenceStack = (Stack<DocumentReference>)xwikiContext.get(DOCUMENT_REFERENCE_STACK_KEY);
        if (documentReferenceStack == null) {
            documentReferenceStack = new Stack<DocumentReference>();
            xwikiContext.put(DOCUMENT_REFERENCE_STACK_KEY, documentReferenceStack);
        } else if (documentReferenceStack.contains(document.getDocumentReference())) {
            this.logger.warn("Infinite recursion detected while displaying the title of [{}]. Using the document name as title.", (Object)document.getDocumentReference());
            return this.getStaticTitle(document);
        }
        documentReferenceStack.push(document.getDocumentReference());
        try {
            XDOM xDOM = this.displayTitle(document, parameters);
            return xDOM;
        }
        finally {
            documentReferenceStack.pop();
        }
    }

    private XDOM displayTitle(DocumentModelBridge document, DocumentDisplayerParameters parameters) {
        if (!StringUtils.isEmpty((CharSequence)document.getTitle())) {
            try {
                return this.parseTitle(this.evaluateTitle(document.getTitle(), document.getDocumentReference(), parameters));
            }
            catch (Exception e) {
                this.logger.warn("Failed to interpret title of document [{}].", (Object)document.getDocumentReference(), (Object)e);
            }
        }
        try {
            XDOM title = this.extractTitleFromContent(document, parameters);
            if (title != null) {
                return title;
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to extract title from content of document [{}].", (Object)document.getDocumentReference(), (Object)e);
        }
        return this.getStaticTitle(document);
    }

    protected XDOM parseTitle(String title) {
        try {
            XDOM xdom = this.plainTextParser.parse((Reader)new StringReader(title));
            this.parserUtils.removeTopLevelParagraph(xdom.getChildren());
            return xdom;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    protected String evaluateTitle(String title, DocumentReference documentReference, DocumentDisplayerParameters parameters) {
        StringWriter writer = new StringWriter();
        String nameSpace = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)(parameters.isTransformationContextIsolated() ? documentReference : this.documentAccessBridge.getCurrentDocumentReference()), new Object[0]);
        HashMap backupObjects = null;
        boolean canPop = false;
        try {
            if (parameters.isExecutionContextIsolated()) {
                backupObjects = new HashMap();
                this.documentAccessBridge.pushDocumentInContext(backupObjects, documentReference);
                canPop = true;
            }
            this.velocityManager.getVelocityEngine().evaluate((Context)this.velocityManager.getVelocityContext(), (Writer)writer, nameSpace, title);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (canPop) {
                this.documentAccessBridge.popDocumentFromContext(backupObjects);
            }
        }
        return writer.toString();
    }

    private Map<Object, Object> getXWikiContextMap() {
        return (Map)this.execution.getContext().getProperty("xwikicontext");
    }

    protected abstract XDOM extractTitleFromContent(DocumentModelBridge var1, DocumentDisplayerParameters var2);

    private XDOM getStaticTitle(DocumentModelBridge document) {
        return this.parseTitle(document.getDocumentReference().getName());
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

