/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Normalize;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticSourceFile;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import javax.annotation.Nullable;

class RuntimeTypeCheck
implements CompilerPass {
    private static final Comparator<JSType> ALPHA = new Comparator<JSType>(){

        @Override
        public int compare(JSType t1, JSType t2) {
            return this.getName(t1).compareTo(this.getName(t2));
        }

        private String getName(JSType type) {
            if (type.isInstanceType()) {
                return ((ObjectType)type).getReferenceName();
            }
            if (type.isNullType() || type.isBooleanValueType() || type.isNumberValueType() || type.isStringValueType() || type.isVoidType()) {
                return type.toString();
            }
            return "";
        }
    };
    private final AbstractCompiler compiler;
    private final String logFunction;

    RuntimeTypeCheck(AbstractCompiler compiler, @Nullable String logFunction) {
        this.compiler = compiler;
        this.logFunction = logFunction;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new AddMarkers(this.compiler));
        NodeTraversal.traverse(this.compiler, root, new AddChecks());
        this.addBoilerplateCode();
    }

    private void addBoilerplateCode() {
        Node js = RuntimeTypeCheck.getBoilerplateCode(this.compiler, this.logFunction);
        this.compiler.getNodeForCodeInsertion(null).addChildrenToFront(js.removeChildren());
        this.compiler.reportCodeChange();
    }

    private Node jsCode(String prop) {
        return NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), "jscomp.typecheck." + prop, -1, -1);
    }

    @VisibleForTesting
    static Node getBoilerplateCode(AbstractCompiler compiler, @Nullable String logFunction) {
        String boilerplateCode;
        try {
            boilerplateCode = CharStreams.toString((Readable)new InputStreamReader(RuntimeTypeCheck.class.getResourceAsStream("js/runtime_type_check.js"), Charsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        boilerplateCode = boilerplateCode.replace("%%LOG%%", logFunction == null ? "function(warning, expr) {}" : logFunction);
        return Normalize.parseAndNormalizeSyntheticCode(compiler, boilerplateCode, "jscomp_runtimeTypeCheck_");
    }

    private class AddChecks
    extends NodeTraversal.AbstractPostOrderCallback {
        private AddChecks() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isFunction()) {
                this.visitFunction(t, n);
            } else if (n.isReturn()) {
                this.visitReturn(t, n);
            }
        }

        private void visitFunction(NodeTraversal t, Node n) {
            FunctionType funType = JSType.toMaybeFunctionType(n.getJSType());
            Node block = n.getLastChild();
            Node paramName = NodeUtil.getFunctionParameters(n).getFirstChild();
            Node insertionPoint = null;
            for (Node next = block.getFirstChild(); next != null && NodeUtil.isFunctionDeclaration(next); next = next.getNext()) {
                insertionPoint = next;
            }
            for (Node paramType : funType.getParameters()) {
                if (paramName == null) {
                    return;
                }
                Node checkNode = this.createCheckTypeCallNode(paramType.getJSType(), paramName.cloneTree());
                if (checkNode == null) {
                    paramName = paramName.getNext();
                    continue;
                }
                checkNode = new Node(130, checkNode);
                if (insertionPoint == null) {
                    block.addChildToFront(checkNode);
                } else {
                    block.addChildAfter(checkNode, insertionPoint);
                }
                RuntimeTypeCheck.this.compiler.reportCodeChange();
                paramName = paramName.getNext();
                insertionPoint = checkNode;
            }
        }

        private void visitReturn(NodeTraversal t, Node n) {
            Node function = t.getEnclosingFunction();
            FunctionType funType = function.getJSType().toMaybeFunctionType();
            Node retValue = n.getFirstChild();
            if (retValue == null) {
                return;
            }
            Node checkNode = this.createCheckTypeCallNode(funType.getReturnType(), retValue.cloneTree());
            if (checkNode == null) {
                return;
            }
            n.replaceChild(retValue, checkNode);
            RuntimeTypeCheck.this.compiler.reportCodeChange();
        }

        private Node createCheckTypeCallNode(JSType type, Node expr) {
            TreeSet alternates;
            Node arrayNode = new Node(63);
            if (type.isUnionType()) {
                alternates = Sets.newTreeSet((Comparator)ALPHA);
                Iterables.addAll((Collection)alternates, type.toMaybeUnionType().getAlternates());
            } else {
                alternates = ImmutableList.of((Object)type);
            }
            for (JSType alternate : alternates) {
                Node checkerNode = this.createCheckerNode(alternate);
                if (checkerNode == null) {
                    return null;
                }
                arrayNode.addChildToBack(checkerNode);
            }
            return new Node(37, RuntimeTypeCheck.this.jsCode("checkType"), expr, arrayNode);
        }

        private Node createCheckerNode(JSType type) {
            if (type.isNullType()) {
                return RuntimeTypeCheck.this.jsCode("nullChecker");
            }
            if (type.isBooleanValueType() || type.isNumberValueType() || type.isStringValueType() || type.isVoidType()) {
                return new Node(37, RuntimeTypeCheck.this.jsCode("valueChecker"), Node.newString(type.toString()));
            }
            if (type.isInstanceType()) {
                ObjectType objType = (ObjectType)type;
                String refName = objType.getReferenceName();
                StaticSourceFile sourceFile = NodeUtil.getSourceFile(objType.getConstructor().getSource());
                if (sourceFile == null || sourceFile.isExtern()) {
                    return new Node(37, RuntimeTypeCheck.this.jsCode("externClassChecker"), Node.newString(refName));
                }
                return new Node(37, RuntimeTypeCheck.this.jsCode(objType.getConstructor().isInterface() ? "interfaceChecker" : "classChecker"), Node.newString(refName));
            }
            return null;
        }
    }

    private static class AddMarkers
    extends NodeTraversal.AbstractPostOrderCallback {
        private final AbstractCompiler compiler;

        private AddMarkers(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isFunction()) {
                this.visitFunction(t, n);
            }
        }

        private void visitFunction(NodeTraversal t, Node n) {
            FunctionType funType = n.getJSType().toMaybeFunctionType();
            if (funType != null && !funType.isConstructor()) {
                return;
            }
            Node nodeToInsertAfter = this.findNodeToInsertAfter(n);
            nodeToInsertAfter = this.addMarker(funType, nodeToInsertAfter, null);
            TreeSet stuff = Sets.newTreeSet((Comparator)ALPHA);
            Iterables.addAll((Collection)stuff, funType.getAllImplementedInterfaces());
            for (ObjectType interfaceType : stuff) {
                nodeToInsertAfter = this.addMarker(funType, nodeToInsertAfter, interfaceType);
            }
        }

        private Node addMarker(FunctionType funType, Node nodeToInsertAfter, @Nullable ObjectType interfaceType) {
            if (funType.getSource() == null) {
                return nodeToInsertAfter;
            }
            String className = NodeUtil.getFunctionName(funType.getSource());
            if (className == null) {
                return nodeToInsertAfter;
            }
            Node classNode = NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), className, -1, -1);
            Node marker = Node.newString(interfaceType == null ? "instance_of__" + className : "implements__" + interfaceType.getReferenceName());
            Node assign = new Node(130, new Node(86, new Node(35, new Node(33, classNode, Node.newString("prototype")), marker), new Node(44)));
            nodeToInsertAfter.getParent().addChildAfter(assign, nodeToInsertAfter);
            this.compiler.reportCodeChange();
            nodeToInsertAfter = assign;
            return nodeToInsertAfter;
        }

        private Node findNodeToInsertAfter(Node n) {
            Node nodeToInsertAfter = this.findEnclosingConstructorDeclaration(n);
            Node next = nodeToInsertAfter.getNext();
            while (next != null && this.isClassDefiningCall(next)) {
                nodeToInsertAfter = next;
                next = nodeToInsertAfter.getNext();
            }
            return nodeToInsertAfter;
        }

        private Node findEnclosingConstructorDeclaration(Node n) {
            while (n.getParent().getType() != 132 && n.getParent().getType() != 125) {
                n = n.getParent();
            }
            return n;
        }

        private boolean isClassDefiningCall(Node next) {
            return NodeUtil.isExprCall(next) && this.compiler.getCodingConvention().getClassesDefinedByCall(next.getFirstChild()) != null;
        }
    }
}

