/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge;

import java.io.Closeable;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import juzu.impl.asset.AssetServer;
import juzu.impl.bridge.BridgeConfig;
import juzu.impl.common.Logger;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.plugin.application.Application;
import juzu.impl.plugin.application.ApplicationLifeCycle;
import juzu.impl.plugin.module.Module;
import juzu.impl.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bridge
implements Closeable {
    public final Logger log;
    private final AssetServer server;
    private final BridgeConfig config;
    private final ReadFileSystem<?> resources;
    private final ResourceResolver resolver;
    public final Module module;
    public ApplicationLifeCycle<?, ?> application;
    FutureTask<Boolean> refreshTask = new FutureTask<Boolean>(new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            if (Bridge.this.application == null) {
                Bridge.this.application = new ApplicationLifeCycle(Bridge.this.log, Bridge.this.module.context.getLifeCycle(), ((Bridge)Bridge.this).config.injectImpl, ((Bridge)Bridge.this).config.name, Bridge.this.resources, Bridge.this.server, Bridge.this.resolver);
            }
            return Bridge.this.application.refresh();
        }
    });

    public Bridge(Logger log, Module module, BridgeConfig config, ReadFileSystem<?> resources, AssetServer server, ResourceResolver resolver) {
        this.log = log;
        this.module = module;
        this.config = config;
        this.resources = resources;
        this.server = server;
        this.resolver = resolver;
    }

    public BridgeConfig getConfig() {
        return this.config;
    }

    public boolean refresh() throws Exception {
        return this.refresh(true);
    }

    public boolean refresh(boolean recompile) throws Exception {
        boolean recompiled = this.module.context.getLifeCycle().refresh(recompile);
        if (recompiled) {
            this.refreshTask = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    if (Bridge.this.application == null) {
                        Bridge.this.application = new ApplicationLifeCycle(Bridge.this.log, Bridge.this.module.context.getLifeCycle(), ((Bridge)Bridge.this).config.injectImpl, ((Bridge)Bridge.this).config.name, Bridge.this.resources, Bridge.this.server, Bridge.this.resolver);
                    }
                    return Bridge.this.application.refresh();
                }
            });
        }
        this.refreshTask.run();
        return this.refreshTask.get();
    }

    public Application getApplication() {
        return this.application.getApplication();
    }

    @Override
    public void close() {
        Tools.safeClose(this.application);
    }
}

