/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.util.Hashtable;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.functions.Function;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Library;

public class Separation
extends PColorSpace {
    protected Color namedColor;
    protected PColorSpace alternate;
    protected Function tintTransform;

    protected Separation(Library l, Hashtable h, Object name, Object alternateSpace, Object tintTransform) {
        super(l, h);
        String colorName;
        int colorVaue;
        this.alternate = Separation.getColorSpace(l, alternateSpace);
        this.tintTransform = Function.getFunction(l, l.getObject(tintTransform));
        if (name instanceof Name && (colorVaue = ColorUtil.convertNamedColor((colorName = ((Name)name).getName()).toLowerCase())) != -1) {
            this.namedColor = new Color(colorVaue);
        }
    }

    public int getNumComponents() {
        return 1;
    }

    public Color getColor(float[] components) {
        if (this.tintTransform == null) {
            float colour = components[0];
            float[] alternateColour = new float[this.alternate.getNumComponents()];
            int max = this.alternate.getNumComponents();
            for (int i = 0; i < max; ++i) {
                alternateColour[i] = colour;
            }
            return this.alternate.getColor(alternateColour);
        }
        if (this.alternate != null) {
            float[] y = this.tintTransform.calculate(components);
            return this.alternate.getColor(Separation.reverse(y));
        }
        return this.namedColor;
    }
}

