/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.jcr.RepositoryException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.wiki.chromattic.ext.ntdef.NTVersion;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.api.WikiType;
import org.exoplatform.wiki.mow.core.api.MOWService;
import org.exoplatform.wiki.mow.core.api.ModelImpl;
import org.exoplatform.wiki.mow.core.api.WikiStoreImpl;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.mow.core.api.wiki.WikiContainer;
import org.exoplatform.wiki.mow.core.api.wiki.WikiHome;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.WikiContext;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.diff.DiffResult;
import org.exoplatform.wiki.service.diff.DiffService;
import org.exoplatform.wiki.service.impl.WikiPageHistory;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.utils.VersionNameComparatorDesc;
import org.xwiki.rendering.syntax.Syntax;

public class Utils {
    public static final String SLASH = "SLASH";
    public static final String DOT = "DOT";
    public static final String SPACE = "space";
    public static final String PAGE = "page";
    private static final Log log_ = ExoLogger.getLogger(Utils.class);
    private static final String JCR_WEBDAV_SERVICE_BASE_URI = "/jcr";
    public static final String COMPARE_REVISION = "CompareRevision";
    public static final String VER_NAME = "verName";
    private static final String MIMETYPE_TEXTHTML = "text/html";
    private static Map<String, Map<String, WikiPageHistory>> editPageLogs = new HashMap<String, Map<String, WikiPageHistory>>();
    public static final String WIKI_RESOUCE_BUNDLE_NAME = "locale.wiki.service.WikiService";
    private static final String ILLEGAL_SEARCH_CHARACTERS = "\\!^()+{}[]:-\"";
    public static final String SPLIT_TEXT_OF_DRAFT_FOR_NEW_PAGE = "_A_A_";

    public static String escapeIllegalCharacterInQuery(String query) {
        String ret = query;
        if (ret != null) {
            for (char c : ILLEGAL_SEARCH_CHARACTERS.toCharArray()) {
                ret = ret.replace(c + "", "\\" + c);
            }
            ret = ret.replace("'", "''");
        }
        return ret;
    }

    public static String getPortalName() {
        return org.exoplatform.wiki.rendering.util.Utils.getPortalName();
    }

    public static String getWikiResourceBundle(String key, ClassLoader cl) {
        Locale locale = WebuiRequestContext.getCurrentInstance().getLocale();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(WIKI_RESOUCE_BUNDLE_NAME, locale, cl);
        return resourceBundle.getString(key);
    }

    public static void logEditPageTime(WikiPageParams pageParams, String username, long updateTime, String draftName, boolean isNewPage) {
        WikiPageHistory logByUsername;
        String pageId = pageParams.getPageId();
        Map<String, WikiPageHistory> logByPage = editPageLogs.get(pageId);
        if (logByPage == null) {
            logByPage = new HashMap<String, WikiPageHistory>();
            editPageLogs.put(pageId, logByPage);
        }
        if ((logByUsername = logByPage.get(username)) == null) {
            logByUsername = new WikiPageHistory(pageParams, username, draftName, isNewPage);
            logByPage.put(username, logByUsername);
        }
        logByUsername.setEditTime(updateTime);
    }

    public static void removeLogEditPage(WikiPageParams pageParams, String user) {
        String pageId = pageParams.getPageId();
        Map<String, WikiPageHistory> logByPage = editPageLogs.get(pageId);
        if (logByPage != null) {
            logByPage.remove(user);
        }
    }

    public static List<String> getListOfUserEditingPage(String pageId) {
        WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
        ArrayList<String> edittingUsers = new ArrayList<String>();
        ArrayList<String> outdateEdittingUser = new ArrayList<String>();
        String currentUser = Utils.getCurrentUser();
        Map<String, WikiPageHistory> logByPage = editPageLogs.get(pageId);
        if (logByPage != null) {
            for (String username : logByPage.keySet()) {
                WikiPageHistory log = logByPage.get(username);
                if (System.currentTimeMillis() - log.getEditTime() < wikiService.getEditPageLivingTime()) {
                    if (username.equals(currentUser) || log.isNewPage()) continue;
                    edittingUsers.add(username);
                    continue;
                }
                outdateEdittingUser.add(username);
            }
            for (String username : outdateEdittingUser) {
                logByPage.remove(username);
            }
        }
        return edittingUsers;
    }

    public static String getPermanlink(WikiPageParams params, boolean hasDowmainUrl) throws Exception {
        WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
        String wikiWebappUri = wikiService.getWikiWebappUri();
        StringBuilder sb = new StringBuilder(wikiWebappUri);
        sb.append("/");
        if (!params.getType().equalsIgnoreCase(WikiType.PORTAL.toString())) {
            sb.append(params.getType().toLowerCase());
            sb.append("/");
            sb.append(Utils.validateWikiOwner(params.getType(), params.getOwner()));
            sb.append("/");
        }
        if (params.getPageId() != null) {
            sb.append(params.getPageId());
        }
        if (hasDowmainUrl) {
            return Utils.getDomainUrl() + Utils.fillPortalName(sb.toString());
        }
        return Utils.fillPortalName(sb.toString());
    }

    public static String getPageNameForAddingPage() {
        String sessionId = Util.getPortalRequestContext().getRequest().getSession(false).getId();
        String username = Utils.getCurrentUser();
        return username + SPLIT_TEXT_OF_DRAFT_FOR_NEW_PAGE + sessionId;
    }

    private static String getDomainUrl() {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        StringBuilder domainUrl = new StringBuilder();
        domainUrl.append(portalRequestContext.getRequest().getScheme());
        domainUrl.append("://");
        domainUrl.append(portalRequestContext.getRequest().getServerName());
        int port = portalRequestContext.getRequest().getServerPort();
        if (port != 80) {
            domainUrl.append(":");
            domainUrl.append(port);
        }
        return domainUrl.toString();
    }

    private static String fillPortalName(String url) {
        RequestContext ctx = RequestContext.getCurrentInstance();
        NodeURL nodeURL = (NodeURL)ctx.createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.PORTAL, Util.getPortalRequestContext().getPortalOwner(), url);
        return nodeURL.setResource(resource).toString();
    }

    public static Map<String, WikiPageHistory> getLogOfPage(String pageId) {
        Map<String, WikiPageHistory> logByPage = editPageLogs.get(pageId);
        if (logByPage == null) {
            logByPage = new HashMap<String, WikiPageHistory>();
        }
        return logByPage;
    }

    public static String getPortalWikisPath() {
        String path = "/exo:applications/eXoWiki/wikis";
        return path;
    }

    public static String getSpaceIdByJcrPath(String jcrPath) throws IllegalArgumentException {
        String wikiType = Utils.getWikiType(jcrPath);
        if (PortalConfig.PORTAL_TYPE.equals(wikiType)) {
            return Utils.getPortalIdByJcrPath(jcrPath);
        }
        if (PortalConfig.GROUP_TYPE.equals(wikiType)) {
            return Utils.getGroupIdByJcrPath(jcrPath);
        }
        if (PortalConfig.USER_TYPE.equals(wikiType)) {
            return Utils.getUserIdByJcrPath(jcrPath);
        }
        throw new IllegalArgumentException(jcrPath + " is not jcr path of a wiki page node!");
    }

    public static String getGroupIdByJcrPath(String jcrPath) throws IllegalArgumentException {
        int pos1 = jcrPath.indexOf("/Groups/");
        int pos2 = jcrPath.indexOf("/ApplicationData");
        if (pos1 >= 0 && pos2 > 0) {
            return jcrPath.substring(pos1 + "/Groups/".length(), pos2);
        }
        throw new IllegalArgumentException(jcrPath + " is not jcr path of a group wiki page node!");
    }

    public static List<NTVersion> getCurrentPageRevisions(Page wikipage) throws Exception {
        List<NTVersion> versionsList = Utils.getPageRevisions((PageImpl)wikipage);
        if (versionsList.size() == 0) {
            PageImpl pageImpl = (PageImpl)wikipage;
            pageImpl.checkin();
            pageImpl.checkout();
            pageImpl.getJCRSession().save();
            versionsList = Utils.getPageRevisions((PageImpl)wikipage);
        }
        return versionsList;
    }

    private static List<NTVersion> getPageRevisions(PageImpl pageImpl) throws Exception {
        Iterator<NTVersion> iter = pageImpl.getVersionableMixin().getVersionHistory().iterator();
        ArrayList<NTVersion> versionsList = new ArrayList<NTVersion>();
        while (iter.hasNext()) {
            NTVersion version = iter.next();
            if ("rootVersion".equals(version.getName())) continue;
            versionsList.add(version);
        }
        Collections.sort(versionsList, new VersionNameComparatorDesc());
        return versionsList;
    }

    public static String getUserIdByJcrPath(String jcrPath) throws IllegalArgumentException {
        int pos1 = jcrPath.indexOf("/Users/");
        int pos2 = jcrPath.indexOf("/ApplicationData");
        if (pos1 >= 0 && pos2 > 0) {
            return jcrPath.substring(pos1 + "/Users/".length(), pos2);
        }
        throw new IllegalArgumentException(jcrPath + " is not jcr path of a personal wiki page node!");
    }

    public static String getPortalIdByJcrPath(String jcrPath) throws IllegalArgumentException {
        String portalPath = Utils.getPortalWikisPath();
        int pos1 = jcrPath.indexOf(portalPath);
        if (pos1 >= 0) {
            String restPath = jcrPath.substring(pos1 + portalPath.length() + 1);
            return restPath.substring(0, restPath.indexOf("/"));
        }
        throw new IllegalArgumentException(jcrPath + " is not jcr path of a portal wiki page node!");
    }

    public static String getWikiType(String jcrPath) throws IllegalArgumentException {
        if (jcrPath.startsWith("/exo:applications/")) {
            return PortalConfig.PORTAL_TYPE;
        }
        if (jcrPath.startsWith("/Groups/")) {
            return PortalConfig.GROUP_TYPE;
        }
        if (jcrPath.startsWith("/Users/")) {
            return PortalConfig.USER_TYPE;
        }
        throw new IllegalArgumentException(jcrPath + " is not jcr path of a wiki page node!");
    }

    public static String validateWikiOwner(String wikiType, String wikiOwner) {
        if (wikiType != null && wikiType.equals(PortalConfig.GROUP_TYPE)) {
            if (wikiOwner == null || wikiOwner.length() == 0) {
                return "";
            }
            if (wikiOwner.startsWith("/")) {
                wikiOwner = wikiOwner.substring(1, wikiOwner.length());
            }
            if (wikiOwner.endsWith("/")) {
                wikiOwner = wikiOwner.substring(0, wikiOwner.length() - 1);
            }
        }
        return wikiOwner;
    }

    public static String getDefaultRestBaseURI() {
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        sb.append(PortalContainer.getCurrentPortalContainerName());
        sb.append("/");
        sb.append(PortalContainer.getCurrentRestContextName());
        return sb.toString();
    }

    public static String getCurrentRepositoryWebDavUri() {
        StringBuilder sb = new StringBuilder();
        sb.append(Utils.getDefaultRestBaseURI());
        sb.append(JCR_WEBDAV_SERVICE_BASE_URI);
        sb.append("/");
        RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
        try {
            sb.append(repositoryService.getCurrentRepository().getConfiguration().getName());
        }
        catch (RepositoryException e) {
            sb.append(repositoryService.getConfig().getDefaultRepositoryName());
        }
        sb.append("/");
        return sb.toString();
    }

    public static String getDocumentURL(WikiContext wikiContext) {
        if (wikiContext.getPortalURL() == null && wikiContext.getPortletURI() == null) {
            return wikiContext.getPageId();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(wikiContext.getPortalURL());
        sb.append(wikiContext.getPortletURI());
        sb.append("/");
        if (!PortalConfig.PORTAL_TYPE.equalsIgnoreCase(wikiContext.getType())) {
            sb.append(wikiContext.getType().toLowerCase());
            sb.append("/");
            sb.append(Utils.validateWikiOwner(wikiContext.getType(), wikiContext.getOwner()));
            sb.append("/");
        }
        sb.append(wikiContext.getPageId());
        return sb.toString();
    }

    public static String getCurrentUser() {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            return ConversationState.getCurrent().getIdentity().getUserId();
        }
        return null;
    }

    public static Collection<Wiki> getWikisByType(WikiType wikiType) {
        MOWService mowService = (MOWService)PortalContainer.getComponent(MOWService.class);
        WikiStoreImpl store = (WikiStoreImpl)mowService.getModel().getWikiStore();
        return store.getWikiContainer(wikiType).getAllWikis();
    }

    public static Wiki getWiki(WikiPageParams params) {
        MOWService mowService = (MOWService)PortalContainer.getComponent(MOWService.class);
        WikiStoreImpl store = (WikiStoreImpl)mowService.getModel().getWikiStore();
        if (params != null) {
            String wikiType = params.getType();
            String owner = params.getOwner();
            if (!StringUtils.isEmpty((String)wikiType) && !StringUtils.isEmpty((String)owner)) {
                return store.getWiki(WikiType.valueOf(wikiType.toUpperCase()), owner);
            }
        }
        return null;
    }

    public static Wiki[] getAllWikiSpace() {
        MOWService mowService = (MOWService)PortalContainer.getComponent(MOWService.class);
        WikiStoreImpl store = (WikiStoreImpl)mowService.getModel().getWikiStore();
        return store.getWikis().toArray(new Wiki[0]);
    }

    public static boolean isDescendantPage(PageImpl page, PageImpl parentPage) throws Exception {
        return page.getPath().startsWith(parentPage.getPath());
    }

    public static Object getObject(String path, String type) throws Exception {
        WikiService wservice = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
        return wservice.findByPath(path, type);
    }

    public static NTVersion getLastRevisionOfPage(Page wikipage) throws Exception {
        return Utils.getCurrentPageRevisions(wikipage).get(0);
    }

    public static Object getObjectFromParams(WikiPageParams param) throws Exception {
        WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
        MOWService mowService = (MOWService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MOWService.class);
        WikiStoreImpl store = (WikiStoreImpl)mowService.getModel().getWikiStore();
        String wikiType = param.getType();
        String wikiOwner = param.getOwner();
        String wikiPageId = param.getPageId();
        if (wikiOwner != null && wikiPageId != null) {
            if (!wikiPageId.equals("WikiHome")) {
                Page expandPage = wikiService.getPageByRootPermission(wikiType, wikiOwner, wikiPageId);
                return expandPage;
            }
            Object wiki = store.getWikiContainer(WikiType.valueOf(wikiType.toUpperCase())).getWiki(wikiOwner, true);
            WikiHome wikiHome = (WikiHome)wiki.getWikiHome();
            return wikiHome;
        }
        if (wikiOwner != null) {
            Object wiki = store.getWikiContainer(WikiType.valueOf(wikiType.toUpperCase())).getWiki(wikiOwner, true);
            return wiki;
        }
        if (wikiType != null) {
            return wikiType;
        }
        return null;
    }

    public static Stack<WikiPageParams> getStackParams(PageImpl page) throws Exception {
        Stack<WikiPageParams> stack = new Stack<WikiPageParams>();
        Wiki wiki = page.getWiki();
        if (wiki != null) {
            while (page != null) {
                stack.push(new WikiPageParams(wiki.getType(), wiki.getOwner(), page.getName()));
                page = page.getParentPage();
            }
        }
        return stack;
    }

    public static WikiPageParams getWikiPageParams(Page page) {
        Wiki wiki = ((PageImpl)page).getWiki();
        String wikiType = wiki.getType();
        WikiPageParams params = new WikiPageParams(wikiType, wiki.getOwner(), page.getName());
        return params;
    }

    public static void sendMailOnChangeContent(AttachmentImpl content) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        DiffService diffService = (DiffService)container.getComponentInstanceOfType(DiffService.class);
        RenderingService renderingService = (RenderingService)container.getComponentInstanceOfType(RenderingService.class);
        Message message = new Message();
        ConversationState conversationState = ConversationState.getCurrent();
        String author = conversationState.getIdentity().getUserId();
        PageImpl page = content.getParentPage();
        List<String> list = page.getWatchedMixin().getWatchers();
        ArrayList<String> emailList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            emailList.add(Utils.getEmailUser(list.get(i)));
        }
        String pageTitle = page.getTitle();
        String currentVersionContent = content.getText();
        NTVersion previousVersion = page.getVersionableMixin().getBaseVersion();
        String previousVersionContent = previousVersion.getNTFrozenNode().getContentString();
        DiffResult diffResult = diffService.getDifferencesAsHTML(previousVersionContent, currentVersionContent, false);
        String fullContent = renderingService.render(currentVersionContent, page.getSyntax(), Syntax.XHTML_1_0.toIdString(), false);
        if (diffResult.getChanges() == 0) {
            diffResult.setDiffHTML("No changes, new revision is created.");
        }
        StringBuilder sbt = new StringBuilder();
        sbt.append("<html>").append("  <head>").append("     <link rel=\"stylesheet\" href=\"" + renderingService.getCssURL() + "\" type=\"text/css\">").append("  </head>").append("  <body>").append("    Page <a href=\"" + CommonsUtils.getCurrentDomain() + page.getURL() + "\">" + page.getTitle() + "</a> is modified by " + page.getAuthor()).append("    <br/><br/>").append("    Changes(" + diffResult.getChanges() + ")").append("    <br/><br/>").append(Utils.insertStyle(diffResult.getDiffHTML())).append("    Full content: ").append("    <br/><br/>").append(fullContent).append("  </body>").append("</html>");
        message.setFrom(Utils.makeNotificationSender(author));
        message.setSubject("\"" + pageTitle + "\" page was modified");
        message.setMimeType(MIMETYPE_TEXTHTML);
        message.setBody(sbt.toString());
        MailService mailService = (MailService)container.getComponentInstanceOfType(MailService.class);
        for (String address : emailList) {
            message.setTo(address);
            try {
                mailService.sendMessage(message);
            }
            catch (Exception e) {
                if (!log_.isDebugEnabled()) continue;
                log_.debug((Object)String.format("Failed to send notification email to user: %s", address), (Throwable)e);
            }
        }
    }

    public static String getEmailUser(String userName) throws Exception {
        OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        User user = organizationService.getUserHandler().findUserByName(userName);
        String email = user.getEmail();
        return email;
    }

    public static boolean isWikiAvailable(String wikiType, String wikiOwner) {
        MOWService mowService = (MOWService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MOWService.class);
        ModelImpl model = mowService.getModel();
        WikiStoreImpl wStore = (WikiStoreImpl)model.getWikiStore();
        WikiContainer container = wStore.getWikiContainer(WikiType.valueOf(wikiType.toUpperCase()));
        return container.contains(wikiOwner) != null;
    }

    public static HashMap<String, IDType> getACLForAdmins() {
        HashMap<String, IDType> permissionMap = new HashMap<String, IDType>();
        UserACL userACL = (UserACL)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserACL.class);
        permissionMap.put(userACL.getSuperUser(), IDType.USER);
        for (String group : userACL.getPortalCreatorGroups()) {
            if (StringUtils.isEmpty((String)group)) continue;
            permissionMap.put(group, IDType.MEMBERSHIP);
        }
        return permissionMap;
    }

    public static boolean hasPermission(AccessControlList acl, String[] permission, Identity user) {
        String userId = user.getUserId();
        if (userId.equals(IdentityConstants.SYSTEM)) {
            return true;
        }
        if (userId.equals(acl.getOwner())) {
            return true;
        }
        if (userId.equals(IdentityConstants.ANONIM)) {
            List anyPermissions = acl.getPermissions(IdentityConstants.ANY);
            if (anyPermissions.size() < permission.length) {
                return false;
            }
            for (int i = 0; i < permission.length; ++i) {
                if (anyPermissions.contains(permission[i])) continue;
                return false;
            }
            return true;
        }
        if (acl.getPermissionsSize() > 0 && permission.length > 0) {
            for (int i = 0; i < permission.length; ++i) {
                if (Utils.isPermissionMatch(acl.getPermissionEntries(), permission[i], user)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isPermissionMatch(List<AccessControlEntry> existedPermission, String testPermission, Identity user) {
        int length = existedPermission.size();
        for (int i = 0; i < length; ++i) {
            AccessControlEntry ace = existedPermission.get(i);
            if (!testPermission.equals(ace.getPermission())) continue;
            if (IdentityConstants.ANY.equals(ace.getIdentity())) {
                return true;
            }
            if (!(ace.getIdentity().indexOf(":") == -1 ? ace.getIdentity().equals(user.getUserId()) : user.isMemberOf(ace.getMembershipEntry()))) continue;
            return true;
        }
        return false;
    }

    private static String makeNotificationSender(String from) {
        InternetAddress addr = null;
        if (from == null) {
            return null;
        }
        try {
            addr = new InternetAddress(from);
        }
        catch (AddressException e) {
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"value of 'from' field in message made by forum notification feature is not in format of mail address", (Throwable)e);
            }
            return null;
        }
        Properties props = new Properties(System.getProperties());
        String mailAddr = props.getProperty("gatein.email.smtp.from");
        if (mailAddr == null || mailAddr.length() == 0) {
            mailAddr = props.getProperty("mail.from");
        }
        if (mailAddr != null) {
            try {
                InternetAddress serMailAddr = new InternetAddress(mailAddr);
                addr.setAddress(serMailAddr.getAddress());
                return addr.toUnicodeString();
            }
            catch (AddressException e) {
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)"value of 'gatein.email.smtp.from' or 'mail.from' in configuration file is not in format of mail address", (Throwable)e);
                }
                return null;
            }
        }
        return null;
    }

    private static String insertStyle(String rawHTML) {
        String result = rawHTML;
        result = result.replaceAll("class=\"diffaddword\"", "style=\"background: #b5ffbf;\"");
        result = result.replaceAll("<span class=\"diffremoveword\">", "<span style=\" background: #ffd8da;text-decoration: line-through;\">");
        result = result.replaceAll("<pre class=\"diffremoveword\">", "<pre style=\" background: #ffd8da;\">");
        return result;
    }

    public static String getURL(String url, String verName) {
        StringBuffer strBuffer = new StringBuffer(url);
        strBuffer.append("?").append("action").append("=").append(COMPARE_REVISION).append("&").append(VER_NAME).append("=").append(verName);
        return strBuffer.toString();
    }

    public static SessionProvider createSystemProvider() {
        SessionProviderService sessionProviderService = (SessionProviderService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SessionProviderService.class);
        return sessionProviderService.getSystemSessionProvider(null);
    }

    public static long countSearchResult(WikiSearchData data) throws Exception {
        data.setOffset(0L);
        data.setLimit(Integer.MAX_VALUE);
        WikiService wikiservice = (WikiService)PortalContainer.getComponent(WikiService.class);
        PageList<SearchResult> results = wikiservice.search(data);
        return results.getAll().size();
    }

    public static String getNodeTypeCssClass(AttachmentImpl attachment, String append) throws Exception {
        Class<?> dmsMimeTypeResolverClass = Class.forName("org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver");
        Object dmsMimeTypeResolverObject = dmsMimeTypeResolverClass.getDeclaredMethod("getInstance", null).invoke(null, null);
        Object mimeType = dmsMimeTypeResolverClass.getMethod("getMimeType", String.class).invoke(dmsMimeTypeResolverObject, new String(attachment.getFullTitle().toLowerCase()));
        StringBuilder cssClass = new StringBuilder();
        cssClass.append(append);
        cssClass.append("FileDefault");
        cssClass.append(" ");
        cssClass.append(append);
        cssClass.append("nt_file");
        cssClass.append(" ");
        cssClass.append(append);
        cssClass.append(((String)mimeType).replaceAll("/|\\.", ""));
        return cssClass.toString();
    }

    public static String getRestContextName() {
        return org.exoplatform.wiki.rendering.util.Utils.getRestContextName();
    }
}

