/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service.process;

import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;

public abstract class NotificationProcess {
    private NotificationProcess next;

    public void setNext(NotificationProcess next) {
        this.next = next;
    }

    public NotificationProcess getNext() {
        return this.next;
    }

    public void process(UserSetting setting, NotificationInfo notification) {
        if (this.isValid(setting, notification)) {
            this.doProcess(setting, notification);
            this.processNext(setting, notification);
        }
    }

    private void processNext(UserSetting setting, NotificationInfo notification) {
        if (this.getNext().isValid(setting, notification) && this.getNext() != null) {
            this.getNext().process(setting, notification);
        }
    }

    abstract void doProcess(UserSetting var1, NotificationInfo var2);

    abstract boolean isValid(UserSetting var1, NotificationInfo var2);
}

