/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.setting;

import groovy.text.GStringTemplateEngine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.api.notification.model.NotificationKey;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationChildPlugin;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationPlugin;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.setting.PluginContainer;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.notification.template.ResourceBundleConfigDeployer;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.WebAppListener;
import org.picocontainer.Startable;

public class NotificationPluginContainer
implements PluginContainer,
Startable {
    private static final Log LOG = ExoLogger.getLogger(NotificationPluginContainer.class);
    private final Map<NotificationKey, AbstractNotificationPlugin> pluginMap = new HashMap<NotificationKey, AbstractNotificationPlugin>();
    private GStringTemplateEngine gTemplateEngine;
    private final Map<NotificationKey, List<NotificationKey>> parentChildrenKeysMap = new HashMap<NotificationKey, List<NotificationKey>>();
    private PluginSettingService pSettingService = CommonsUtils.getService(PluginSettingService.class);
    private ResourceBundleConfigDeployer deployer = new ResourceBundleConfigDeployer();

    public NotificationPluginContainer() {
        this.gTemplateEngine = new GStringTemplateEngine();
    }

    public void start() {
        HashSet<String> datas = new HashSet<String>();
        for (AbstractNotificationPlugin plugin : this.pluginMap.values()) {
            boolean isChild = plugin instanceof AbstractNotificationChildPlugin;
            for (PluginConfig pluginConfig : plugin.getPluginConfigs()) {
                this.pSettingService.registerPluginConfig(pluginConfig.isChildPlugin(isChild));
                datas.add(pluginConfig.getTemplateConfig().getBundlePath());
            }
        }
        if (ServletContainerFactory.getServletContainer().addWebAppListener((WebAppListener)this.deployer)) {
            this.deployer.initBundlePath(datas);
        }
    }

    public void stop() {
        ServletContainerFactory.getServletContainer().removeWebAppListener((WebAppListener)this.deployer);
    }

    public AbstractNotificationPlugin getPlugin(NotificationKey key) {
        return this.pluginMap.get(key);
    }

    public List<NotificationKey> getChildPluginKeys(NotificationKey parentKey) {
        List<NotificationKey> keys = this.parentChildrenKeysMap.get(parentKey);
        if (keys != null) {
            return keys;
        }
        return new ArrayList<NotificationKey>();
    }

    public void addChildPlugin(AbstractNotificationChildPlugin plugin) {
        this.registerPlugin((AbstractNotificationPlugin)plugin);
        List parentIds = plugin.getParentPluginIds();
        for (String parentId : parentIds) {
            NotificationKey parentKey = new NotificationKey(parentId);
            List<NotificationKey> childrenKeys = this.parentChildrenKeysMap.containsKey(parentKey) ? this.parentChildrenKeysMap.get(parentKey) : new ArrayList<NotificationKey>();
            childrenKeys.add(plugin.getKey());
            this.parentChildrenKeysMap.put(parentKey, childrenKeys);
        }
    }

    public void addPlugin(AbstractNotificationPlugin plugin) {
        this.registerPlugin(plugin);
    }

    private void registerPlugin(AbstractNotificationPlugin plugin) {
        try {
            String templatePath = ((PluginConfig)plugin.getPluginConfigs().get(0)).getTemplateConfig().getTemplatePath();
            String template = TemplateUtils.loadGroovyTemplate(templatePath);
            plugin.setTemplateEngine(this.gTemplateEngine.createTemplate(template));
        }
        catch (Exception e) {
            LOG.debug((Object)("Failed to register notification plugin " + plugin.getId()));
        }
        this.pluginMap.put(plugin.getKey(), plugin);
    }

    public boolean remove(NotificationKey key) {
        this.pluginMap.remove(key);
        return true;
    }
}

