/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;

public class MultiListAccess
implements ListAccess {
    private boolean removeDuplicated;
    private List<ListAccess> list = new LinkedList<ListAccess>();

    public MultiListAccess() {
        this(false);
    }

    public MultiListAccess(boolean removeDuplicated) {
        this.removeDuplicated = removeDuplicated;
    }

    public Object[] load(int index, int length) throws IllegalArgumentException, Exception {
        AbstractCollection data = this.removeDuplicated ? new LinkedHashSet() : new LinkedList();
        for (ListAccess item : this.list) {
            Object[] loaded = item.load(index, length);
            int loadedSize = data.size();
            if (loaded != null) {
                data.addAll(Arrays.asList(loaded));
                loadedSize = data.size() - loadedSize;
            }
            if (length != -1 && loadedSize >= length) break;
            index = loaded.length > 0 ? 0 : index - item.getSize();
            length -= loadedSize;
        }
        return data.toArray();
    }

    public void add(ListAccess item) {
        this.list.add(item);
    }

    public void clear() {
        this.list.clear();
    }

    public int getSize() throws Exception {
        if (this.removeDuplicated) {
            return this.load(0, -1).length;
        }
        int size = 0;
        for (ListAccess item : this.list) {
            size += item.getSize();
        }
        return size;
    }

    public boolean isRemoveDuplicated() {
        return this.removeDuplicated;
    }
}

