/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.calendar.service.PopupReminderJob;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.job.MultiTenancyJob;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class ReminderJob
extends MultiTenancyJob {
    private static Log log_ = ExoLogger.getLogger(ReminderJob.class);

    public Class<? extends MultiTenancyJob.MultiTenancyTask> getTask() {
        return ReminderTask.class;
    }

    public class ReminderTask
    extends MultiTenancyJob.MultiTenancyTask {
        public ReminderTask(JobExecutionContext context, String repoName) {
            super((MultiTenancyJob)ReminderJob.this, context, repoName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            super.run();
            try (SessionProvider provider = SessionProvider.createSystemProvider();){
                MailService mailService = (MailService)this.container.getComponentInstanceOfType(MailService.class);
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)"Calendar email reminder service");
                }
                Calendar fromCalendar = GregorianCalendar.getInstance();
                JobDataMap jdatamap = this.context.getJobDetail().getJobDataMap();
                Node calendarHome = Utils.getPublicServiceHome(provider);
                if (calendarHome == null) {
                    return;
                }
                StringBuffer path = new StringBuffer(PopupReminderJob.getReminderPath(fromCalendar, provider));
                path.append("//element(*,exo:reminder)");
                path.append("[@exo:remindDateTime <= xs:dateTime('" + ISO8601.format((Calendar)fromCalendar) + "') and @exo:isOver = 'false' and @exo:reminderType = 'email' ]");
                QueryManager queryManager = Utils.getSession(provider).getWorkspace().getQueryManager();
                Query query = queryManager.createQuery(path.toString(), "xpath");
                QueryResult results = query.execute();
                NodeIterator iter = results.getNodes();
                while (iter.hasNext()) {
                    Node reminder = iter.nextNode();
                    boolean isRepeat = reminder.getProperty("exo:isRepeat").getBoolean();
                    long fromTime = reminder.getProperty("exo:fromDateTime").getDate().getTimeInMillis();
                    long remindTime = reminder.getProperty("exo:remindDateTime").getDate().getTimeInMillis();
                    long interval = reminder.getProperty("exo:timeInterval").getLong() * 60L * 1000L;
                    String to = reminder.getProperty("exo:email").getString();
                    if (to == null || to.length() <= 0) continue;
                    Message message = new Message();
                    message.setMimeType("text/html");
                    message.setTo(to);
                    message.setSubject("[reminder] eXo calendar notify mail !");
                    message.setBody(reminder.getProperty("exo:description").getString());
                    message.setFrom(jdatamap.getString("account"));
                    if (isRepeat) {
                        if (fromCalendar.getTimeInMillis() >= fromTime) {
                            reminder.setProperty("exo:isOver", true);
                        } else if (remindTime + interval > fromTime) {
                            reminder.setProperty("exo:isOver", true);
                        } else {
                            long nextReminderTime;
                            long currentTime = fromCalendar.getTimeInMillis();
                            for (nextReminderTime = remindTime + interval; nextReminderTime <= currentTime; nextReminderTime += interval) {
                            }
                            GregorianCalendar cal = new GregorianCalendar();
                            cal.setTimeInMillis(nextReminderTime);
                            reminder.setProperty("exo:remindDateTime", (Calendar)cal);
                            reminder.setProperty("exo:isOver", false);
                        }
                    } else {
                        reminder.setProperty("exo:isOver", true);
                    }
                    reminder.save();
                    mailService.sendMessage(message);
                }
            }
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"File plan job done");
            }
        }
    }
}

