/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.task;

import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.common.InitParamsValue;
import org.exoplatform.forum.common.persister.Persister;
import org.exoplatform.forum.common.persister.PersisterTask;
import org.exoplatform.forum.service.task.AbstractForumTask;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class AbstractForumTaskManager<T extends AbstractForumTask>
implements Persister {
    private static final Log LOG = ExoLogger.getLogger(AbstractForumTaskManager.class);
    private static final String INTERVAL_TASK_PERSIST_THRESHOLD_KEY = "intervalPersist";
    private static final String PERSISTER_THRESHOLD_KEY = "persisterThreshold";
    private PersisterTask persisterTask;
    private long INTERVAL_TASK_PERSIST_THRESHOLD = 5000L;
    private int PERSISTER_THRESHOLD = 20;
    private Queue<T> tasks = null;
    private CountDownLatch doneSignal;

    public AbstractForumTaskManager(InitParams params) {
        long interval_task = InitParamsValue.getLong((InitParams)params, (String)INTERVAL_TASK_PERSIST_THRESHOLD_KEY, (long)this.INTERVAL_TASK_PERSIST_THRESHOLD);
        int persisterThreshold = InitParamsValue.getInteger((InitParams)params, (String)PERSISTER_THRESHOLD_KEY, (int)this.PERSISTER_THRESHOLD);
        this.persisterTask = PersisterTask.init().persister((Persister)this).wakeup(interval_task).timeUnit(TimeUnit.MILLISECONDS).maxFixedSize((long)persisterThreshold).build();
        this.persisterTask.start();
    }

    public void commit(boolean forceCommit) {
        this.persist(forceCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist(boolean forceCommit) {
        if (this.tasks != null && (this.persisterTask.shoudldPersist(this.tasks.size()) || forceCommit)) {
            Queue<T> processTasks = this.popTasks();
            try {
                AbstractForumTask task;
                RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                this.doneSignal = new CountDownLatch(processTasks.size());
                while ((task = (AbstractForumTask)processTasks.poll()) != null) {
                    try {
                        task.run();
                        this.doneSignal.countDown();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)String.format("The task %s running unsuccessful.", task.getClass().getName()));
                        LOG.debug((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            finally {
                processTasks = null;
                RequestLifeCycle.end();
            }
        }
    }

    private Queue<T> popTasks() {
        Queue<T> tmp = this.tasks;
        this.tasks = null;
        LinkedBlockingQueue<AbstractForumTask> processTasks = new LinkedBlockingQueue<AbstractForumTask>();
        for (AbstractForumTask forumTask : tmp) {
            if (processTasks.contains(forumTask)) continue;
            processTasks.add(forumTask);
        }
        return processTasks;
    }

    public void addTask(T task) {
        if (this.tasks == null) {
            this.tasks = new LinkedBlockingQueue<T>();
        }
        this.tasks.add(task);
        this.commit(false);
    }

    public CountDownLatch doneSignal() {
        return this.doneSignal != null ? this.doneSignal : new CountDownLatch(0);
    }

    public void clear() {
        if (this.tasks != null) {
            this.tasks.clear();
        }
    }
}

